/*
 * Decompiled with CFR 0.152.
 */
package de.odysseus.el.tree.impl;

import de.odysseus.el.misc.LocalMessages;
import java.util.HashMap;

public class Scanner {
    private static final HashMap<String, Token> KEYMAP = new HashMap();
    private static final HashMap<Symbol, Token> FIXMAP = new HashMap();
    private Token token;
    private int position;
    protected final String input;
    protected final StringBuilder builder = new StringBuilder();

    private static void addFixToken(Token token) {
        FIXMAP.put(token.getSymbol(), token);
    }

    private static void addKeyToken(Token token) {
        KEYMAP.put(token.getImage(), token);
    }

    protected Scanner(String string) {
        this.input = string;
    }

    protected Token getToken() {
        return this.token;
    }

    protected int getPosition() {
        return this.position;
    }

    protected boolean isDigit(char c) {
        return c >= '0' && c <= '9';
    }

    protected Token keyword(String string) {
        return KEYMAP.get(string);
    }

    protected Token fixed(Symbol symbol) {
        return FIXMAP.get((Object)symbol);
    }

    protected Token token(Symbol symbol, String string, int n) {
        return new Token(symbol, string, n);
    }

    protected boolean isEval() {
        return this.token != null && this.token.getSymbol() != Symbol.TEXT && this.token.getSymbol() != Symbol.END_EVAL;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Token nextText() throws ScanException {
        int n;
        this.builder.setLength(0);
        int n2 = this.input.length();
        boolean bl = false;
        block4: for (n = this.position; n < n2; ++n) {
            char c = this.input.charAt(n);
            switch (c) {
                case '\\': {
                    if (bl) {
                        this.builder.append('\\');
                        continue block4;
                    }
                    bl = true;
                    continue block4;
                }
                case '#': 
                case '$': {
                    if (n + 1 < n2 && this.input.charAt(n + 1) == '{') {
                        if (!bl) return this.token(Symbol.TEXT, this.builder.toString(), n - this.position);
                        this.builder.append(c);
                    } else {
                        if (bl) {
                            this.builder.append('\\');
                        }
                        this.builder.append(c);
                    }
                    bl = false;
                    continue block4;
                }
                default: {
                    if (bl) {
                        this.builder.append('\\');
                    }
                    this.builder.append(c);
                    bl = false;
                }
            }
        }
        if (!bl) return this.token(Symbol.TEXT, this.builder.toString(), n - this.position);
        this.builder.append('\\');
        return this.token(Symbol.TEXT, this.builder.toString(), n - this.position);
    }

    protected Token nextString() throws ScanException {
        this.builder.setLength(0);
        char c = this.input.charAt(this.position);
        int n = this.position + 1;
        int n2 = this.input.length();
        while (n < n2) {
            char c2;
            if ((c2 = this.input.charAt(n++)) == '\\') {
                if (n == n2) {
                    throw new ScanException(this.position, "unterminated string", c + " or \\");
                }
                if ((c2 = this.input.charAt(n++)) == '\\' || c2 == c) {
                    this.builder.append(c2);
                    continue;
                }
                throw new ScanException(this.position, "invalid escape sequence \\" + c2, "\\" + c + " or \\\\");
            }
            if (c2 == c) {
                return this.token(Symbol.STRING, this.builder.toString(), n - this.position);
            }
            this.builder.append(c2);
        }
        throw new ScanException(this.position, "unterminated string", String.valueOf(c));
    }

    protected Token nextNumber() throws ScanException {
        int n;
        int n2 = this.input.length();
        for (n = this.position; n < n2 && this.isDigit(this.input.charAt(n)); ++n) {
        }
        Symbol symbol = Symbol.INTEGER;
        if (n < n2 && this.input.charAt(n) == '.') {
            ++n;
            while (n < n2 && this.isDigit(this.input.charAt(n))) {
                ++n;
            }
            symbol = Symbol.FLOAT;
        }
        if (n < n2 && (this.input.charAt(n) == 'e' || this.input.charAt(n) == 'E')) {
            int n3 = n++;
            if (n < n2 && (this.input.charAt(n) == '+' || this.input.charAt(n) == '-')) {
                ++n;
            }
            if (n < n2 && this.isDigit(this.input.charAt(n))) {
                ++n;
                while (n < n2 && this.isDigit(this.input.charAt(n))) {
                    ++n;
                }
                symbol = Symbol.FLOAT;
            } else {
                n = n3;
            }
        }
        return this.token(symbol, this.input.substring(this.position, n), n - this.position);
    }

    protected Token nextEval() throws ScanException {
        char c = this.input.charAt(this.position);
        char c2 = this.position < this.input.length() - 1 ? this.input.charAt(this.position + 1) : (char)'\u0000';
        switch (c) {
            case '*': {
                return this.fixed(Symbol.MUL);
            }
            case '/': {
                return this.fixed(Symbol.DIV);
            }
            case '%': {
                return this.fixed(Symbol.MOD);
            }
            case '+': {
                return this.fixed(Symbol.PLUS);
            }
            case '-': {
                return this.fixed(Symbol.MINUS);
            }
            case '?': {
                return this.fixed(Symbol.QUESTION);
            }
            case ':': {
                return this.fixed(Symbol.COLON);
            }
            case '[': {
                return this.fixed(Symbol.LBRACK);
            }
            case ']': {
                return this.fixed(Symbol.RBRACK);
            }
            case '(': {
                return this.fixed(Symbol.LPAREN);
            }
            case ')': {
                return this.fixed(Symbol.RPAREN);
            }
            case ',': {
                return this.fixed(Symbol.COMMA);
            }
            case '.': {
                if (this.isDigit(c2)) break;
                return this.fixed(Symbol.DOT);
            }
            case '=': {
                if (c2 != '=') break;
                return this.fixed(Symbol.EQ);
            }
            case '&': {
                if (c2 != '&') break;
                return this.fixed(Symbol.AND);
            }
            case '|': {
                if (c2 != '|') break;
                return this.fixed(Symbol.OR);
            }
            case '!': {
                if (c2 == '=') {
                    return this.fixed(Symbol.NE);
                }
                return this.fixed(Symbol.NOT);
            }
            case '<': {
                if (c2 == '=') {
                    return this.fixed(Symbol.LE);
                }
                return this.fixed(Symbol.LT);
            }
            case '>': {
                if (c2 == '=') {
                    return this.fixed(Symbol.GE);
                }
                return this.fixed(Symbol.GT);
            }
            case '\"': 
            case '\'': {
                return this.nextString();
            }
        }
        if (this.isDigit(c) || c == '.') {
            return this.nextNumber();
        }
        if (Character.isJavaIdentifierStart(c)) {
            int n;
            int n2 = this.input.length();
            for (n = this.position + 1; n < n2 && Character.isJavaIdentifierPart(this.input.charAt(n)); ++n) {
            }
            String string = this.input.substring(this.position, n);
            Token token = this.keyword(string);
            return token == null ? this.token(Symbol.IDENTIFIER, string, n - this.position) : token;
        }
        throw new ScanException(this.position, "invalid character '" + c + "'", "expression token");
    }

    protected Token nextToken() throws ScanException {
        if (this.token != null) {
            this.position += this.token.getSize();
        }
        int n = this.input.length();
        if (this.isEval()) {
            while (this.position < n && Character.isWhitespace(this.input.charAt(this.position))) {
                ++this.position;
            }
        }
        if (this.position == n) {
            return this.fixed(Symbol.EOF);
        }
        if (this.isEval()) {
            if (this.input.charAt(this.position) == '}') {
                return this.fixed(Symbol.END_EVAL);
            }
            return this.nextEval();
        }
        if (this.position + 1 < n && this.input.charAt(this.position + 1) == '{') {
            switch (this.input.charAt(this.position)) {
                case '#': {
                    return this.fixed(Symbol.START_EVAL_DEFERRED);
                }
                case '$': {
                    return this.fixed(Symbol.START_EVAL_DYNAMIC);
                }
            }
        }
        return this.nextText();
    }

    public Token next() throws ScanException {
        this.token = this.nextToken();
        return this.token;
    }

    static {
        Scanner.addFixToken(new Token(Symbol.PLUS, "+"));
        Scanner.addFixToken(new Token(Symbol.MINUS, "-"));
        Scanner.addFixToken(new Token(Symbol.MUL, "*"));
        Scanner.addFixToken(new Token(Symbol.DIV, "/"));
        Scanner.addFixToken(new Token(Symbol.MOD, "%"));
        Scanner.addFixToken(new Token(Symbol.LPAREN, "("));
        Scanner.addFixToken(new Token(Symbol.RPAREN, ")"));
        Scanner.addFixToken(new Token(Symbol.NOT, "!"));
        Scanner.addFixToken(new Token(Symbol.AND, "&&"));
        Scanner.addFixToken(new Token(Symbol.OR, "||"));
        Scanner.addFixToken(new Token(Symbol.EQ, "=="));
        Scanner.addFixToken(new Token(Symbol.NE, "!="));
        Scanner.addFixToken(new Token(Symbol.LT, "<"));
        Scanner.addFixToken(new Token(Symbol.LE, "<="));
        Scanner.addFixToken(new Token(Symbol.GT, ">"));
        Scanner.addFixToken(new Token(Symbol.GE, ">="));
        Scanner.addFixToken(new Token(Symbol.QUESTION, "?"));
        Scanner.addFixToken(new Token(Symbol.COLON, ":"));
        Scanner.addFixToken(new Token(Symbol.COMMA, ","));
        Scanner.addFixToken(new Token(Symbol.DOT, "."));
        Scanner.addFixToken(new Token(Symbol.LBRACK, "["));
        Scanner.addFixToken(new Token(Symbol.RBRACK, "]"));
        Scanner.addFixToken(new Token(Symbol.START_EVAL_DEFERRED, "#{"));
        Scanner.addFixToken(new Token(Symbol.START_EVAL_DYNAMIC, "${"));
        Scanner.addFixToken(new Token(Symbol.END_EVAL, "}"));
        Scanner.addFixToken(new Token(Symbol.EOF, null, 0));
        Scanner.addKeyToken(new Token(Symbol.NULL, "null"));
        Scanner.addKeyToken(new Token(Symbol.TRUE, "true"));
        Scanner.addKeyToken(new Token(Symbol.FALSE, "false"));
        Scanner.addKeyToken(new Token(Symbol.EMPTY, "empty"));
        Scanner.addKeyToken(new Token(Symbol.DIV, "div"));
        Scanner.addKeyToken(new Token(Symbol.MOD, "mod"));
        Scanner.addKeyToken(new Token(Symbol.NOT, "not"));
        Scanner.addKeyToken(new Token(Symbol.AND, "and"));
        Scanner.addKeyToken(new Token(Symbol.OR, "or"));
        Scanner.addKeyToken(new Token(Symbol.LE, "le"));
        Scanner.addKeyToken(new Token(Symbol.LT, "lt"));
        Scanner.addKeyToken(new Token(Symbol.EQ, "eq"));
        Scanner.addKeyToken(new Token(Symbol.NE, "ne"));
        Scanner.addKeyToken(new Token(Symbol.GE, "ge"));
        Scanner.addKeyToken(new Token(Symbol.GT, "gt"));
        Scanner.addKeyToken(new Token(Symbol.INSTANCEOF, "instanceof"));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Symbol {
        EOF,
        PLUS("'+'"),
        MINUS("'-'"),
        MUL("'*'"),
        DIV("'/'|'div'"),
        MOD("'%'|'mod'"),
        LPAREN("'('"),
        RPAREN("')'"),
        IDENTIFIER,
        NOT("'!'|'not'"),
        AND("'&&'|'and'"),
        OR("'||'|'or'"),
        EMPTY("'empty'"),
        INSTANCEOF("'instanceof'"),
        INTEGER,
        FLOAT,
        TRUE("'true'"),
        FALSE("'false'"),
        STRING,
        NULL("'null'"),
        LE("'<='|'le'"),
        LT("'<'|'lt'"),
        GE("'>='|'ge'"),
        GT("'>'|'gt'"),
        EQ("'=='|'eq'"),
        NE("'!='|'ne'"),
        QUESTION("'?'"),
        COLON("':'"),
        TEXT,
        DOT("'.'"),
        LBRACK("'['"),
        RBRACK("']'"),
        COMMA("','"),
        START_EVAL_DEFERRED("'#{'"),
        START_EVAL_DYNAMIC("'${'"),
        END_EVAL("'}'"),
        EXTENSION;

        private final String string;

        private Symbol() {
            this(null);
        }

        private Symbol(String string2) {
            this.string = string2;
        }

        public String toString() {
            return this.string == null ? "<" + this.name() + ">" : this.string;
        }
    }

    public static class ExtensionToken
    extends Token {
        public ExtensionToken(String string) {
            super(Symbol.EXTENSION, string);
        }
    }

    public static class Token {
        private final Symbol symbol;
        private final String image;
        private final int length;

        public Token(Symbol symbol, String string) {
            this(symbol, string, string.length());
        }

        public Token(Symbol symbol, String string, int n) {
            this.symbol = symbol;
            this.image = string;
            this.length = n;
        }

        public Symbol getSymbol() {
            return this.symbol;
        }

        public String getImage() {
            return this.image;
        }

        public int getSize() {
            return this.length;
        }

        public String toString() {
            return this.symbol.toString();
        }
    }

    public static class ScanException
    extends Exception {
        final int position;
        final String encountered;
        final String expected;

        public ScanException(int n, String string, String string2) {
            super(LocalMessages.get("error.scan", n, string, string2));
            this.position = n;
            this.encountered = string;
            this.expected = string2;
        }
    }
}

