/*
 * Decompiled with CFR 0.152.
 */
package de.odysseus.el.tree.impl.ast;

import de.odysseus.el.misc.LocalMessages;
import de.odysseus.el.tree.Bindings;
import de.odysseus.el.tree.FunctionNode;
import de.odysseus.el.tree.impl.ast.AstInvocation;
import de.odysseus.el.tree.impl.ast.AstNode;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import javax.el.ELContext;
import javax.el.ELException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AstFunction
extends AstInvocation
implements FunctionNode {
    private final int index;

    public AstFunction(String string, int n, List<AstNode> list) {
        this(string, n, list, false);
    }

    public AstFunction(String string, int n, List<AstNode> list, boolean bl) {
        super(string, list, bl);
        this.index = n;
    }

    @Override
    public Object eval(Bindings bindings, ELContext eLContext) {
        Method method = bindings.getFunction(this.index);
        try {
            return this.invoke(bindings, eLContext, null, method);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new ELException(LocalMessages.get("error.function.access", this.name), (Throwable)illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new ELException(LocalMessages.get("error.function.invocation", this.name), invocationTargetException.getCause());
        }
    }

    public String toString() {
        return this.name + "(...)";
    }

    @Override
    public void appendStructure(StringBuilder stringBuilder, Bindings bindings) {
        stringBuilder.append(bindings != null && bindings.isFunctionBound(this.index) ? "<fn>" : this.name);
        stringBuilder.append("(");
        if (this.getCardinality() > 0) {
            ((AstNode)this.nodes.get(0)).appendStructure(stringBuilder, bindings);
            for (int i = 1; i < this.getCardinality(); ++i) {
                stringBuilder.append(", ");
                ((AstNode)this.nodes.get(i)).appendStructure(stringBuilder, bindings);
            }
        }
        stringBuilder.append(")");
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int getCardinality() {
        return this.getParamCount();
    }

    @Override
    public AstNode getChild(int n) {
        return this.getParam(n);
    }
}

