/*
 * Decompiled with CFR 0.152.
 */
package de.odysseus.el.tree.impl.ast;

import de.odysseus.el.misc.LocalMessages;
import de.odysseus.el.misc.MethodInvocation;
import de.odysseus.el.tree.Bindings;
import de.odysseus.el.tree.impl.ast.AstInvocation;
import de.odysseus.el.tree.impl.ast.AstNode;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import javax.el.ELContext;
import javax.el.ELException;
import javax.el.MethodInfo;
import javax.el.MethodNotFoundException;
import javax.el.PropertyNotFoundException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AstMethod
extends AstInvocation {
    protected final AstNode prefix;
    protected final MethodInvocation property = new MethodInvocation(){

        public String getName() {
            return AstMethod.this.getName();
        }

        public int getParamCount() {
            return AstMethod.this.getParamCount();
        }

        public boolean isVarArgs() {
            return AstMethod.this.isVarArgs();
        }

        public String toString() {
            return AstMethod.this.getName();
        }
    };

    public AstMethod(AstNode astNode, String string, List<AstNode> list, boolean bl) {
        super(string, list, bl);
        this.prefix = astNode;
    }

    protected Method resolveMethod(ELContext eLContext, Object object) throws MethodNotFoundException {
        Object object2 = null;
        try {
            object2 = eLContext.getELResolver().getValue(eLContext, object, (Object)this.property);
        }
        catch (PropertyNotFoundException propertyNotFoundException) {
            throw new MethodNotFoundException(LocalMessages.get("error.property.method.resolve", this.name, object.getClass()));
        }
        if (!eLContext.isPropertyResolved()) {
            throw new MethodNotFoundException(LocalMessages.get("error.property.method.resolve", this.name, object.getClass()));
        }
        Method method = null;
        if (object2 instanceof Method) {
            method = (Method)object2;
        } else if (object2 instanceof MethodInfo) {
            try {
                method = object2.getClass().getMethod(this.name, ((MethodInfo)object2).getParamTypes());
            }
            catch (NoSuchMethodException noSuchMethodException) {
                throw new MethodNotFoundException(LocalMessages.get("error.property.method.notfound", this.name, object.getClass()), (Throwable)noSuchMethodException);
            }
        } else {
            throw new MethodNotFoundException(LocalMessages.get("error.property.method.notfound", this.name, object.getClass()));
        }
        return method;
    }

    @Override
    public Object eval(Bindings bindings, ELContext eLContext) {
        Object object = this.prefix.eval(bindings, eLContext);
        if (object == null) {
            throw new MethodNotFoundException(LocalMessages.get("error.property.base.null", this.prefix));
        }
        Method method = this.resolveMethod(eLContext, object);
        if (this.varargs && method.isVarArgs() ? method.getParameterTypes().length > this.getParamCount() + 1 : method.getParameterTypes().length != this.getParamCount()) {
            throw new ELException(LocalMessages.get("error.property.method.invocation", this.name, object.getClass()));
        }
        try {
            return this.invoke(bindings, eLContext, object, method);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new ELException(LocalMessages.get("error.property.method.access", this.name, object.getClass()));
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new ELException(LocalMessages.get("error.property.method.invocation", this.name, object.getClass()), invocationTargetException.getCause());
        }
    }

    public String toString() {
        return ". " + this.name + "(...)";
    }

    @Override
    public void appendStructure(StringBuilder stringBuilder, Bindings bindings) {
        this.prefix.appendStructure(stringBuilder, bindings);
        stringBuilder.append(".");
        stringBuilder.append(this.name);
        stringBuilder.append("(");
        if (this.nodes != null && this.nodes.size() > 0) {
            ((AstNode)this.nodes.get(0)).appendStructure(stringBuilder, bindings);
            for (int i = 1; i < this.nodes.size(); ++i) {
                stringBuilder.append(", ");
                ((AstNode)this.nodes.get(i)).appendStructure(stringBuilder, bindings);
            }
        }
        stringBuilder.append(")");
    }

    @Override
    public int getCardinality() {
        return 1 + this.getParamCount();
    }

    @Override
    public AstNode getChild(int n) {
        return n == 0 ? this.prefix : this.getParam(n - 1);
    }
}

