/*
 * Decompiled with CFR 0.152.
 */
package com.blazemeter.jmeter.threads;

import com.blazemeter.jmeter.control.VirtualUserController;
import com.blazemeter.jmeter.threads.AbstractDynamicThreadGroupModel;
import com.blazemeter.jmeter.threads.DynamicThread;
import java.util.Set;
import org.apache.jmeter.engine.StandardJMeterEngine;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.testelement.property.JMeterProperty;
import org.apache.jmeter.testelement.property.TestElementProperty;
import org.apache.jmeter.threads.JMeterThread;
import org.apache.jmeter.threads.ListenerNotifier;
import org.apache.jorphan.collections.ListedHashTree;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;

public abstract class AbstractDynamicThreadGroup
extends AbstractDynamicThreadGroupModel {
    private static final Logger log = LoggingManager.getLoggerForClass();
    public static final String UNIT = "Unit";
    public static final String UNIT_MINUTES = "M";
    public static final String UNIT_SECONDS = "S";
    protected transient Thread threadStarter;

    public AbstractDynamicThreadGroup() {
        this.setProperty((JMeterProperty)new TestElementProperty("ThreadGroup.main_controller", (TestElement)new VirtualUserController()));
    }

    public void start(int groupIndex, ListenerNotifier listenerNotifier, ListedHashTree testTree, StandardJMeterEngine engine) {
        this.running = true;
        this.threadStarter = this.getThreadStarter(groupIndex, listenerNotifier, testTree, engine);
        this.threadStarter.setName(this.getName() + "-ThreadStarter");
        this.threadStarter.start();
    }

    protected abstract Thread getThreadStarter(int var1, ListenerNotifier var2, ListedHashTree var3, StandardJMeterEngine var4);

    public void threadFinished(JMeterThread jMeterThread) {
        if (log.isDebugEnabled()) {
            log.debug("threadFinished: " + jMeterThread.getThreadName());
        }
        if (jMeterThread instanceof DynamicThread) {
            this.threads.remove(jMeterThread);
        }
    }

    public void waitThreadsStopped() {
        while (this.running) {
            if (!this.threads.isEmpty()) {
                this.joinThreadFrom(this.threads);
                continue;
            }
            if (this.isLimitReached()) {
                log.debug("Don't need more load, running=false");
                this.running = false;
                continue;
            }
            if (!this.threadStarter.isAlive()) {
                log.debug("Thread Starter is done and we have no active threads, let's finish with this");
                this.running = false;
                continue;
            }
            log.debug("Nothing to do, let's have some sleep");
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException e) {
                log.warn("Interrupted", (Throwable)e);
            }
        }
        log.debug("Done waiting for threads stopped");
    }

    public abstract boolean isLimitReached();

    public boolean verifyThreadsStopped() {
        for (DynamicThread thread : this.threads) {
            if (thread.getOSThread() != null) {
                try {
                    thread.getOSThread().join(WAIT_TO_DIE);
                }
                catch (InterruptedException e) {
                    log.warn("Interrupted", (Throwable)e);
                }
            }
            this.stopThread(thread.getThreadName(), true);
        }
        return this.threads.isEmpty();
    }

    public void tellThreadsToStop() {
        this.running = false;
        this.threadStarter.interrupt();
        for (DynamicThread thread : this.threads) {
            this.stopThread(thread.getThreadName(), false);
        }
    }

    public void stop() {
        this.running = false;
        this.threadStarter.interrupt();
        for (DynamicThread thread : this.threads) {
            thread.interrupt();
            thread.interruptOSThread();
        }
    }

    public boolean stopThread(String threadName, boolean forced) {
        for (DynamicThread thrd : this.threads) {
            if (!thrd.getThreadName().equals(threadName)) continue;
            thrd.stop();
            thrd.interrupt();
            if (forced && thrd.getOSThread() != null) {
                thrd.getOSThread().interrupt();
            }
            return true;
        }
        return false;
    }

    protected void joinThreadFrom(Set<DynamicThread> threadSet) {
        DynamicThread[] threads = threadSet.toArray(new DynamicThread[threadSet.size()]);
        if (threads.length > 0 && threads[0] != null) {
            DynamicThread thread = threads[0];
            log.debug("Joining thread " + thread.getThreadName());
            if (thread.getOSThread() != null) {
                try {
                    thread.getOSThread().join(WAIT_TO_DIE);
                }
                catch (InterruptedException e) {
                    log.warn("Interrupted", (Throwable)e);
                }
            }
            log.debug("Done joining thread " + thread.getThreadName());
        }
    }

    @Override
    public boolean isRunning() {
        return this.running;
    }

    public static String getUnitStr(String unit) {
        if (unit.equals(UNIT_MINUTES)) {
            return "min";
        }
        return "sec";
    }

    public void setUnit(String value) {
        this.setProperty(UNIT, value);
    }

    public String getUnit() {
        return this.getPropertyAsString(UNIT);
    }

    @Override
    public double getUnitFactor() {
        if (this.getUnit().equals(UNIT_MINUTES)) {
            return 60.0;
        }
        return 1.0;
    }

    public String getUnitStr() {
        String unit = this.getUnit();
        return AbstractDynamicThreadGroup.getUnitStr(unit);
    }

    public void startNextLoop() {
        ((VirtualUserController)this.getSamplerController()).startNextLoop();
    }
}

