/*
 * Decompiled with CFR 0.152.
 */
package com.blazemeter.jmeter.threads.arrivals;

import com.blazemeter.jmeter.threads.AbstractDynamicThreadGroup;
import com.blazemeter.jmeter.threads.AbstractDynamicThreadGroupGui;
import com.blazemeter.jmeter.threads.AdditionalFieldsPanel;
import com.blazemeter.jmeter.threads.ParamsPanel;
import com.blazemeter.jmeter.threads.arrivals.ArrivalsThreadGroup;
import com.blazemeter.jmeter.threads.arrivals.FreeFormArrivalsThreadGroup;
import com.blazemeter.jmeter.threads.arrivals.FreeFormLoadPanel;
import java.awt.Color;
import java.awt.Container;
import java.awt.event.ActionListener;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import kg.apc.charting.DateTimeRenderer;
import kg.apc.charting.rows.GraphRowExactValues;
import kg.apc.jmeter.JMeterPluginsUtils;
import kg.apc.jmeter.JMeterVariableEvaluator;
import org.apache.jmeter.testelement.property.CollectionProperty;
import org.apache.jorphan.gui.NumberRenderer;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;

public class FreeFormArrivalsThreadGroupGui
extends AbstractDynamicThreadGroupGui
implements TableModelListener,
DocumentListener,
Runnable,
ActionListener {
    private static final Logger log = LoggingManager.getLoggerForClass();

    public FreeFormArrivalsThreadGroupGui() {
        JMeterPluginsUtils.addHelpLinkToPanel((Container)((Object)this), (String)this.getClass().getSimpleName());
    }

    public String getLabelResource() {
        return this.getClass().getCanonicalName();
    }

    public String getStaticLabel() {
        return "bzm - Free-Form Arrivals Thread Group";
    }

    @Override
    protected AbstractDynamicThreadGroup createThreadGroupObject() {
        return new FreeFormArrivalsThreadGroup();
    }

    @Override
    protected ParamsPanel createLoadPanel() {
        FreeFormLoadPanel freeFormLoadPanel = new FreeFormLoadPanel();
        freeFormLoadPanel.addTableModelListener(this);
        return freeFormLoadPanel;
    }

    @Override
    protected AdditionalFieldsPanel getAdditionalFieldsPanel() {
        return new AdditionalFieldsPanel(true);
    }

    @Override
    protected void setChartPropertiesFromTG(AbstractDynamicThreadGroup tg) {
        if (tg instanceof ArrivalsThreadGroup) {
            ArrivalsThreadGroup atg = (ArrivalsThreadGroup)tg;
            this.previewChart.setYAxisLabel("Number of arrivals/" + atg.getUnitStr());
        }
    }

    @Override
    protected Color getRowColor() {
        return Color.MAGENTA;
    }

    @Override
    protected String getRowLabel(double totalArrivals) {
        log.debug("Total arr: " + totalArrivals);
        return "Arrival Rate (~" + Math.round(totalArrivals) + " total arrivals)";
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        log.debug("Table changed");
        SwingUtilities.invokeLater(this);
    }

    @Override
    protected void updateChart(AbstractDynamicThreadGroup tg) {
        FreeFormArrivalsThreadGroup atg = (FreeFormArrivalsThreadGroup)tg;
        CollectionProperty data = atg.getData();
        this.chartModel.clear();
        this.previewChart.clearErrorMessage();
        GraphRowExactValues row = new GraphRowExactValues();
        row.setColor(this.getRowColor());
        row.setDrawLine(true);
        row.setMarkerSize(0);
        row.setDrawThickLines(true);
        row.add(0L, 0.0);
        JMeterVariableEvaluator evaluator = new JMeterVariableEvaluator();
        int offset = 0;
        double totalArrivals = 0.0;
        for (CollectionProperty record : data) {
            double from = evaluator.getDouble(record.get(0));
            double to = evaluator.getDouble(record.get(1));
            double during = evaluator.getDouble(record.get(2));
            row.add((long)(offset * 1000), from);
            offset = (int)((double)offset + during * tg.getUnitFactor());
            row.add((long)(offset * 1000), to);
            totalArrivals += during * from + during * (to - from) / 2.0;
        }
        this.previewChart.setxAxisLabelRenderer((NumberRenderer)new DateTimeRenderer("HH:mm:ss", 0L));
        this.chartModel.put(this.getRowLabel(totalArrivals), row);
    }
}

