/*
 * Decompiled with CFR 0.152.
 */
package kg.apc.cmdtools;

import java.io.PrintStream;
import java.util.ListIterator;
import kg.apc.cmdtools.AbstractCMDTool;
import kg.apc.jmeter.PluginsCMDWorker;
import kg.apc.logging.LoggingUtils;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;
import org.apache.log.Priority;

public class ReporterTool
extends AbstractCMDTool {
    private static final Logger log = LoggingManager.getLoggerForClass();

    protected void showHelp(PrintStream os) {
        os.println("Options for tool 'Reporter': --generate-png <filename> --generate-csv <filename> --input-jtl <data file> --plugin-type <type> [ --width <graph width> --height <graph height> --granulation <ms> --relative-times <yes/no> --aggregate-rows <yes/no> --paint-gradient <yes/no> --paint-zeroing <yes/no> --paint-markers <yes/no> --prevent-outliers <yes/no> --limit-rows <num of points> --force-y <limit> --hide-low-counts <limit> --include-labels <labels list> --exclude-labels <labels list> --auto-scale <yes/no> --line-weight <num of pixels> --extractor-regexps <regExps list> --success-filter <true/false> --include-label-regex <true/false> --exclude-label-regex <true/false> --start-offset <sec>--end-offset <sec>]");
    }

    protected int processParams(ListIterator args) throws UnsupportedOperationException, IllegalArgumentException {
        LoggingManager.setPriority((Priority)Priority.INFO);
        while (args.hasNext()) {
            String nextArg = (String)args.next();
            if (!nextArg.equals("--loglevel")) continue;
            args.remove();
            String loglevelStr = (String)args.next();
            args.remove();
            LoggingManager.setPriority((String)loglevelStr);
        }
        while (args.hasPrevious()) {
            args.previous();
        }
        PluginsCMDWorker worker = new PluginsCMDWorker();
        while (args.hasNext()) {
            String nextArg = (String)args.next();
            log.debug("Arg: " + nextArg);
            if (nextArg.equalsIgnoreCase("--generate-png")) {
                if (!args.hasNext()) {
                    throw new IllegalArgumentException("Missing PNG file name");
                }
                worker.addExportMode(1);
                worker.setOutputPNGFile((String)args.next());
                continue;
            }
            if (nextArg.equalsIgnoreCase("--generate-csv")) {
                if (!args.hasNext()) {
                    throw new IllegalArgumentException("Missing CSV file name");
                }
                worker.addExportMode(2);
                worker.setOutputCSVFile((String)args.next());
                continue;
            }
            if (nextArg.equalsIgnoreCase("--input-jtl")) {
                if (!args.hasNext()) {
                    throw new IllegalArgumentException("Missing input JTL file name");
                }
                worker.setInputFile((String)args.next());
                continue;
            }
            if (nextArg.equalsIgnoreCase("--plugin-type")) {
                if (!args.hasNext()) {
                    throw new IllegalArgumentException("Missing plugin type");
                }
                worker.setPluginType((String)args.next());
                continue;
            }
            if (nextArg.equalsIgnoreCase("--width")) {
                if (!args.hasNext()) {
                    throw new IllegalArgumentException("Missing width specification");
                }
                worker.setGraphWidth(Integer.parseInt((String)args.next()));
                continue;
            }
            if (nextArg.equalsIgnoreCase("--height")) {
                if (!args.hasNext()) {
                    throw new IllegalArgumentException("Missing height specification");
                }
                worker.setGraphHeight(Integer.parseInt((String)args.next()));
                continue;
            }
            if (nextArg.equalsIgnoreCase("--aggregate-rows")) {
                if (!args.hasNext()) {
                    throw new IllegalArgumentException("Missing aggregate flag");
                }
                worker.setAggregate(this.getLogicValue((String)args.next()));
                continue;
            }
            if (nextArg.equalsIgnoreCase("--paint-zeroing")) {
                if (!args.hasNext()) {
                    throw new IllegalArgumentException("Missing zeroing flag");
                }
                worker.setZeroing(this.getLogicValue((String)args.next()));
                continue;
            }
            if (nextArg.equalsIgnoreCase("--relative-times")) {
                if (!args.hasNext()) {
                    throw new IllegalArgumentException("Missing rel time flag");
                }
                worker.setRelativeTimes(this.getLogicValue((String)args.next()));
                continue;
            }
            if (nextArg.equalsIgnoreCase("--paint-gradient")) {
                if (!args.hasNext()) {
                    throw new IllegalArgumentException("Missing gradient flag");
                }
                worker.setGradient(this.getLogicValue((String)args.next()));
                continue;
            }
            if (nextArg.equalsIgnoreCase("--paint-markers")) {
                if (!args.hasNext()) {
                    throw new IllegalArgumentException("Missing markers flag");
                }
                worker.setMarkers(this.getLogicValue((String)args.next()));
                continue;
            }
            if (nextArg.equalsIgnoreCase("--prevent-outliers")) {
                if (!args.hasNext()) {
                    throw new IllegalArgumentException("Missing outliers flag");
                }
                worker.setPreventOutliers(this.getLogicValue((String)args.next()));
                continue;
            }
            if (nextArg.equalsIgnoreCase("--limit-rows")) {
                if (!args.hasNext()) {
                    throw new IllegalArgumentException("Missing limit rows specification");
                }
                worker.setRowsLimit(Integer.parseInt((String)args.next()));
                continue;
            }
            if (nextArg.equalsIgnoreCase("--force-y")) {
                if (!args.hasNext()) {
                    throw new IllegalArgumentException("Missing limit Y specification");
                }
                worker.setForceY(Integer.parseInt((String)args.next()));
                continue;
            }
            if (nextArg.equalsIgnoreCase("--hide-low-counts")) {
                if (!args.hasNext()) {
                    throw new IllegalArgumentException("Missing low counts specification");
                }
                worker.setHideLowCounts(Integer.parseInt((String)args.next()));
                continue;
            }
            if (nextArg.equalsIgnoreCase("--line-weight")) {
                if (!args.hasNext()) {
                    throw new IllegalArgumentException("Missing line thickness specification");
                }
                worker.setLineWeight(Float.parseFloat((String)args.next()));
                continue;
            }
            if (nextArg.equalsIgnoreCase("--granulation")) {
                if (!args.hasNext()) {
                    throw new IllegalArgumentException("Missing granulation specification");
                }
                worker.setGranulation(Integer.parseInt((String)args.next()));
                continue;
            }
            if (nextArg.equalsIgnoreCase("--include-labels")) {
                if (!args.hasNext()) {
                    throw new IllegalArgumentException("Missing granulation specification");
                }
                worker.setIncludeLabels((String)args.next());
                continue;
            }
            if (nextArg.equalsIgnoreCase("--exclude-labels")) {
                if (!args.hasNext()) {
                    throw new IllegalArgumentException("Missing granulation specification");
                }
                worker.setExcludeLabels((String)args.next());
                continue;
            }
            if (nextArg.equalsIgnoreCase("--auto-scale")) {
                if (!args.hasNext()) {
                    throw new IllegalArgumentException("Missing auto-zoom flag value");
                }
                worker.setAutoScaleRows(this.getLogicValue((String)args.next()));
                continue;
            }
            if (nextArg.equalsIgnoreCase("--success-filter")) {
                if (!args.hasNext()) {
                    throw new IllegalArgumentException("Missing success filter flag");
                }
                worker.setSuccessFilter(this.getLogicValue((String)args.next()));
                continue;
            }
            if (nextArg.equalsIgnoreCase("--include-label-regex")) {
                if (!args.hasNext()) {
                    throw new IllegalArgumentException("Missing include label regex flag");
                }
                worker.setIncludeSamplesWithRegex(this.getLogicValue((String)args.next()));
                continue;
            }
            if (nextArg.equalsIgnoreCase("--exclude-label-regex")) {
                if (!args.hasNext()) {
                    throw new IllegalArgumentException("Missing exclude label regex flag");
                }
                worker.setExcludeSamplesWithRegex(this.getLogicValue((String)args.next()));
                continue;
            }
            if (nextArg.equalsIgnoreCase("--start-offset")) {
                if (!args.hasNext()) {
                    throw new IllegalArgumentException("Missing start offset flag");
                }
                worker.setStartOffset((String)args.next());
                continue;
            }
            if (nextArg.equalsIgnoreCase("--end-offset")) {
                if (!args.hasNext()) {
                    throw new IllegalArgumentException("Missing end offset flag");
                }
                worker.setEndOffset((String)args.next());
                continue;
            }
            worker.processUnknownOption(nextArg, args);
        }
        return worker.doJob();
    }

    static {
        LoggingUtils.addLoggingConfig();
    }
}

