/*
 * Decompiled with CFR 0.152.
 */
package kg.apc.jmeter.vizualizers;

import java.io.Serializable;
import java.util.Iterator;
import java.util.concurrent.ConcurrentSkipListMap;
import kg.apc.charting.AbstractGraphRow;
import kg.apc.jmeter.graphs.CompositeNotifierInterface;

public class CompositeModel
implements Serializable {
    private ConcurrentSkipListMap<String, ConcurrentSkipListMap<String, AbstractGraphRow>> models = new ConcurrentSkipListMap();
    private Iterator<AbstractGraphRow> emptyIterator = null;
    private CompositeNotifierInterface notifier = null;

    public void setNotifier(CompositeNotifierInterface notifier) {
        this.notifier = notifier;
    }

    public void clear() {
        this.models.clear();
    }

    private synchronized ConcurrentSkipListMap<String, AbstractGraphRow> getRowsMap(String vizualizerName) {
        ConcurrentSkipListMap<String, Object> rows = this.models.get(vizualizerName);
        if (rows == null) {
            rows = new ConcurrentSkipListMap();
            this.models.put(vizualizerName, rows);
        }
        return rows;
    }

    public void addRow(String vizualizerName, AbstractGraphRow row) {
        ConcurrentSkipListMap<String, AbstractGraphRow> rows = this.models.get(vizualizerName);
        if (rows == null) {
            rows = this.getRowsMap(vizualizerName);
        }
        rows.put(row.getLabel(), row);
        this.notifier.refresh();
    }

    public void clearRows(String vizualizerName) {
        this.models.remove(vizualizerName);
        this.notifier.refresh();
    }

    public boolean containsVisualizer(String vizualizerName) {
        return this.models.containsKey(vizualizerName);
    }

    public Iterator<String> getVizualizerNamesIterator() {
        return this.models.keySet().iterator();
    }

    public Iterator<AbstractGraphRow> getRowsIterator(String vizualizerName) {
        ConcurrentSkipListMap<String, AbstractGraphRow> rows = this.models.get(vizualizerName);
        if (rows != null) {
            return rows.values().iterator();
        }
        if (this.emptyIterator == null) {
            this.emptyIterator = new ConcurrentSkipListMap().values().iterator();
        }
        return this.emptyIterator;
    }

    public AbstractGraphRow getRow(String testName, String rowName) {
        ConcurrentSkipListMap<String, AbstractGraphRow> rows = this.models.get(testName);
        if (rows != null) {
            return this.models.get(testName).get(rowName);
        }
        return null;
    }
}

