/*
 * JRowsSelectorPanel.java
 *
 * Created on Dec 29, 2010, 2:09:35 AM
 */

package kg.apc.jmeter.graphs;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.InputEvent;
import javax.swing.JPanel;

import kg.apc.jmeter.JMeterPluginsUtils;

class JRowsSelectorPanel extends javax.swing.JPanel implements GraphRendererInterface {

    GraphPanel parent = null;

    /**
     * Creates new form JRowsSelectorPanel
     */
    public JRowsSelectorPanel(GraphPanel parent) {
        this.parent = parent;
        initComponents();
    }

    public void setTable(Component table) {
        jPanelRowsTable.add(table, BorderLayout.CENTER);
    }

    public void refreshPreview() {
        parent.getGraphObject().invalidateCache();
        jPanelGraphPreview.invalidate();
        jPanelGraphPreview.repaint();
    }

    public String getIncludeSampleLabels() {
        return jTextFieldInclude.getText();
    }

    public void setIncludeSampleLabels(String str) {
        jTextFieldInclude.setText(str);
    }

    public String getExcludeSampleLabels() {
        return jTextFieldExclude.getText();
    }

    public void setExcludeSampleLabels(String str) {
        jTextFieldExclude.setText(str);
    }

    public boolean isSelectedRegExpInc() {
        return jCheckBoxInclude.isSelected();
    }

    public void setSelectedRegExpInc(boolean b) {
        jCheckBoxInclude.setSelected(b);
    }

    public boolean isSelectedRegExpExc() {
        return jCheckBoxExclude.isSelected();
    }

    public void setSelectedRegExpExc(boolean b) {
        jCheckBoxExclude.setSelected(b);
    }

    public String getStartOffset() {
        return jTextFieldStartOffset.getText();
    }

    public void setStartOffset(long startOffset) {
        jTextFieldStartOffset.setText(String.valueOf(startOffset));
    }

    public String getEndOffset() {
        return jTextFieldEndOffset.getText();
    }

    public void setEndOffset(long endOffset) {
        jTextFieldEndOffset.setText(String.valueOf(endOffset));
    }

    /**
     * This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        jPanelLogo = new javax.swing.JPanel();
        jLabel1 = new javax.swing.JLabel();
        jPanel1 = new javax.swing.JPanel();
        jPanelMain = new javax.swing.JPanel();
        jPanelRowsTable = new javax.swing.JPanel();
        jPanelRowsConfig = new javax.swing.JPanel();
        jLabelInclude = new javax.swing.JLabel();
        jTextFieldInclude = new javax.swing.JTextField();
        jLabelExclude = new javax.swing.JLabel();
        jLabelStartEndOffset = new javax.swing.JLabel();
        jTextFieldStartOffset = new javax.swing.JTextField();
        jTextFieldEndOffset = new javax.swing.JTextField();
        jCheckBoxInclude = new javax.swing.JCheckBox();
        jTextFieldExclude = new javax.swing.JTextField();
        jCheckBoxExclude = new javax.swing.JCheckBox();
        jLabelRegExpInclude = new javax.swing.JLabel();
        jLabelRegExpExclude = new javax.swing.JLabel();
        jPanelGraphPreview = new javax.swing.JPanel();
        jLabel2 = new javax.swing.JLabel();

        setBorder(javax.swing.BorderFactory.createBevelBorder(javax.swing.border.BevelBorder.LOWERED));
        setLayout(new java.awt.BorderLayout());

        jPanelLogo.setLayout(new java.awt.GridBagLayout());

        jLabel1.setHorizontalAlignment(javax.swing.SwingConstants.RIGHT);
        jLabel1.setIcon(new javax.swing.ImageIcon(getClass().getResource("/kg/apc/jmeter/vizualizers/logoSimple.png"))); // NOI18N
        jLabel1.setCursor(new java.awt.Cursor(java.awt.Cursor.HAND_CURSOR));
        jLabel1.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                jLabel1MouseClicked(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        jPanelLogo.add(jLabel1, gridBagConstraints);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        jPanelLogo.add(jPanel1, gridBagConstraints);

        add(jPanelLogo, java.awt.BorderLayout.PAGE_END);

        jPanelMain.setLayout(new java.awt.GridBagLayout());

        jPanelRowsTable.setLayout(new java.awt.BorderLayout());

        jPanelRowsConfig.setBorder(javax.swing.BorderFactory.createBevelBorder(javax.swing.border.BevelBorder.RAISED));
        jPanelRowsConfig.setLayout(new java.awt.GridBagLayout());

        jLabelInclude.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        jLabelInclude.setText("Include labels");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        jPanelRowsConfig.add(jLabelInclude, gridBagConstraints);

        jLabelExclude.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        jLabelExclude.setText("Exclude labels");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        jPanelRowsConfig.add(jLabelExclude, gridBagConstraints);

        jLabelStartEndOffset
                .setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        jLabelStartEndOffset.setText("Start / End offset (sec)");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        jPanelRowsConfig.add(jLabelStartEndOffset, gridBagConstraints);

        jTextFieldStartOffset.setMinimumSize(new java.awt.Dimension(30, 20));
        jTextFieldStartOffset.setPreferredSize(new java.awt.Dimension(75, 20));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
        jPanelRowsConfig.add(jTextFieldStartOffset, gridBagConstraints);

        jTextFieldEndOffset.setMinimumSize(new java.awt.Dimension(30, 20));
        jTextFieldEndOffset.setPreferredSize(new java.awt.Dimension(75, 20));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new java.awt.Insets(2, 0, 2, 2);
        jPanelRowsConfig.add(jTextFieldEndOffset, gridBagConstraints);

        jTextFieldInclude.setMinimumSize(new java.awt.Dimension(60, 20));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(2, 0, 2, 0);
        jPanelRowsConfig.add(jTextFieldInclude, gridBagConstraints);

        jCheckBoxInclude.setMargin(new java.awt.Insets(0, 0, 0, 0));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        jPanelRowsConfig.add(jCheckBoxInclude, gridBagConstraints);

        jTextFieldExclude.setMinimumSize(new java.awt.Dimension(60, 20));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(2, 0, 2, 0);
        jPanelRowsConfig.add(jTextFieldExclude, gridBagConstraints);

        jCheckBoxExclude.setMargin(new java.awt.Insets(0, 0, 0, 0));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        jPanelRowsConfig.add(jCheckBoxExclude, gridBagConstraints);

        jLabelRegExpInclude.setText("RegExp");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        jPanelRowsConfig.add(jLabelRegExpInclude, gridBagConstraints);

        jLabelRegExpExclude.setText("RegExp");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 0;
        jPanelRowsConfig.add(jLabelRegExpExclude, gridBagConstraints);

        jPanelRowsTable.add(jPanelRowsConfig, java.awt.BorderLayout.SOUTH);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        jPanelMain.add(jPanelRowsTable, gridBagConstraints);

        jPanelGraphPreview.setLayout(new java.awt.BorderLayout());
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(0, 4, 0, 4);
        jPanelMain.add(jPanelGraphPreview, gridBagConstraints);

        jLabel2.setText("Preview:");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(0, 6, 0, 0);
        jPanelMain.add(jLabel2, gridBagConstraints);

        add(jPanelMain, java.awt.BorderLayout.CENTER);
    }// </editor-fold>//GEN-END:initComponents

    private void jLabel1MouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_jLabel1MouseClicked
        if ((evt.getModifiers() & InputEvent.BUTTON1_MASK) == InputEvent.BUTTON1_MASK) {
            JMeterPluginsUtils.openInBrowser(JMeterPluginsUtils.WIKI_BASE + "?utm_source=jmeter&utm_medium=logolink&utm_campaign=row_selector");
        }
    }//GEN-LAST:event_jLabel1MouseClicked


    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JCheckBox jCheckBoxExclude;
    private javax.swing.JCheckBox jCheckBoxInclude;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JLabel jLabelExclude;
    private javax.swing.JLabel jLabelInclude;
    private javax.swing.JLabel jLabelRegExpExclude;
    private javax.swing.JLabel jLabelRegExpInclude;
    private javax.swing.JLabel jLabelStartEndOffset;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JPanel jPanelGraphPreview;
    private javax.swing.JPanel jPanelLogo;
    private javax.swing.JPanel jPanelMain;
    private javax.swing.JPanel jPanelRowsConfig;
    private javax.swing.JPanel jPanelRowsTable;
    private javax.swing.JTextField jTextFieldEndOffset;
    private javax.swing.JTextField jTextFieldExclude;
    private javax.swing.JTextField jTextFieldInclude;
    private javax.swing.JTextField jTextFieldStartOffset;

    // End of variables declaration//GEN-END:variables

    @Override
    public JPanel getGraphDisplayPanel() {
        return jPanelGraphPreview;
    }

    @Override
    public boolean isPreview() {
        return true;
    }

    public void clearGui() {
        jTextFieldExclude.setText("");
        jTextFieldInclude.setText("");
        jCheckBoxExclude.setSelected(false);
        jCheckBoxInclude.setSelected(false);
        jTextFieldStartOffset.setText("");
        jTextFieldEndOffset.setText("");
    }

}
