/*
 * Decompiled with CFR 0.152.
 */
package kg.apc.charting;

import java.util.Iterator;
import java.util.Map;
import kg.apc.charting.AbstractGraphPanelChartElement;
import kg.apc.charting.AbstractGraphRow;

public class CubicSpline {
    private int size = 0;
    private double[] x = null;
    private double[] y = null;
    private double[] d2ydx2 = null;

    public CubicSpline(AbstractGraphRow row) {
        this.size = row.size();
        this.x = new double[this.size];
        this.y = new double[this.size];
        this.d2ydx2 = new double[this.size];
        this.init(row);
    }

    public final void init(AbstractGraphRow row) {
        Iterator<Map.Entry<Long, AbstractGraphPanelChartElement>> it = row.iterator();
        for (int index = 0; it.hasNext() && index < this.size; ++index) {
            Map.Entry<Long, AbstractGraphPanelChartElement> element = it.next();
            AbstractGraphPanelChartElement elt = element.getValue();
            this.x[index] = element.getKey().doubleValue();
            this.y[index] = elt.getValue();
        }
        this.calcD2ydx2();
    }

    private void calcD2ydx2() {
        double p = 0.0;
        double qn = 0.0;
        double sig = 0.0;
        double un = 0.0;
        double[] u = new double[this.size];
        u[0] = 0.0;
        this.d2ydx2[0] = 0.0;
        for (int i = 1; i <= this.size - 2; ++i) {
            sig = (this.x[i] - this.x[i - 1]) / (this.x[i + 1] - this.x[i - 1]);
            p = sig * this.d2ydx2[i - 1] + 2.0;
            this.d2ydx2[i] = (sig - 1.0) / p;
            u[i] = (this.y[i + 1] - this.y[i]) / (this.x[i + 1] - this.x[i]) - (this.y[i] - this.y[i - 1]) / (this.x[i] - this.x[i - 1]);
            u[i] = (6.0 * u[i] / (this.x[i + 1] - this.x[i - 1]) - sig * u[i - 1]) / p;
        }
        un = 0.0;
        qn = 0.0;
        this.d2ydx2[this.size - 1] = (un - qn * u[this.size - 2]) / (qn * this.d2ydx2[this.size - 2] + 1.0);
        for (int k = this.size - 2; k >= 0; --k) {
            this.d2ydx2[k] = this.d2ydx2[k] * this.d2ydx2[k + 1] + u[k];
        }
    }

    public double interpolate(double xx) {
        double h = 0.0;
        double b = 0.0;
        double a = 0.0;
        double yy = 0.0;
        int k = 0;
        int klo = 0;
        int khi = this.size - 1;
        while (khi - klo > 1) {
            k = khi + klo >>> 1;
            if (this.x[k] > xx) {
                khi = k;
                continue;
            }
            klo = k;
        }
        h = this.x[khi] - this.x[klo];
        a = (this.x[khi] - xx) / h;
        b = (xx - this.x[klo]) / h;
        yy = a * this.y[klo] + b * this.y[khi] + ((a * a * a - a) * this.d2ydx2[klo] + (b * b * b - b) * this.d2ydx2[khi]) * (h * h) / 6.0;
        return yy;
    }
}

