/*
 * Decompiled with CFR 0.152.
 */
package kg.apc.jmeter.graphs;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.SimpleDateFormat;
import javax.swing.BorderFactory;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.table.TableModel;
import kg.apc.charting.AbstractGraphRow;
import kg.apc.jmeter.JMeterPluginsUtils;
import kg.apc.jmeter.graphs.AbstractOverTimeVisualizer;
import kg.apc.jmeter.gui.ButtonPanelAddCopyRemove;
import kg.apc.jmeter.vizualizers.JSettingsPanel;
import kg.apc.jmeter.vizualizers.MonitoringResultsCollector;
import kg.apc.jmeter.vizualizers.MonitoringSampleResult;
import org.apache.jmeter.gui.util.PowerTableModel;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.testelement.property.CollectionProperty;
import org.apache.jmeter.testelement.property.NullProperty;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;

public abstract class AbstractMonitoringVisualizer
extends AbstractOverTimeVisualizer {
    private static final Logger log = LoggingManager.getLoggerForClass();
    protected PowerTableModel tableModel;
    protected JTable grid;
    protected JTextArea errorTextArea;
    protected JScrollPane errorPane;

    protected abstract String[] getColumnIdentifiers();

    protected abstract Class[] getColumnClasses();

    protected abstract Object[] getDefaultValues();

    protected abstract int[] getColumnWidths();

    protected abstract MonitoringResultsCollector createMonitoringResultsCollector();

    @Override
    public abstract String getWikiPage();

    @Override
    public abstract String getStaticLabel();

    public AbstractMonitoringVisualizer() {
        this.setGranulation(1000);
        this.graphPanel.getGraphObject().setYAxisLabel("Monitoring results");
        this.graphPanel.getGraphObject().getChartSettings().setExpendRows(true);
    }

    @Override
    protected JSettingsPanel createSettingsPanel() {
        return new JSettingsPanel(this, 13074);
    }

    public String getLabelResource() {
        return this.getClass().getSimpleName();
    }

    @Override
    protected JPanel getGraphPanelContainer() {
        JPanel panel = new JPanel(new BorderLayout());
        JPanel innerTopPanel = new JPanel(new BorderLayout());
        this.errorPane = new JScrollPane();
        this.errorPane.setMinimumSize(new Dimension(100, 50));
        this.errorPane.setPreferredSize(new Dimension(100, 50));
        this.errorTextArea = new JTextArea();
        this.errorTextArea.setForeground(Color.red);
        this.errorTextArea.setBackground(new Color(255, 255, 153));
        this.errorTextArea.setEditable(false);
        this.errorPane.setViewportView(this.errorTextArea);
        this.registerPopup();
        innerTopPanel.add(this.createSamplerPanel(), "North");
        innerTopPanel.add((Component)this.errorPane, "South");
        innerTopPanel.add(this.getFilePanel(), "Center");
        panel.add((Component)innerTopPanel, "North");
        this.errorPane.setVisible(false);
        return panel;
    }

    protected void addErrorMessage(String msg, long time) {
        this.errorPane.setVisible(true);
        SimpleDateFormat formatter = new SimpleDateFormat("HH:mm:ss");
        String newLine = "";
        if (this.errorTextArea.getText().length() != 0) {
            newLine = "\n";
        }
        this.errorTextArea.setText(this.errorTextArea.getText() + newLine + formatter.format(time) + " - ERROR: " + msg);
        this.errorTextArea.setCaretPosition(this.errorTextArea.getDocument().getLength());
        this.updateGui();
    }

    public void clearErrorMessage() {
        this.errorTextArea.setText("");
        this.errorPane.setVisible(false);
    }

    protected void registerPopup() {
        JPopupMenu popup = new JPopupMenu();
        JMenuItem hideMessagesMenu = new JMenuItem("Hide Error Panel");
        hideMessagesMenu.addActionListener(new HideAction());
        popup.add(hideMessagesMenu);
        this.errorTextArea.setComponentPopupMenu(popup);
    }

    @Override
    public void clearData() {
        this.clearErrorMessage();
        super.clearData();
    }

    protected Component createSamplerPanel() {
        JPanel panel = new JPanel(new BorderLayout(5, 5));
        panel.setBorder(BorderFactory.createTitledBorder("Monitoring Samplers"));
        panel.setPreferredSize(new Dimension(150, 150));
        JScrollPane scroll = new JScrollPane(this.createGrid());
        scroll.setPreferredSize(scroll.getMinimumSize());
        panel.add((Component)scroll, "Center");
        panel.add((Component)new ButtonPanelAddCopyRemove(this.grid, this.tableModel, this.getDefaultValues()), "South");
        this.grid.getTableHeader().setReorderingAllowed(false);
        return panel;
    }

    protected JTable createGrid() {
        this.grid = new JTable();
        this.createTableModel();
        this.grid.setSelectionMode(0);
        this.grid.setMinimumSize(new Dimension(200, 100));
        for (int i = 0; i < this.getColumnWidths().length; ++i) {
            this.grid.getColumnModel().getColumn(i).setPreferredWidth(this.getColumnWidths()[i]);
        }
        return this.grid;
    }

    protected void createTableModel() {
        this.tableModel = new PowerTableModel(this.getColumnIdentifiers(), this.getColumnClasses());
        this.grid.setModel((TableModel)this.tableModel);
    }

    @Override
    public TestElement createTestElement() {
        MonitoringResultsCollector te = this.createMonitoringResultsCollector();
        this.modifyTestElement((TestElement)te);
        te.setComment(JMeterPluginsUtils.getWikiLinkText(this.getWikiPage()));
        return te;
    }

    @Override
    public void modifyTestElement(TestElement te) {
        super.modifyTestElement(te);
        if (this.grid.isEditing()) {
            this.grid.getCellEditor().stopCellEditing();
        }
        if (te instanceof MonitoringResultsCollector) {
            MonitoringResultsCollector mrc = (MonitoringResultsCollector)te;
            CollectionProperty rows = JMeterPluginsUtils.tableModelRowsToCollectionProperty(this.tableModel, "samplers");
            mrc.setData(rows);
        }
        super.configureTestElement(te);
    }

    @Override
    public void configure(TestElement te) {
        super.configure(te);
        MonitoringResultsCollector mrc = (MonitoringResultsCollector)te;
        CollectionProperty samplerValues = mrc.getSamplerSettings();
        if (!(samplerValues instanceof NullProperty)) {
            JMeterPluginsUtils.collectionPropertyToTableModelRows(samplerValues, this.tableModel, this.getColumnClasses());
        } else {
            log.warn("Received null property instead of collection");
        }
    }

    @Override
    public void add(SampleResult res) {
        if (res.isSuccessful()) {
            if (this.isSampleIncluded(res)) {
                super.add(res);
                this.addMonitoringRecord(res.getSampleLabel(), this.normalizeTime(res.getStartTime()), MonitoringSampleResult.getValue(res));
                this.updateGui(null);
            }
        } else {
            this.addErrorMessage(res.getResponseMessage(), res.getStartTime());
        }
    }

    protected void addMonitoringRecord(String rowName, long time, double value) {
        AbstractGraphRow row = (AbstractGraphRow)this.model.get(rowName);
        if (row == null) {
            row = this.getNewRow(this.model, 0, rowName, 0, false, false, false, true, true);
        }
        row.add(time, value);
    }

    class HideAction
    implements ActionListener {
        HideAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            AbstractMonitoringVisualizer.this.errorPane.setVisible(false);
            AbstractMonitoringVisualizer.this.updateGui();
        }
    }
}

