/*
 * Decompiled with CFR 0.152.
 */
package kg.apc.jmeter.graphs;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Image;
import java.net.URL;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import kg.apc.charting.AbstractGraphRow;
import kg.apc.charting.GraphPanelChart;
import kg.apc.jmeter.graphs.ChartRowsTable;
import kg.apc.jmeter.graphs.GraphRendererInterface;
import kg.apc.jmeter.graphs.JRowsSelectorPanel;
import org.apache.jmeter.gui.GuiPackage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphPanel
extends JTabbedPane {
    private static final Logger log = LoggerFactory.getLogger(GraphPanel.class);
    private GraphPanelChart graphPanelObject;
    private JRowsSelectorPanel rowsTab;
    private JComponent settingsTab;
    private ChartRowsTable table;

    public GraphPanel() {
        this.addGraphTab();
        this.addRowsTab();
        this.addOptionsTab();
        this.addChangeListener(new TabsChangeListener());
    }

    private void addRowsTab() {
        ImageIcon rowsIcon = GraphPanel.createImageIcon("/kg/apc/jmeter/img/checks.png");
        this.rowsTab = new JRowsSelectorPanel(this);
        this.rowsTab.setTable(this.makeTable(this.rowsTab));
        this.addTab("Rows", rowsIcon, this.rowsTab, "Select rows to display");
    }

    public void replaceRowTab(String tabLabel, Component object, String toolTipText) {
        int index = this.indexOfComponent(this.rowsTab);
        this.remove(index);
        ImageIcon rowsIcon = GraphPanel.createImageIcon("/kg/apc/jmeter/img/checks.png");
        this.insertTab(tabLabel, rowsIcon, object, toolTipText, index);
    }

    private void addOptionsTab() {
        ImageIcon icon = GraphPanel.createImageIcon("/kg/apc/jmeter/img/settings.png");
        this.settingsTab = new JPanel(new BorderLayout());
        this.addTab("Settings", icon, this.settingsTab, "Chart plot settings");
    }

    private Component makeTable(JRowsSelectorPanel rowsTab) {
        this.table = new ChartRowsTable(rowsTab);
        return this.makeScrollPane(this.table);
    }

    private JScrollPane makeScrollPane(Component comp) {
        JScrollPane pane = new JScrollPane(comp);
        pane.setPreferredSize(pane.getMinimumSize());
        pane.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        return pane;
    }

    private void addGraphTab() {
        ImageIcon graphIcon = GraphPanel.createImageIcon("/kg/apc/jmeter/img/graph.png");
        this.graphPanelObject = new GraphPanelChart(GuiPackage.getInstance() != null);
        this.graphPanelObject.setBorder(BorderFactory.createBevelBorder(1));
        JGraphPanel graphTab = new JGraphPanel();
        graphTab.add((Component)this.graphPanelObject, "Center");
        this.addTab("Chart", graphIcon, graphTab, "View chart");
    }

    private static ImageIcon createImageIcon(String path) {
        URL imgURL = GraphPanel.class.getResource(path);
        if (imgURL != null) {
            return new ImageIcon(imgURL);
        }
        throw new RuntimeException("Couldn't find file: " + path);
    }

    public void updateGui() {
        this.graphPanelObject.invalidateCache();
        JComponent selectedTab = (JComponent)this.getSelectedComponent();
        selectedTab.updateUI();
        selectedTab.repaint();
    }

    public Image getGraphImage() {
        Image result = this.graphPanelObject.createImage(this.graphPanelObject.getWidth(), this.graphPanelObject.getHeight());
        if (result != null) {
            this.graphPanelObject.paintComponent(result.getGraphics());
        }
        return result;
    }

    public GraphPanelChart getGraphObject() {
        return this.graphPanelObject;
    }

    public JRowsSelectorPanel getRowSelectorPanel() {
        return this.rowsTab;
    }

    public void addRow(AbstractGraphRow row) {
        if (this.getGraphObject().isModelContainsRow(row)) {
            this.table.addRow(row);
        }
    }

    public void clearRowsTab() {
        this.table.clear();
    }

    public JComponent getSettingsTab() {
        return this.settingsTab;
    }

    private class TabsChangeListener
    implements ChangeListener {
        private TabsChangeListener() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            GraphPanel.this.updateGui();
            JComponent selectedComponent = (JComponent)GraphPanel.this.getSelectedComponent();
            if (selectedComponent == GraphPanel.this.settingsTab) {
                selectedComponent = (JComponent)selectedComponent.getComponent(0);
            }
            GraphRendererInterface renderer = (GraphRendererInterface)((Object)selectedComponent);
            renderer.getGraphDisplayPanel().add((Component)GraphPanel.this.graphPanelObject, "Center");
            GraphPanel.this.graphPanelObject.setIsPreview(renderer.isPreview());
        }
    }

    private static class JGraphPanel
    extends JPanel
    implements GraphRendererInterface {
        public JGraphPanel() {
            this.setLayout(new BorderLayout());
        }

        @Override
        public JPanel getGraphDisplayPanel() {
            return this;
        }

        @Override
        public boolean isPreview() {
            return false;
        }
    }
}

