/*
 * Decompiled with CFR 0.152.
 */
package kg.apc.jmeter.gui;

import java.awt.Color;
import javax.swing.InputVerifier;
import javax.swing.JComponent;
import javax.swing.JTextField;

public class IntegerInputVerifier
extends InputVerifier {
    Color background;
    Color warningBackground;
    private int min;
    private int max;

    public IntegerInputVerifier(int min, int max, Color background, Color warningBackground) {
        this.min = min;
        this.max = max;
        this.background = background;
        this.warningBackground = warningBackground;
    }

    public int getMin() {
        return this.min;
    }

    public int getMax() {
        return this.max;
    }

    @Override
    public boolean shouldYieldFocus(JComponent input) {
        boolean isValidInput = this.verify(input);
        if (isValidInput) {
            input.setBackground(this.background);
        } else {
            input.setBackground(this.warningBackground);
        }
        return isValidInput;
    }

    @Override
    public boolean verify(JComponent input) {
        JTextField tf = (JTextField)input;
        try {
            int inputInt = Integer.parseInt(tf.getText());
            return inputInt >= this.min && inputInt <= this.max;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }
}

