/*
 * Decompiled with CFR 0.152.
 */
package kg.apc.jmeter.vizualizers;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.SimpleDateFormat;
import javax.swing.BorderFactory;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.table.TableModel;
import kg.apc.charting.AbstractGraphRow;
import kg.apc.jmeter.JMeterPluginsUtils;
import kg.apc.jmeter.dbmon.DbMonCollector;
import kg.apc.jmeter.dbmon.DbMonSampleResult;
import kg.apc.jmeter.graphs.AbstractOverTimeVisualizer;
import kg.apc.jmeter.graphs.SettingsInterface;
import kg.apc.jmeter.gui.ButtonPanelAddCopyRemove;
import kg.apc.jmeter.vizualizers.JSettingsPanel;
import org.apache.jmeter.gui.util.PowerTableModel;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.testelement.property.CollectionProperty;
import org.apache.jmeter.testelement.property.JMeterProperty;
import org.apache.jmeter.testelement.property.NullProperty;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;

public class DbMonGui
extends AbstractOverTimeVisualizer {
    private static final Logger log = LoggingManager.getLoggerForClass();
    private PowerTableModel tableModel;
    private JTable grid;
    private JTextArea errorTextArea;
    private JScrollPane errorPane;
    public static final String[] columnIdentifiers = new String[]{"JDBC pool variable name", "Chart label", "Delta", "SQL query (must return a single numeric value)"};
    public static final Class[] columnClasses = new Class[]{String.class, String.class, Boolean.class, String.class};
    private static Object[] defaultValues = new Object[]{"", "", false, ""};

    public DbMonGui() {
        this.setGranulation(1000);
        this.graphPanel.getGraphObject().setYAxisLabel("Query results");
        this.graphPanel.getGraphObject().getChartSettings().setExpendRows(true);
    }

    protected JSettingsPanel createSettingsPanel() {
        return new JSettingsPanel((SettingsInterface)this, 13074);
    }

    public String getWikiPage() {
        return "DbMon";
    }

    public String getLabelResource() {
        return ((Object)((Object)this)).getClass().getSimpleName();
    }

    public String getStaticLabel() {
        return JMeterPluginsUtils.prefixLabel((String)"DbMon Samples Collector");
    }

    protected JPanel getGraphPanelContainer() {
        JPanel panel = new JPanel(new BorderLayout());
        JPanel innerTopPanel = new JPanel(new BorderLayout());
        this.errorPane = new JScrollPane();
        this.errorPane.setMinimumSize(new Dimension(100, 50));
        this.errorPane.setPreferredSize(new Dimension(100, 50));
        this.errorTextArea = new JTextArea();
        this.errorTextArea.setForeground(Color.red);
        this.errorTextArea.setBackground(new Color(255, 255, 153));
        this.errorTextArea.setEditable(false);
        this.errorPane.setViewportView(this.errorTextArea);
        this.registerPopup();
        innerTopPanel.add(this.createSamplerPanel(), "North");
        innerTopPanel.add((Component)this.errorPane, "South");
        innerTopPanel.add(this.getFilePanel(), "Center");
        panel.add((Component)innerTopPanel, "North");
        this.errorPane.setVisible(false);
        return panel;
    }

    private void addErrorMessage(String msg, long time) {
        this.errorPane.setVisible(true);
        SimpleDateFormat formatter = new SimpleDateFormat("HH:mm:ss");
        String newLine = "";
        if (this.errorTextArea.getText().length() != 0) {
            newLine = "\n";
        }
        this.errorTextArea.setText(this.errorTextArea.getText() + newLine + formatter.format(time) + " - ERROR: " + msg);
        this.errorTextArea.setCaretPosition(this.errorTextArea.getDocument().getLength());
        this.updateGui();
    }

    public void clearErrorMessage() {
        this.errorTextArea.setText("");
        this.errorPane.setVisible(false);
    }

    private void registerPopup() {
        JPopupMenu popup = new JPopupMenu();
        JMenuItem hideMessagesMenu = new JMenuItem("Hide Error Panel");
        hideMessagesMenu.addActionListener(new HideAction());
        popup.add(hideMessagesMenu);
        this.errorTextArea.setComponentPopupMenu(popup);
    }

    public void clearData() {
        this.clearErrorMessage();
        super.clearData();
    }

    private Component createSamplerPanel() {
        JPanel panel = new JPanel(new BorderLayout(5, 5));
        panel.setBorder(BorderFactory.createTitledBorder("Database Samplers"));
        panel.setPreferredSize(new Dimension(150, 150));
        JScrollPane scroll = new JScrollPane(this.createGrid());
        scroll.setPreferredSize(scroll.getMinimumSize());
        panel.add((Component)scroll, "Center");
        panel.add((Component)new ButtonPanelAddCopyRemove(this.grid, this.tableModel, defaultValues), "South");
        this.grid.getTableHeader().setReorderingAllowed(false);
        return panel;
    }

    private JTable createGrid() {
        this.grid = new JTable();
        this.createTableModel();
        this.grid.setSelectionMode(0);
        this.grid.setMinimumSize(new Dimension(200, 100));
        this.grid.getColumnModel().getColumn(0).setPreferredWidth(200);
        this.grid.getColumnModel().getColumn(1).setPreferredWidth(120);
        this.grid.getColumnModel().getColumn(2).setPreferredWidth(50);
        this.grid.getColumnModel().getColumn(3).setPreferredWidth(500);
        return this.grid;
    }

    private void createTableModel() {
        this.tableModel = new PowerTableModel(columnIdentifiers, columnClasses);
        this.grid.setModel((TableModel)this.tableModel);
    }

    public TestElement createTestElement() {
        DbMonCollector te = new DbMonCollector();
        this.modifyTestElement((TestElement)te);
        te.setComment(JMeterPluginsUtils.getWikiLinkText((String)this.getWikiPage()));
        return te;
    }

    public void modifyTestElement(TestElement te) {
        super.modifyTestElement(te);
        if (this.grid.isEditing()) {
            this.grid.getCellEditor().stopCellEditing();
        }
        if (te instanceof DbMonCollector) {
            DbMonCollector dmte = (DbMonCollector)te;
            CollectionProperty rows = JMeterPluginsUtils.tableModelRowsToCollectionProperty((PowerTableModel)this.tableModel, (String)"samplers");
            dmte.setData(rows);
        }
        super.configureTestElement(te);
    }

    public void configure(TestElement te) {
        super.configure(te);
        DbMonCollector dmte = (DbMonCollector)te;
        JMeterProperty dbmonValues = dmte.getSamplerSettings();
        if (!(dbmonValues instanceof NullProperty)) {
            JMeterPluginsUtils.collectionPropertyToTableModelRows((CollectionProperty)((CollectionProperty)dbmonValues), (PowerTableModel)this.tableModel, (Class[])columnClasses);
        } else {
            log.warn("Received null property instead of collection");
        }
    }

    public void add(SampleResult res) {
        if (res.isSuccessful()) {
            if (this.isSampleIncluded(res)) {
                super.add(res);
                this.addDbMonRecord(res.getSampleLabel(), this.normalizeTime(res.getStartTime()), DbMonSampleResult.getValue(res));
                this.updateGui(null);
            }
        } else {
            this.addErrorMessage(res.getResponseMessage(), res.getStartTime());
        }
    }

    private void addDbMonRecord(String rowName, long time, double value) {
        AbstractGraphRow row = (AbstractGraphRow)this.model.get(rowName);
        if (row == null) {
            row = this.getNewRow(this.model, 0, rowName, 0, false, false, false, true, true);
        }
        row.add(time, value);
    }

    private class HideAction
    implements ActionListener {
        private HideAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DbMonGui.this.errorPane.setVisible(false);
            DbMonGui.this.updateGui();
        }
    }
}

