/*
 * Decompiled with CFR 0.152.
 */
package kg.apc.jmeter.samplers;

import java.io.UnsupportedEncodingException;
import org.apache.jmeter.samplers.AbstractSampler;
import org.apache.jmeter.samplers.Entry;
import org.apache.jmeter.samplers.Interruptible;
import org.apache.jmeter.samplers.SampleResult;

public class DummySampler
extends AbstractSampler
implements Interruptible {
    public static final String IS_SUCCESSFUL = "SUCCESFULL";
    public static final String RESPONSE_CODE = "RESPONSE_CODE";
    public static final String RESPONSE_MESSAGE = "RESPONSE_MESSAGE";
    public static final String RESPONSE_DATA = "RESPONSE_DATA";
    public static final String REQUEST_DATA = "REQUEST_DATA";
    public static final String RESPONSE_TIME = "RESPONSE_TIME";
    public static final String LATENCY = "LATENCY";
    public static final String CONNECT = "CONNECT";
    public static final String IS_WAITING = "WAITING";

    public SampleResult sample(Entry e) {
        SampleResult res;
        if (this.isSimulateWaiting()) {
            res = new SampleResult();
            res.sampleStart();
            try {
                Thread.sleep(this.getResponseTime());
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            res.sampleEnd();
        } else {
            res = new SampleResult(System.currentTimeMillis(), (long)this.getResponseTime());
        }
        res.setSampleLabel(this.getName());
        res.setSamplerData(this.getRequestData());
        res.setResponseCode(this.getResponseCode());
        res.setResponseMessage(this.getResponseMessage());
        res.setSuccessful(this.isSuccessfull());
        res.setDataType("text");
        try {
            res.setResponseData(this.getResponseData().getBytes(res.getDataEncodingWithDefault()));
        }
        catch (UnsupportedEncodingException exc) {
            throw new RuntimeException("Failed to get response data", exc);
        }
        res.setLatency((long)this.getLatency());
        try {
            if (SampleResult.class.getMethod("setConnectTime", Long.TYPE) != null) {
                res.setConnectTime((long)this.getConnectTime());
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        return res;
    }

    public void setSuccessful(boolean selected) {
        this.setProperty(IS_SUCCESSFUL, selected);
    }

    public void setSimulateWaiting(boolean selected) {
        this.setProperty(IS_WAITING, selected);
    }

    public void setResponseCode(String text) {
        this.setProperty(RESPONSE_CODE, text);
    }

    public void setResponseMessage(String text) {
        this.setProperty(RESPONSE_MESSAGE, text);
    }

    public void setResponseData(String text) {
        this.setProperty(RESPONSE_DATA, text);
    }

    public void setRequestData(String text) {
        this.setProperty(REQUEST_DATA, text);
    }

    public boolean isSuccessfull() {
        return this.getPropertyAsBoolean(IS_SUCCESSFUL);
    }

    public boolean isSimulateWaiting() {
        return this.getPropertyAsBoolean(IS_WAITING);
    }

    public String getResponseCode() {
        return this.getPropertyAsString(RESPONSE_CODE);
    }

    public String getResponseMessage() {
        return this.getPropertyAsString(RESPONSE_MESSAGE);
    }

    public String getResponseData() {
        return this.getPropertyAsString(RESPONSE_DATA);
    }

    public String getRequestData() {
        return this.getPropertyAsString(REQUEST_DATA);
    }

    public int getResponseTime() {
        int time = 0;
        try {
            time = Integer.valueOf(this.getPropertyAsString(RESPONSE_TIME));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return time;
    }

    public int getLatency() {
        int time = 0;
        try {
            time = Integer.valueOf(this.getPropertyAsString(LATENCY));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return time;
    }

    public void setResponseTime(String time) {
        this.setProperty(RESPONSE_TIME, time);
    }

    public void setLatency(String time) {
        this.setProperty(LATENCY, time);
    }

    public void setConnectTime(String time) {
        this.setProperty(CONNECT, time);
    }

    public boolean interrupt() {
        Thread.currentThread().interrupt();
        return true;
    }

    public int getConnectTime() {
        int time = 0;
        try {
            time = Integer.valueOf(this.getPropertyAsString(CONNECT));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return time;
    }
}

