/*
 * Decompiled with CFR 0.152.
 */
package com.atlantbh.jmeter.plugins.jmstools;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.jms.BytesMessage;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Session;
import org.springframework.jms.support.converter.MessageConversionException;
import org.springframework.jms.support.converter.MessageConverter;

public class BinaryMessageConverter
implements MessageConverter {
    private Map<String, String> messageProperties;

    public Map<String, String> getMessageProperties() {
        return this.messageProperties;
    }

    public void setMessageProperties(Map<String, String> messageProperties) {
        this.messageProperties = messageProperties;
    }

    public Object fromMessage(Message message) throws JMSException, MessageConversionException {
        Enumeration names = message.getPropertyNames();
        this.messageProperties = new HashMap<String, String>();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            this.messageProperties.put(name, message.getStringProperty(name));
        }
        BytesMessage bm = (BytesMessage)message;
        byte[] transfer = new byte[(int)bm.getBodyLength()];
        bm.readBytes(transfer);
        return new String(transfer);
    }

    public Message toMessage(Object arg0, Session session) throws JMSException, MessageConversionException {
        BytesMessage msg = session.createBytesMessage();
        msg.writeBytes(arg0.toString().getBytes());
        return msg;
    }
}

