/*
 * Decompiled with CFR 0.152.
 */
package com.atlantbh.jmeter.plugins.jsonutils.jsonpathassertion;

import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.Filter;
import com.jayway.jsonpath.Option;
import com.jayway.jsonpath.internal.JsonReader;
import java.io.Serializable;
import net.minidev.json.JSONArray;
import org.apache.jmeter.assertions.Assertion;
import org.apache.jmeter.assertions.AssertionResult;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.testelement.AbstractTestElement;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;
import org.apache.oro.text.regex.Pattern;

public class JSONPathAssertion
extends AbstractTestElement
implements Serializable,
Assertion {
    private static final Logger log = LoggingManager.getLoggerForClass();
    private static final long serialVersionUID = 1L;
    public static final String JSONPATH = "JSON_PATH";
    public static final String EXPECTEDVALUE = "EXPECTED_VALUE";
    public static final String JSONVALIDATION = "JSONVALIDATION";
    public static final String EXPECT_NULL = "EXPECT_NULL";
    public static final String INVERT = "INVERT";

    public String getJsonPath() {
        return this.getPropertyAsString(JSONPATH);
    }

    public void setJsonPath(String jsonPath) {
        this.setProperty(JSONPATH, jsonPath);
    }

    public String getExpectedValue() {
        return this.getPropertyAsString(EXPECTEDVALUE);
    }

    public void setExpectedValue(String expectedValue) {
        this.setProperty(EXPECTEDVALUE, expectedValue);
    }

    public void setJsonValidationBool(boolean jsonValidation) {
        this.setProperty(JSONVALIDATION, jsonValidation);
    }

    public void setExpectNull(boolean val) {
        this.setProperty(EXPECT_NULL, val);
    }

    public boolean isExpectNull() {
        return this.getPropertyAsBoolean(EXPECT_NULL);
    }

    public boolean isJsonValidationBool() {
        return this.getPropertyAsBoolean(JSONVALIDATION);
    }

    public void setInvert(boolean invert) {
        this.setProperty(INVERT, invert);
    }

    public boolean isInvert() {
        return this.getPropertyAsBoolean(INVERT);
    }

    private void doAssert(String jsonString) {
        JsonReader reader = new JsonReader(Configuration.defaultConfiguration().options(new Option[]{Option.THROW_ON_MISSING_PROPERTY}));
        reader.parse(jsonString);
        Object value = reader.read(this.getJsonPath(), new Filter[0]);
        if (this.isJsonValidationBool()) {
            if (value instanceof JSONArray) {
                JSONArray arr = (JSONArray)value;
                if (arr.isEmpty() && this.getExpectedValue().equals("[]")) {
                    return;
                }
                for (Object subj : arr.toArray()) {
                    if (this.isExpectNull() && subj == null) {
                        return;
                    }
                    if (!this.isEquals(subj.toString())) continue;
                    return;
                }
            } else {
                if (this.isExpectNull() && value == null) {
                    return;
                }
                if (this.isEquals(value.toString())) {
                    return;
                }
            }
            if (this.isExpectNull()) {
                throw new RuntimeException(String.format("Value expected to be null, but found '%s'", value));
            }
            throw new RuntimeException(String.format("Value expected to be '%s', but found '%s'", this.getExpectedValue(), value));
        }
    }

    private boolean isEquals(String subj) {
        Pattern pattern = JMeterUtils.getPatternCache().getPattern(this.getExpectedValue());
        return JMeterUtils.getMatcher().matches(subj, pattern);
    }

    public AssertionResult getResult(SampleResult samplerResult) {
        AssertionResult result;
        block12: {
            result = new AssertionResult(this.getName());
            byte[] responseData = samplerResult.getResponseData();
            if (responseData.length == 0) {
                return result.setResultForNull();
            }
            result.setFailure(false);
            result.setFailureMessage("");
            if (!this.isInvert()) {
                try {
                    this.doAssert(new String(responseData));
                }
                catch (Exception e) {
                    if (log.isDebugEnabled()) {
                        log.debug("Assertion failed", (Throwable)e);
                    }
                    result.setFailure(true);
                    result.setFailureMessage(e.getMessage());
                }
            } else {
                try {
                    this.doAssert(new String(responseData));
                    result.setFailure(true);
                    if (this.isJsonValidationBool()) {
                        if (this.isExpectNull()) {
                            result.setFailureMessage("Failed that JSONPath " + this.getJsonPath() + " not matches null");
                        } else {
                            result.setFailureMessage("Failed that JSONPath " + this.getJsonPath() + " not matches " + this.getExpectedValue());
                        }
                    } else {
                        result.setFailureMessage("Failed that JSONPath not exists: " + this.getJsonPath());
                    }
                }
                catch (Exception e) {
                    if (!log.isDebugEnabled()) break block12;
                    log.debug("Assertion failed", (Throwable)e);
                }
            }
        }
        return result;
    }
}

