/*
 * Decompiled with CFR 0.152.
 */
package kg.apc.emulators;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import kg.apc.emulators.EmulatorJmeterEngine;
import kg.apc.emulators.EmulatorThreadMonitor;
import kg.apc.jmeter.DirectoryAnchor;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.jmeter.control.LoopController;
import org.apache.jmeter.engine.StandardJMeterEngine;
import org.apache.jmeter.gui.GuiPackage;
import org.apache.jmeter.gui.tree.JMeterTreeListener;
import org.apache.jmeter.gui.tree.JMeterTreeModel;
import org.apache.jmeter.threads.AbstractThreadGroup;
import org.apache.jmeter.threads.JMeterContextService;
import org.apache.jmeter.threads.JMeterThread;
import org.apache.jmeter.threads.JMeterThreadMonitor;
import org.apache.jmeter.threads.JMeterVariables;
import org.apache.jmeter.threads.ThreadGroup;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.collections.HashTree;
import org.junit.Test;

public abstract class TestJMeterUtils {
    private static JMeterTreeListener jMeterTreeListener;
    private static JMeterTreeModel jMeterTreeModel;

    public static void createJmeterEnv() {
        File propsFile = null;
        try {
            propsFile = File.createTempFile("jmeter-plugins", ".properties");
            propsFile.deleteOnExit();
        }
        catch (IOException ex) {
            ex.printStackTrace(System.err);
        }
        JMeterUtils.loadJMeterProperties((String)propsFile.getAbsolutePath());
        JMeterUtils.setJMeterHome((String)new DirectoryAnchor().toString());
        JMeterUtils.setLocale((Locale)new Locale("ignoreResources"));
        jMeterTreeModel = new JMeterTreeModel();
        jMeterTreeListener = new JMeterTreeListener();
        jMeterTreeListener.setModel(jMeterTreeModel);
        GuiPackage.getInstance((JMeterTreeListener)jMeterTreeListener, (JMeterTreeModel)jMeterTreeModel);
        JMeterContextService.getContext().setVariables(new JMeterVariables());
        EmulatorJmeterEngine engine = new EmulatorJmeterEngine();
        EmulatorThreadMonitor monitor = new EmulatorThreadMonitor();
        JMeterContextService.getContext().setEngine((StandardJMeterEngine)engine);
        HashTree hashtree = new HashTree();
        hashtree.add((Object)new LoopController());
        JMeterThread thread = new JMeterThread(hashtree, (JMeterThreadMonitor)monitor, null);
        thread.setThreadName("test thread");
        JMeterContextService.getContext().setThread(thread);
        ThreadGroup threadGroup = new ThreadGroup();
        threadGroup.setName("test thread group");
        JMeterContextService.getContext().setThreadGroup((AbstractThreadGroup)threadGroup);
        JMeterUtils.setProperty((String)"sample_variables", (String)"TEST1,TEST2,TEST3");
    }

    public static String getTempDir() {
        File f = null;
        try {
            f = File.createTempFile("jmeterplugins", ".tmp");
        }
        catch (IOException ex) {
            Logger.getLogger(TestJMeterUtils.class.getName()).log(Level.SEVERE, null, ex);
        }
        return f.getParent();
    }

    public static String getTestData(int i) {
        return RandomStringUtils.randomAlphanumeric((int)i);
    }

    @Test
    public void testEnv() {
        TestJMeterUtils.createJmeterEnv();
        GuiPackage.getInstance().updateCurrentNode();
    }

    public static String fixWinPath(String path) {
        boolean isWinOs;
        String ret = path;
        boolean bl = isWinOs = System.getProperty("os.name").toLowerCase().indexOf("win") >= 0;
        if (isWinOs) {
            ret = ret.replace("Documents%20and%20Settings", "DOCUME~1");
            ret = ret.replace("Local%20Settings", "LOCALS~1");
            ret = ret.replace("Application%20Data", "APPLIC~1");
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String convertStreamToString(InputStream is) throws IOException {
        if (is != null) {
            StringWriter writer = new StringWriter();
            char[] buffer = new char[1024];
            try {
                int n;
                BufferedReader reader = new BufferedReader(new InputStreamReader(is, "UTF-8"));
                while ((n = reader.read(buffer)) != -1) {
                    ((Writer)writer).write(buffer, 0, n);
                }
            }
            finally {
                is.close();
            }
            return ((Object)writer).toString();
        }
        return "";
    }
}

