/*
 * Decompiled with CFR 0.152.
 */
package kg.apc.jmeter.config;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Map;
import javax.swing.JTextArea;
import kg.apc.jmeter.config.VariablesFromCSV;
import kg.apc.jmeter.config.VariablesFromCSVGui;

public class TestCsvFileAction
implements ActionListener {
    private final VariablesFromCSVGui variablesCsvUi;

    public TestCsvFileAction(VariablesFromCSVGui variablesCsvUi) {
        this.variablesCsvUi = variablesCsvUi;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        JTextArea infoArea = this.variablesCsvUi.getCheckInfoTextArea();
        infoArea.setText("");
        infoArea.setForeground(Color.black);
        VariablesFromCSV testElem = (VariablesFromCSV)this.variablesCsvUi.createTestElement();
        boolean noValues = true;
        StringBuilder msgVars = new StringBuilder();
        int count = 0;
        try {
            Map<String, String> vars = testElem.getArgumentsAsMap();
            for (Map.Entry<String, String> element : vars.entrySet()) {
                String var = element.getKey();
                String value = element.getValue();
                if (!"".equals(value)) {
                    noValues = false;
                }
                msgVars.append("${").append(var).append("} = ").append(value).append("\n");
                ++count;
            }
            if (count == 0) {
                this.reportError("File parsed, but no variable found.");
            } else if (noValues) {
                this.reportOk("WARNING: File parsed, " + count + " variable" + (count > 1 ? "s" : "") + " found, but no variable have value!");
                this.reportOk(msgVars.toString());
            } else {
                this.reportOk("File successfuly parsed, " + count + " variable" + (count > 1 ? "s" : "") + " found:");
                this.reportOk(msgVars.toString());
            }
        }
        catch (Exception ex) {
            this.reportError("Error processing file: " + ex.toString());
        }
    }

    private void reportError(String msg) {
        JTextArea infoArea = this.variablesCsvUi.getCheckInfoTextArea();
        infoArea.setText(infoArea.getText() + "Problem detected: " + msg + "\n");
        infoArea.setForeground(Color.red);
    }

    private void reportOk(String string) {
        JTextArea infoArea = this.variablesCsvUi.getCheckInfoTextArea();
        infoArea.setText(infoArea.getText() + string + "\n");
    }
}

