/*
 * Decompiled with CFR 0.152.
 */
package org.jmeterplugins.protocol.http.control;

import java.io.IOException;
import org.apache.jmeter.gui.GuiPackage;
import org.apache.jmeter.gui.Stoppable;
import org.apache.jmeter.testelement.AbstractTestElement;
import org.apache.jmeter.testelement.property.BooleanProperty;
import org.apache.jmeter.testelement.property.IntegerProperty;
import org.apache.jmeter.testelement.property.JMeterProperty;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;
import org.jmeterplugins.protocol.http.control.HttpSimpleTableServer;

public class HttpSimpleTableControl
extends AbstractTestElement {
    private static final long serialVersionUID = 233L;
    private static final Logger log = LoggingManager.getLoggerForClass();
    private transient HttpSimpleTableServer server;
    public static final int DEFAULT_PORT = 9191;
    public static final String DEFAULT_PORT_S = Integer.toString(9191);
    public static final String DEFAULT_DATA_DIR = JMeterUtils.getJMeterBinDir();
    public static final boolean DEFAULT_TIMESTAMP = true;
    public static final String DEFAULT_TIMESTAMP_S = Boolean.toString(true);
    public static final String PORT = "HttpSimpleTableControlGui.port";
    public static final String DATA_DIR = "HttpSimpleTableControlGui.dir";
    public static final String TIMESTAMP = "HttpSimpleTableControlGui.timestamp";

    public HttpSimpleTableControl() {
        this.setPort(JMeterUtils.getPropDefault((String)"jmeterPlugin.sts.port", (int)9191));
        this.setTimestamp(JMeterUtils.getPropDefault((String)"jmeterPlugin.sts.addTimestamp", (boolean)true));
        this.setDataDir(JMeterUtils.getPropDefault((String)"jmeterPlugin.sts.datasetDirectory", (String)DEFAULT_DATA_DIR));
    }

    private void setPort(int port) {
        this.setProperty((JMeterProperty)new IntegerProperty(PORT, port));
    }

    public void setPort(String port) {
        this.setProperty(PORT, port);
    }

    public int getPort() {
        return this.getPropertyAsInt(PORT, 9191);
    }

    public String getPortString() {
        return this.getPropertyAsString(PORT, DEFAULT_PORT_S);
    }

    public boolean getTimestamp() {
        return this.getPropertyAsBoolean(TIMESTAMP, true);
    }

    public void setTimestamp(boolean timestamp) {
        this.setProperty((JMeterProperty)new BooleanProperty(TIMESTAMP, timestamp));
    }

    public String getDataDir() {
        return this.getPropertyAsString(DATA_DIR, DEFAULT_DATA_DIR);
    }

    public void setDataDir(String dataDir) {
        this.setProperty(DATA_DIR, dataDir);
    }

    public void startHttpSimpleTable() throws IOException {
        log.info("Creating HTTP Simple Table Server...");
        log.info("Port=" + this.getPort());
        log.info("Dataset directory=" + this.getDataDir());
        log.info("Timestamp=" + this.getTimestamp());
        this.server = new HttpSimpleTableServer(this.getPort(), this.getTimestamp(), this.getDataDir());
        this.server.start();
        GuiPackage instance = GuiPackage.getInstance();
        if (instance != null) {
            instance.register((Stoppable)this.server);
        }
    }

    public void stopHttpSimpleTable() {
        if (this.server != null) {
            this.server.stopServer();
            GuiPackage instance = GuiPackage.getInstance();
            if (instance != null) {
                instance.unregister((Stoppable)this.server);
            }
            this.server = null;
        }
    }

    public boolean canRemove() {
        return null == this.server;
    }

    public boolean isServerAlive() {
        return this.server != null && this.server.isAlive();
    }
}

