/*
 * Decompiled with CFR 0.152.
 */
package org.jmeterplugins.protocol.http.control;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import org.apache.jmeter.gui.Stoppable;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;
import org.jmeterplugins.protocol.http.control.HttpSimpleTableControl;
import org.jmeterplugins.protocol.http.control.KeyWaiter;
import org.jmeterplugins.protocol.http.control.NanoHTTPD;
import org.jmeterplugins.protocol.http.control.ServerRunner;

public class HttpSimpleTableServer
extends NanoHTTPD
implements Stoppable,
KeyWaiter {
    private static final Logger log = LoggingManager.getLoggerForClass();
    public static final String ROOT = "/sts/";
    public static final String ROOT2 = "/sts";
    public static final String URI_INITFILE = "INITFILE";
    public static final String URI_READ = "READ";
    public static final String URI_ADD = "ADD";
    public static final String URI_SAVE = "SAVE";
    public static final String URI_LENGTH = "LENGTH";
    public static final String URI_STATUS = "STATUS";
    public static final String URI_RESET = "RESET";
    public static final String URI_STOP = "STOP";
    public static final String PARM_FILENAME = "FILENAME";
    public static final String PARM_LINE = "LINE";
    public static final String PARM_READ_MODE = "READ_MODE";
    public static final String PARM_ADD_MODE = "ADD_MODE";
    public static final String PARM_KEEP = "KEEP";
    public static final String VAL_FIRST = "FIRST";
    public static final String VAL_LAST = "LAST";
    public static final String VAL_RANDOM = "RANDOM";
    public static final String VAL_TRUE = "TRUE";
    public static final String VAL_FALSE = "FALSE";
    public static final String INDEX = "<html><head><title>URL for the dataset</title><head><body><h4>From a data file (default: &lt;JMETER_HOME&gt;/bin/[data_file])</h4><p>Load file in memory:<br />http://hostname:port/sts/INITFILE?FILENAME=file.txt</p><p>Get one line from list:<br />http://hostname:port/sts/READ?READ_MODE=[<i>FIRST</i>,<i>LAST</i>,<i>RANDOM</i>]&KEEP=[<i>TRUE</i>,<i>FALSE</i>]&FILENAME=file.txt</p><p>Return the number of remaining lines of a linked list:<br />http://hostname:port/sts/LENGTH?FILENAME=file.txt</p><p>Add a line into a file: (POST HTTP protocol)<br />FILENAME=file.txt,LINE=D0001123,ADD_MODE=[<i>FIRST</i>,<i>LAST</i>]</p><p>Save the specified linked list in a file to the default location:<br />http://hostname:port/sts/SAVE?FILENAME=file.txt</p><p>Display the list of loaded files and the number of remaining lines for each linked list:<br />http://hostname:port/sts/STATUS</p><p>Remove all of the elements from the specified list:<br />http://hostname:port/sts/RESET?FILENAME=file.txt</p><p>Shutdown the Simple Table Server:<br />http://hostname:port/sts/STOP</p></body></html>";
    private String myDataDirectory;
    private boolean bTimestamp;
    private Random myRandom;
    public static String lineSeparator = System.getProperty("line.separator");
    private Map<String, LinkedList<String>> database = new HashMap<String, LinkedList<String>>();

    public HttpSimpleTableServer(int port, boolean timestamp, String dataDir) {
        super(port);
        this.myDataDirectory = dataDir;
        this.bTimestamp = timestamp;
        this.myRandom = new Random();
    }

    @Override
    public NanoHTTPD.Response serve(NanoHTTPD.IHTTPSession session) {
        NanoHTTPD.Method method = session.getMethod();
        String uri = session.getUri();
        String msg = "<html><title>KO</title>" + lineSeparator + "<body>Error : unknown command !</body>" + lineSeparator + "</html>";
        HashMap<String, String> files = new HashMap<String, String>();
        if (NanoHTTPD.Method.POST.equals((Object)method)) {
            try {
                session.parseBody(files);
            }
            catch (IOException ioe) {
                return new NanoHTTPD.Response(NanoHTTPD.Response.Status.INTERNAL_ERROR, "text/plain", "SERVER INTERNAL ERROR: IOException: " + ioe.getMessage());
            }
            catch (NanoHTTPD.ResponseException re) {
                return new NanoHTTPD.Response(re.getStatus(), "text/plain", re.getMessage());
            }
        }
        Map<String, String> parms = session.getParms();
        msg = uri.equals(ROOT) || uri.equals(ROOT2) ? INDEX : this.doAction(uri, method, parms);
        return new NanoHTTPD.Response(msg);
    }

    protected synchronized String doAction(String uri, NanoHTTPD.Method method, Map<String, String> parms) {
        String msg = "<html><title>KO</title>" + lineSeparator + "<body>Error : unknown command !</body>" + lineSeparator + "</html>";
        if (uri.equals("/sts/INITFILE")) {
            msg = this.initFile(parms.get(PARM_FILENAME));
        }
        if (uri.equals("/sts/READ")) {
            msg = this.read(parms.get(PARM_READ_MODE), parms.get(PARM_KEEP), parms.get(PARM_FILENAME));
        }
        if (uri.equals("/sts/ADD") && NanoHTTPD.Method.POST.equals((Object)method)) {
            msg = this.add(parms.get(PARM_ADD_MODE), parms.get(PARM_LINE), parms.get(PARM_FILENAME));
        }
        if (uri.equals("/sts/LENGTH")) {
            msg = this.length(parms.get(PARM_FILENAME));
        }
        if (uri.equals("/sts/SAVE")) {
            msg = this.save(parms.get(PARM_FILENAME));
        }
        if (uri.equals("/sts/STATUS")) {
            msg = this.status();
        }
        if (uri.equals("/sts/RESET")) {
            msg = this.reset(parms.get(PARM_FILENAME));
        }
        if (uri.equals("/sts/STOP")) {
            this.stopServer();
        }
        return msg;
    }

    private String status() {
        if (this.database.isEmpty()) {
            return "<html><title>KO</title>" + lineSeparator + "<body>Error : Database was empty !</body>" + lineSeparator + "</html>";
        }
        String msg = "";
        for (String key : this.database.keySet()) {
            msg = msg + key + " = " + this.database.get(key).size() + "<br />" + lineSeparator;
        }
        return "<html><title>OK</title>" + lineSeparator + "<body>" + lineSeparator + msg + "</body></html>";
    }

    private String read(String readMode, String keepMode, String filename) {
        if (null == filename) {
            return "<html><title>KO</title>" + lineSeparator + "<body>Error : FILENAME parameter was missing !</body>" + lineSeparator + "</html>";
        }
        if (!this.database.containsKey(filename)) {
            return "<html><title>KO</title>" + lineSeparator + "<body>Error : " + filename + " not loaded yet !</body>" + lineSeparator + "</html>";
        }
        if (this.database.get(filename).isEmpty()) {
            return "<html><title>KO</title>" + lineSeparator + "<body>Error : No more line !</body>" + lineSeparator + "</html>";
        }
        if (null == readMode) {
            readMode = VAL_FIRST;
        }
        if (null == keepMode) {
            keepMode = VAL_TRUE;
        }
        if (!(VAL_FIRST.equals(readMode) || VAL_LAST.equals(readMode) || VAL_RANDOM.equals(readMode))) {
            return "<html><title>KO</title>" + lineSeparator + "<body>Error : READ_MODE value has to be FIRST, LAST or RANDOM !</body>" + lineSeparator + "</html>";
        }
        if (!VAL_TRUE.equals(keepMode) && !VAL_FALSE.equals(keepMode)) {
            return "<html><title>KO</title>" + lineSeparator + "<body>Error : KEEP value has to be TRUE or FALSE !</body>" + lineSeparator + "</html>";
        }
        int index = 0;
        if (VAL_LAST.equals(readMode)) {
            index = this.database.get(filename).size() - 1;
        }
        if (VAL_RANDOM.equals(readMode)) {
            index = this.myRandom.nextInt(this.database.get(filename).size());
        }
        String line = this.database.get(filename).remove(index);
        if (VAL_TRUE.equals(keepMode)) {
            this.database.get(filename).add(line);
        }
        return "<html><title>OK</title>" + lineSeparator + "<body>" + line + "</body>" + lineSeparator + "</html>";
    }

    private String add(String addMode, String line, String filename) {
        if (null == filename) {
            return "<html><title>KO</title>" + lineSeparator + "<body>Error : FILENAME parameter was missing !</body>" + lineSeparator + "</html>";
        }
        if (null == line) {
            return "<html><title>KO</title>" + lineSeparator + "<body>Error : LINE parameter was missing !</body>" + lineSeparator + "</html>";
        }
        if (!this.database.containsKey(filename)) {
            this.database.put(filename, new LinkedList());
        }
        if (null == addMode) {
            addMode = VAL_FIRST;
        }
        if (!VAL_FIRST.equals(addMode) && !VAL_LAST.equals(addMode)) {
            return "<html><title>KO</title>" + lineSeparator + "<body>Error : ADD_MODE value has to be FIRST or LAST !</body>" + lineSeparator + "</html>";
        }
        if (VAL_FIRST.equals(addMode)) {
            this.database.get(filename).addFirst(line);
        } else {
            this.database.get(filename).add(line);
        }
        return "<html><title>OK</title>" + lineSeparator + "<body></body>" + lineSeparator + "</html>";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String save(String filename) {
        String string;
        if (null == filename) {
            return "<html><title>KO</title>" + lineSeparator + "<body>Error : FILENAME parameter was missing !</body>" + lineSeparator + "</html>";
        }
        if (filename.matches(".*[\\\\/:].*") || filename.equals(".") || filename.equals("..")) {
            return "<html><title>KO</title>" + lineSeparator + "<body>Error : Illegal character found !</body>" + lineSeparator + "</html>";
        }
        if (filename.length() > 128) {
            return "<html><title>KO</title>" + lineSeparator + "<body>Error : Maximum size reached (128) !</body>" + lineSeparator + "</html>";
        }
        if (!this.database.containsKey(filename)) {
            return "<html><title>KO</title>" + lineSeparator + "<body>Error : LinkedList not found !</body>" + lineSeparator + "</html>";
        }
        BufferedWriter out = null;
        String saveFilename = filename;
        if (this.bTimestamp) {
            Date dNow = new Date();
            SimpleDateFormat ft = new SimpleDateFormat("yyyyMMdd'T'HH'h'mm'm'ss's.'");
            saveFilename = ft.format(dNow) + filename;
        }
        try {
            Iterator it = this.database.get(filename).iterator();
            out = new BufferedWriter(new FileWriter(new File(this.myDataDirectory, saveFilename)));
            while (it.hasNext()) {
                out.write((String)it.next());
                out.write(lineSeparator);
            }
        }
        catch (FileNotFoundException e1) {
            string = "<html><title>KO</title>" + lineSeparator + "<body>Error : " + e1.getMessage() + "</body>" + lineSeparator + "</html>";
            return string;
        }
        catch (IOException e2) {
            string = "<html><title>KO</title>" + lineSeparator + "<body>Error : " + e2.getMessage() + "</body>" + lineSeparator + "</html>";
            return string;
        }
        finally {
            if (null != out) {
                try {
                    out.close();
                }
                catch (IOException e3) {
                    return "<html><title>KO</title>" + lineSeparator + "<body>Error : " + e3.getMessage() + "</body>" + lineSeparator + "</html>";
                }
            }
        }
        return "<html><title>OK</title>" + lineSeparator + "<body>" + this.database.get(filename).size() + "</body>" + lineSeparator + "</html>";
    }

    private String length(String filename) {
        if (null == filename) {
            return "<html><title>KO</title>" + lineSeparator + "<body>Error : FILENAME parameter was missing !</body>" + lineSeparator + "</html>";
        }
        if (!this.database.containsKey(filename)) {
            return "<html><title>KO</title>" + lineSeparator + "<body>Error : " + filename + " not loaded yet !</body>" + lineSeparator + "</html>";
        }
        return "<html><title>OK</title>" + lineSeparator + "<body>" + this.database.get(filename).size() + "</body>" + lineSeparator + "</html>";
    }

    private String reset(String filename) {
        if (null == filename) {
            return "<html><title>KO</title>" + lineSeparator + "<body>Error : FILENAME parameter was missing !</body>" + lineSeparator + "</html>";
        }
        if (this.database.containsKey(filename)) {
            this.database.get(filename).clear();
        }
        return "<html><title>OK</title>" + lineSeparator + "<body></body>" + lineSeparator + "</html>";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String initFile(String filename) {
        if (null == filename) {
            return "<html><title>KO</title>" + lineSeparator + "<body>Error : FILENAME parameter was missing !</body>" + lineSeparator + "</html>";
        }
        LinkedList<String> lines = new LinkedList<String>();
        BufferedReader bufferReader = null;
        File f = new File(this.myDataDirectory, filename);
        if (f.exists()) {
            try {
                String line;
                bufferReader = new BufferedReader(new FileReader(f), 51200);
                while ((line = bufferReader.readLine()) != null) {
                    lines.add(line);
                }
            }
            catch (FileNotFoundException e1) {
                String string = "<html><title>KO</title>" + lineSeparator + "<body>Error : " + e1.getMessage() + "</body>" + lineSeparator + "</html>";
                return string;
            }
            catch (IOException e2) {
                String string = "<html><title>KO</title>" + lineSeparator + "<body>Error : " + e2.getMessage() + "</body>" + lineSeparator + "</html>";
                return string;
            }
            finally {
                if (null != bufferReader) {
                    try {
                        bufferReader.close();
                    }
                    catch (IOException e3) {
                        return "<html><title>KO</title>" + lineSeparator + "<body>Error : " + e3.getMessage() + "</body>" + lineSeparator + "</html>";
                    }
                }
            }
            this.database.put(filename, lines);
            return "<html><title>OK</title>" + lineSeparator + "<body>" + lines.size() + "</body>" + lineSeparator + "</html>";
        }
        return "<html><title>KO</title>" + lineSeparator + "<body>Error : file not found !</body>" + lineSeparator + "</html>";
    }

    public void stopServer() {
        log.info("HTTP Simple Table Server is shutting down...");
        this.stop();
    }

    public static void main(String[] args) {
        JMeterUtils.loadJMeterProperties((String)"jmeter.properties");
        String dataset = JMeterUtils.getPropDefault((String)"jmeterPlugin.sts.datasetDirectory", (String)HttpSimpleTableControl.DEFAULT_DATA_DIR);
        int port = JMeterUtils.getPropDefault((String)"jmeterPlugin.sts.port", (int)9191);
        boolean timestamp = JMeterUtils.getPropDefault((String)"jmeterPlugin.sts.addTimestamp", (boolean)true);
        LoggingManager.setPriority((String)"INFO");
        LoggingManager.setLoggingLevels((Properties)System.getProperties());
        HttpSimpleTableServer serv = new HttpSimpleTableServer(port, timestamp, dataset);
        log.info("Creating HttpSimpleTable ...");
        log.info("------------------------------");
        log.info("SERVER_PORT : " + port);
        log.info("DATASET_DIR : " + dataset);
        log.info("TIMESTAMP : " + timestamp);
        log.info("------------------------------");
        ServerRunner.executeInstance(serv);
    }

    @Override
    public void waitForKey() {
        log.info("Hit Enter to stop");
        try {
            System.in.read();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

