/*
 * Decompiled with CFR 0.152.
 */
package com.atlantbh.jmeter.plugins.xmlformatter;

import java.io.ByteArrayInputStream;
import java.io.StringWriter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

public class XmlUtil {
    private static Transformer transformer;
    private static DocumentBuilder builder;

    public static Document stringToXml(String string) throws Exception {
        if (builder == null) {
            throw new Exception("DocumentBuilder is null.");
        }
        return builder.parse(new InputSource(new ByteArrayInputStream(string.getBytes("UTF-8"))));
    }

    public static String xmlToString(Document document) throws Exception {
        if (transformer == null) {
            throw new Exception("Transformer is null");
        }
        DOMSource xmlSource = new DOMSource(document);
        StringWriter stringWriter = new StringWriter();
        StreamResult result = new StreamResult(stringWriter);
        transformer.transform(xmlSource, result);
        return stringWriter.toString();
    }

    static {
        try {
            transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
            builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            transformer = null;
            builder = null;
        }
    }
}

