/*
 * Decompiled with CFR 0.152.
 */
package kg.apc.jmeter.functions;

import java.util.Collection;
import java.util.EnumSet;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.jmeter.engine.util.CompoundVariable;
import org.apache.jmeter.functions.AbstractFunction;
import org.apache.jmeter.functions.InvalidVariableException;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.samplers.Sampler;
import org.apache.jmeter.threads.JMeterVariables;
import org.apache.jmeter.util.JMeterUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CaseFormat
extends AbstractFunction {
    private static final String CHANGE_CASE_MODE = "Change case mode";
    private static final String STRING_TO_MODIFY = "String to modify";
    private static final String HYPHEN_MINUS = "-";
    private static final String UNDERSCORE = "_";
    private static final Pattern NOT_ALPHANUMERIC_REGEX = Pattern.compile("[\\s\\-_]+");
    private static final Logger LOGGER = LoggerFactory.getLogger(CaseFormat.class);
    private static final List<String> DESC = new LinkedList<String>();
    private static final String KEY = "__caseFormat";
    private static final int MIN_PARAMETER_COUNT = 1;
    private static final int MAX_PARAMETER_COUNT = 3;
    private CompoundVariable[] values;

    public String execute(SampleResult previousResult, Sampler currentSampler) throws InvalidVariableException {
        String originalString = this.values[0].execute();
        String mode = null;
        if (this.values.length > 1) {
            mode = this.values[1].execute();
        }
        if (StringUtils.isEmpty(mode)) {
            mode = CaseFormatMode.LOWER_CAMEL_CASE.getName();
        }
        String targetString = this.changeCase(originalString, mode);
        if (this.values.length > 2) {
            this.addVariableValue(targetString, this.values[2].execute().trim());
        }
        return targetString;
    }

    protected String changeCase(String originalString, String mode) {
        String targetString = originalString;
        CaseFormatMode changeCaseMode = CaseFormatMode.typeOf(mode.toUpperCase());
        if (changeCaseMode != null) {
            switch (changeCaseMode) {
                case LOWER_CAMEL_CASE: {
                    targetString = CaseFormat.camelFormat(originalString, false);
                    break;
                }
                case UPPER_CAMEL_CASE: {
                    targetString = CaseFormat.camelFormat(originalString, true);
                    break;
                }
                case SNAKE_CASE: 
                case LOWER_UNDERSCORE: {
                    targetString = CaseFormat.caseFormatWithDelimiter(originalString, UNDERSCORE, false, true);
                    break;
                }
                case KEBAB_CASE: 
                case LISP_CASE: 
                case SPINAL_CASE: 
                case LOWER_HYPHEN: {
                    targetString = CaseFormat.caseFormatWithDelimiter(originalString, HYPHEN_MINUS, false, true);
                    break;
                }
                case TRAIN_CASE: {
                    targetString = CaseFormat.caseFormatWithDelimiter(originalString, HYPHEN_MINUS, true, false);
                    break;
                }
                case UPPER_UNDERSCORE: {
                    targetString = CaseFormat.caseFormatWithDelimiter(originalString, UNDERSCORE, true, false);
                    break;
                }
            }
        } else {
            LOGGER.error("Unknown mode {}, returning {} unchanged", (Object)mode, (Object)targetString);
        }
        return targetString;
    }

    public void setParameters(Collection<CompoundVariable> parameters) throws InvalidVariableException {
        this.checkParameterCount(parameters, 1, 3);
        this.values = parameters.toArray(new CompoundVariable[parameters.size()]);
    }

    public String getReferenceKey() {
        return KEY;
    }

    public List<String> getArgumentDesc() {
        return DESC;
    }

    private static String camelFormat(String str, boolean isFirstCapitalized) {
        StringBuilder builder = new StringBuilder(str.length());
        String[] tokens = NOT_ALPHANUMERIC_REGEX.split(str);
        for (int i = 0; i < tokens.length; ++i) {
            String lowerCased = StringUtils.lowerCase((String)tokens[i]);
            if (i == 0) {
                builder.append(isFirstCapitalized ? StringUtils.capitalize((String)lowerCased) : lowerCased);
                continue;
            }
            builder.append(StringUtils.capitalize((String)lowerCased));
        }
        return builder.toString();
    }

    private static String caseFormatWithDelimiter(String str, String delimiter, boolean isAllUpper, boolean isAllLower) {
        StringBuilder builder = new StringBuilder(str.length());
        String[] tokens = NOT_ALPHANUMERIC_REGEX.split(str);
        boolean shouldAddDelimiter = StringUtils.isNotEmpty((CharSequence)delimiter);
        for (int i = 0; i < tokens.length; ++i) {
            boolean hasNextToken;
            String currentToken = tokens[i];
            builder.append(currentToken);
            boolean bl = hasNextToken = i + 1 != tokens.length;
            if (!hasNextToken || !shouldAddDelimiter) continue;
            builder.append(delimiter);
        }
        String outputString = builder.toString();
        if (isAllLower) {
            return StringUtils.lowerCase((String)outputString);
        }
        if (isAllUpper) {
            return StringUtils.upperCase((String)outputString);
        }
        return outputString;
    }

    private final void addVariableValue(String value, String variableName) {
        JMeterVariables vars;
        if (StringUtils.isNotEmpty((CharSequence)variableName) && (vars = this.getVariables()) != null) {
            vars.put(variableName, value);
        }
    }

    static {
        DESC.add(STRING_TO_MODIFY);
        DESC.add(CHANGE_CASE_MODE);
        DESC.add(JMeterUtils.getResString((String)"function_name_paropt"));
    }

    public static enum CaseFormatMode {
        UPPER_CAMEL_CASE("UPPER_CAMEL_CASE"),
        LOWER_CAMEL_CASE("LOWER_CAMEL_CASE"),
        SNAKE_CASE("SNAKE_CASE"),
        LISP_CASE("LISP_CASE"),
        KEBAB_CASE("KEBAB_CASE"),
        SPINAL_CASE("SPINAL_CASE"),
        LOWER_HYPHEN("LOWER_HYPHEN"),
        LOWER_UNDERSCORE("LOWER_UNDERSCORE"),
        UPPER_UNDERSCORE("UPPER_UNDERSCORE"),
        TRAIN_CASE("TRAIN_CASE");

        private String mode;

        private CaseFormatMode(String mode) {
            this.mode = mode;
        }

        public String getName() {
            return this.mode;
        }

        public static CaseFormatMode typeOf(String mode) {
            EnumSet<CaseFormatMode> caseFormatModes = EnumSet.allOf(CaseFormatMode.class);
            for (CaseFormatMode caseFormatMode : caseFormatModes) {
                if (!caseFormatMode.getName().equals(mode)) continue;
                return caseFormatMode;
            }
            return null;
        }
    }
}

