/*
 * Decompiled with CFR 0.152.
 */
package com.atlantbh.jmeter.plugins.hadooputilities.hdfsoperations;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.jmeter.samplers.AbstractSampler;
import org.apache.jmeter.samplers.Entry;
import org.apache.jmeter.samplers.SampleResult;

public class HdfsOperations
extends AbstractSampler {
    private static final long serialVersionUID = 1L;
    private Configuration config = null;
    private FileSystem hdfs = null;
    private static final String INPUTPATH = "INPUTPATH";
    private static final String OUTPUTPATH = "OUTPUTPATH";
    private static final String UPLOADSUCCESS = "UPLOADSUCCESS";
    private static final String NAMENODE = "NAMENODE";
    private String extractedLine = "";

    public HdfsOperations() {
    }

    public HdfsOperations(String nameNode) throws IOException {
        this.config = new Configuration();
        this.config.set("fs.default.name", nameNode);
        this.hdfs = FileSystem.get((Configuration)this.config);
    }

    public void setExtractedLine(String extractedLine) {
        this.extractedLine = extractedLine;
    }

    public String getExtractedLine() {
        return this.extractedLine;
    }

    public void setNameNode(String nameNode) {
        this.setProperty(NAMENODE, nameNode);
    }

    public String getNameNode() {
        return this.getPropertyAsString(NAMENODE);
    }

    public void setUploadSuccess(String uploadSuccess) {
        this.setProperty(UPLOADSUCCESS, uploadSuccess);
    }

    public String getUploadSuccess() {
        return this.getPropertyAsString(UPLOADSUCCESS);
    }

    public void setInputFilePath(String inputFilePath) {
        this.setProperty(INPUTPATH, inputFilePath);
    }

    public String getInputFilePath() {
        return this.getPropertyAsString(INPUTPATH);
    }

    public void setOutputFilePath(String outputFilePath) {
        this.setProperty(OUTPUTPATH, outputFilePath);
    }

    public String getOutputFilePath() {
        return this.getPropertyAsString(OUTPUTPATH);
    }

    private void initializeConnection() throws IOException {
        this.config = new Configuration();
        this.config.set("fs.default.name", this.getNameNode());
        this.hdfs = FileSystem.get((Configuration)this.config);
    }

    private void copyFileToHDFS() throws IOException {
        Path localPath = new Path(this.getInputFilePath());
        Path hdfsPath = new Path(this.getOutputFilePath());
        String fileName = localPath.getName();
        Path hdfsFileLocation = new Path(this.getOutputFilePath() + "/" + fileName);
        if (!this.hdfs.exists(hdfsFileLocation)) {
            this.hdfs.copyFromLocalFile(localPath, hdfsPath);
            this.setUploadSuccess("File " + fileName + " copied to HDFS on location: " + hdfsPath);
        } else {
            this.setUploadSuccess("File " + fileName + " already exists on HDFS on location: " + hdfsPath);
        }
        this.hdfs.close();
    }

    public SampleResult sample(Entry e) {
        SampleResult result = new SampleResult();
        String requestData = "Namenode: " + this.getNameNode() + "\n";
        requestData = requestData + "Input file path: " + this.getInputFilePath() + "\n";
        requestData = requestData + "Output file path: " + this.getOutputFilePath();
        result.setSampleLabel(this.getName());
        result.setSamplerData(requestData);
        result.setDataType("text");
        result.sampleStart();
        if (!(this.getNameNode().equalsIgnoreCase("") || this.getInputFilePath().equalsIgnoreCase("") || this.getOutputFilePath().equalsIgnoreCase(""))) {
            try {
                this.initializeConnection();
                this.copyFileToHDFS();
                result.setResponseData(this.getUploadSuccess().getBytes());
                result.setSuccessful(true);
            }
            catch (IOException e1) {
                result.setResponseData(e1.getMessage().getBytes());
                e1.printStackTrace();
                result.setSuccessful(false);
            }
            catch (Exception e2) {
                result.setResponseData(e2.getMessage().getBytes());
                result.setSuccessful(false);
            }
        } else {
            result.setSuccessful(false);
            result.setResponseData("Some input fields are not populated".getBytes());
        }
        result.sampleEnd();
        return result;
    }
}

