/*
 * Decompiled with CFR 0.152.
 */
package com.atlantbh.jmeter.plugins.hadooputilities.jobstatistics;

import com.atlantbh.jmeter.plugins.hadooputilities.jobstatistics.JobLayer;
import com.atlantbh.jmeter.plugins.hadooputilities.jobstatistics.TaskLayer;
import java.io.IOException;
import java.util.Map;
import org.apache.jmeter.samplers.AbstractSampler;
import org.apache.jmeter.samplers.Entry;
import org.apache.jmeter.samplers.SampleResult;

public class JobStatistics
extends AbstractSampler {
    private static final long serialVersionUID = 1L;
    private static final String JOBTRACKER = "JOBTRACKER";
    private static final String JOBID = "JOBID";
    private static final String JOBIDANDGROUP = "JOBIDANDGROUP";
    private static final String JOBCOUNTERSBYIDBOOL = "JOBCOUNTERSBYIDBOOL";
    private static final String JOBCOUNTERSBYIDANDGROUPBOOL = "JOBCOUNTERSBYIDANDGROUPBOOL";
    private static final String JOBSTATISTICSBYID = "JOBSTATISTICSBYID";
    private static final String TASKCOUNTERSBYIDBOOL = "TASKCOUNTERSBYIDBOOL";
    private static final String TASKSTATISTICSBYIDBOOL = "TASKSTATISTICSBYIDBOOL";

    public void setJobTracker(String jobTracker) {
        this.setProperty(JOBTRACKER, jobTracker);
    }

    public String getJobTracker() {
        return this.getPropertyAsString(JOBTRACKER);
    }

    public void setJobId(String jobId) {
        this.setProperty(JOBID, jobId);
    }

    public String getJobId() {
        return this.getPropertyAsString(JOBID);
    }

    public void setJobIdAndGroup(String jobIdAndGroup) {
        this.setProperty(JOBIDANDGROUP, jobIdAndGroup);
    }

    public String getJobIdAndGroup() {
        return this.getPropertyAsString(JOBIDANDGROUP);
    }

    public void setJobCountersByIdBool(boolean jobCountersById) {
        this.setProperty(JOBCOUNTERSBYIDBOOL, jobCountersById);
    }

    public boolean isJobCountersByIdBool() {
        return this.getPropertyAsBoolean(JOBCOUNTERSBYIDBOOL);
    }

    public void setJobCountersByIdAndGroupBool(boolean jobCountersByIdAndGroup) {
        this.setProperty(JOBCOUNTERSBYIDANDGROUPBOOL, jobCountersByIdAndGroup);
    }

    public boolean isJobCountersByIdAndGroupBool() {
        return this.getPropertyAsBoolean(JOBCOUNTERSBYIDANDGROUPBOOL);
    }

    public void setJobStatisticsByIdBool(boolean jobStatistics) {
        this.setProperty(JOBSTATISTICSBYID, jobStatistics);
    }

    public boolean isJobStatisticsByIdBool() {
        return this.getPropertyAsBoolean(JOBSTATISTICSBYID);
    }

    public void setTaskCountersByIdBool(boolean taskCountersById) {
        this.setProperty(TASKCOUNTERSBYIDBOOL, taskCountersById);
    }

    public boolean isTaskCountersByIdBool() {
        return this.getPropertyAsBoolean(TASKCOUNTERSBYIDBOOL);
    }

    public void setTaskStatisticsByIdBool(boolean taskStatisticsById) {
        this.setProperty(TASKSTATISTICSBYIDBOOL, taskStatisticsById);
    }

    public boolean isTaskStatisticsByIdBool() {
        return this.getPropertyAsBoolean(TASKSTATISTICSBYIDBOOL);
    }

    public SampleResult sample(Entry arg0) {
        String response;
        Map<String, String> counters;
        JobLayer jobLayer = new JobLayer();
        TaskLayer taskLayer = new TaskLayer();
        SampleResult result = new SampleResult();
        String requestData = "mapred.job.tracker: " + this.getJobTracker() + "\n";
        requestData = requestData + "Job id: " + this.getJobId();
        result.setSampleLabel(this.getName());
        result.setSamplerData(requestData);
        result.setDataType("text");
        result.sampleStart();
        if (this.isJobCountersByIdBool()) {
            try {
                counters = jobLayer.getJobCountersByJobId(this.getJobTracker(), this.getJobId());
                response = jobLayer.getCountersAsXml(counters);
                result.setResponseData(response.getBytes());
                result.setSuccessful(true);
            }
            catch (IOException e1) {
                result.setResponseData(e1.getMessage().getBytes());
                result.setSuccessful(false);
            }
            catch (Exception e2) {
                result.setResponseData(e2.getMessage().getBytes());
                result.setSuccessful(false);
            }
        }
        if (this.isJobCountersByIdAndGroupBool()) {
            try {
                counters = jobLayer.getJobCountersByJobIdAndGroupName(this.getJobTracker(), this.getJobId(), this.getJobIdAndGroup());
                response = jobLayer.getCountersAsXml(counters);
                result.setResponseData(response.getBytes());
                result.setSuccessful(true);
            }
            catch (IOException e1) {
                result.setResponseData(e1.getMessage().getBytes());
                result.setSuccessful(false);
            }
            catch (Exception e2) {
                result.setResponseData(e2.getMessage().getBytes());
                result.setSuccessful(false);
            }
        }
        if (this.isJobStatisticsByIdBool()) {
            try {
                response = jobLayer.getJobStatisticsByJobId(this.getJobTracker(), this.getJobId());
                result.setResponseData(response.getBytes());
                result.setSuccessful(true);
            }
            catch (IOException e1) {
                result.setResponseData(e1.getMessage().getBytes());
                result.setSuccessful(false);
            }
            catch (Exception e2) {
                result.setResponseData(e2.getMessage().getBytes());
                result.setSuccessful(false);
            }
        }
        if (this.isTaskCountersByIdBool()) {
            try {
                response = taskLayer.getTaskLevelCountersByJobId(this.getJobTracker(), this.getJobId());
                result.setResponseData(response.getBytes());
                result.setSuccessful(true);
            }
            catch (IOException e1) {
                result.setResponseData(e1.getMessage().getBytes());
                result.setSuccessful(false);
            }
            catch (Exception e2) {
                result.setResponseData(e2.getMessage().getBytes());
                result.setSuccessful(false);
            }
        }
        if (this.isTaskStatisticsByIdBool()) {
            try {
                response = taskLayer.getTaskStatisticsByJobId(this.getJobTracker(), this.getJobId());
                result.setResponseData(response.getBytes());
                result.setSuccessful(true);
            }
            catch (IOException e1) {
                result.setResponseData(e1.getMessage().getBytes());
                result.setSuccessful(false);
            }
            catch (Exception e2) {
                result.setResponseData(e2.getMessage().getBytes());
                result.setSuccessful(false);
            }
        }
        result.sampleEnd();
        return result;
    }
}

