/*
 * Decompiled with CFR 0.152.
 */
package com.atlantbh.jmeter.plugins.hadooputilities.jobstatistics;

import com.atlantbh.jmeter.plugins.hadooputilities.jobstatistics.JobLayer;
import java.io.IOException;
import org.apache.hadoop.mapred.Counters;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobID;
import org.apache.hadoop.mapred.RunningJob;
import org.apache.hadoop.mapred.TaskReport;

public class TaskLayer
extends JobLayer {
    public String getTaskLevelCountersByJobId(String jobTracker, String jobId) throws IOException {
        Counters counter;
        StringBuilder taskCounters = new StringBuilder();
        JobID id = this.convertToJobId(jobId);
        JobClient client = this.prepareJobClient(jobTracker);
        RunningJob job = client.getJob(id);
        TaskReport[] mapTaskReports = client.getMapTaskReports(id);
        TaskReport[] reduceTaskReports = client.getReduceTaskReports(id);
        taskCounters.append("<job id='").append(jobId).append("' name='").append(job.getJobName()).append("'>\n");
        taskCounters.append(" <mapTasks>\n");
        for (TaskReport mapTaskReport : mapTaskReports) {
            taskCounters.append("  <task id='").append(mapTaskReport.getTaskID().toString()).append("'\n");
            taskCounters.append("   <counters>\n");
            counter = mapTaskReport.getCounters();
            for (Counters.Group group : counter) {
                for (Counters.Counter c : group) {
                    taskCounters.append("    <counter name='").append(c.getDisplayName()).append("' value='").append(c.getValue()).append("'>\n");
                }
            }
            taskCounters.append("   </counters>\n");
            taskCounters.append("  </task>\n");
        }
        taskCounters.append(" </mapTasks>\n");
        taskCounters.append(" <reduceTasks>\n");
        for (TaskReport reduceTaskReport : reduceTaskReports) {
            taskCounters.append("  <task id='").append(reduceTaskReport.getTaskID().toString()).append("'\n");
            taskCounters.append("   <counters>\n");
            counter = reduceTaskReport.getCounters();
            for (Counters.Group group : counter) {
                for (Counters.Counter c : group) {
                    taskCounters.append("    <counter name='").append(c.getDisplayName()).append("' value='").append(c.getValue()).append("'>\n");
                }
            }
            taskCounters.append("   </counters>\n");
            taskCounters.append("  </task>\n");
        }
        taskCounters.append(" </reduceTasks>\n");
        taskCounters.append("</job>");
        return taskCounters.toString();
    }

    public String getTaskStatisticsByJobId(String jobTracker, String jobId) throws IOException {
        String taskProgress;
        double progress;
        String duration;
        long taskDuration;
        StringBuilder taskStatistics = new StringBuilder();
        JobID id = this.convertToJobId(jobId);
        JobClient client = this.prepareJobClient(jobTracker);
        RunningJob job = client.getJob(id);
        TaskReport[] mapTaskReports = client.getMapTaskReports(id);
        TaskReport[] reduceTaskReports = client.getReduceTaskReports(id);
        taskStatistics.append("<job id='").append(jobId).append("' name='").append(job.getJobName()).append("'>\n");
        taskStatistics.append(" <mapTasks>\n");
        for (TaskReport mapTaskReport : mapTaskReports) {
            taskDuration = mapTaskReport.getFinishTime() - mapTaskReport.getStartTime();
            duration = taskDuration < 0L ? "N/A" : String.valueOf(taskDuration);
            progress = mapTaskReport.getProgress() * 100.0f;
            taskProgress = Double.toString(progress) + "%";
            taskStatistics.append("  <task id='").append(mapTaskReport.getTaskID().toString()).append("'\n");
            taskStatistics.append("   <progress>").append(taskProgress).append("</progress>\n");
            taskStatistics.append("   <duration>").append(duration).append("</duration>\n");
            taskStatistics.append("   <status>").append(mapTaskReport.getCurrentStatus().toString()).append("</status>\n");
            taskStatistics.append("  </task>\n");
        }
        taskStatistics.append(" </mapTasks>\n");
        taskStatistics.append(" <reduceTasks>\n");
        for (TaskReport reduceTaskReport : reduceTaskReports) {
            taskDuration = reduceTaskReport.getFinishTime() - reduceTaskReport.getStartTime();
            duration = taskDuration < 0L ? "N/A" : String.valueOf(taskDuration);
            progress = reduceTaskReport.getProgress() * 100.0f;
            taskProgress = Double.toString(progress) + "%";
            taskStatistics.append("  <task id='").append(reduceTaskReport.getTaskID().toString()).append("'\n");
            taskStatistics.append("   <progress>").append(taskProgress).append("</progress>\n");
            taskStatistics.append("   <duration>").append(duration).append("</duration>\n");
            taskStatistics.append("   <status>").append(reduceTaskReport.getCurrentStatus().toString()).append("</status>\n");
            taskStatistics.append("  </task>\n");
        }
        taskStatistics.append(" </reduceTasks>\n");
        taskStatistics.append("</job>");
        return taskStatistics.toString();
    }
}

