/*
 * Decompiled with CFR 0.152.
 */
package com.atlantbh.jmeter.plugins.hbasecomponents.config;

import com.atlantbh.jmeter.plugins.hbasecomponents.config.HBaseConnectionVariable;
import com.atlantbh.jmeter.plugins.hbasecomponents.config.JMeterVarParser;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.jmeter.config.ConfigElement;
import org.apache.jmeter.config.ConfigTestElement;
import org.apache.jmeter.testelement.TestStateListener;
import org.apache.jmeter.threads.JMeterVariables;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;

public class HBaseConnection
extends ConfigTestElement
implements ConfigElement,
TestStateListener {
    private static final long serialVersionUID = -2642777372269255604L;
    private static final Logger log = LoggingManager.getLoggerForClass();
    private static final String ZK_HOST = "ZK_HOST";
    private static final String ZK_NAME = "ZK_NAME";
    private static ConcurrentHashMap<String, HBaseConnectionVariable> pool = new ConcurrentHashMap();

    public static HBaseConnectionVariable getConnection(String name) {
        return pool.get(name);
    }

    public String getZkHost() {
        return this.getPropertyAsString(ZK_HOST);
    }

    public void setZkHost(String zkHost) {
        this.setProperty(ZK_HOST, zkHost);
    }

    public String getZkName() {
        return this.getPropertyAsString(ZK_NAME);
    }

    public void setZkName(String zkName) {
        this.setProperty(ZK_NAME, zkName);
    }

    public void testStarted(String s) {
        this.testStarted();
    }

    public void testStarted() {
        JMeterVariables vars = this.getThreadContext().getVariables();
        String name = JMeterVarParser.parse(this.getZkName(), vars);
        if (pool.containsKey(name)) {
            log.error("Test error: Multiple HBase connections called " + name);
            return;
        }
        pool.put(name, new HBaseConnectionVariable(JMeterVarParser.parse(this.getZkHost(), vars), name));
    }

    public void testEnded(String s) {
        this.testEnded();
    }

    public void testEnded() {
        JMeterVariables vars = this.getThreadContext().getVariables();
        String name = JMeterVarParser.parse(this.getZkName(), vars);
        if (!pool.containsKey(name)) {
            log.error("Test warning: HBase connection already cleared: " + name);
            return;
        }
        pool.remove(name);
    }
}

