/*
 * Decompiled with CFR 0.152.
 */
package com.atlantbh.jmeter.plugins.hbasecomponents.config;

import java.io.IOException;
import java.io.Serializable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.client.HTableInterface;
import org.apache.hadoop.hbase.client.HTablePool;

public class HBaseConnectionVariable
implements Serializable {
    private static final long serialVersionUID = -4476571761212844047L;
    private String zkHost = "localhost";
    private String name;
    protected HTablePool tablePool = null;

    public HBaseConnectionVariable() {
    }

    public Configuration getConfig() {
        Configuration conf = HBaseConfiguration.create();
        System.out.println("Connecting to  " + this.zkHost);
        conf.set("hbase.zookeeper.quorum", this.zkHost);
        conf.set("hbase.client.retries.number", "10");
        return conf;
    }

    public HTableInterface getTable(String tableName) throws IOException {
        if (this.tablePool == null) {
            System.out.println("Creating table pool for connection " + this.name + "...");
            this.tablePool = new HTablePool(this.getConfig(), 4096);
        }
        return this.tablePool.getTable(tableName);
    }

    public void putTable(HTableInterface table) throws IOException {
        this.tablePool.putTable(table);
    }

    public HBaseConnectionVariable(String zkHost, String name) {
        this.zkHost = zkHost;
        this.name = name;
    }

    public String getZkHost() {
        return this.zkHost;
    }

    public void setZkHost(String zkHost) {
        this.zkHost = zkHost;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }
}

