/*
 * Decompiled with CFR 0.152.
 */
package com.atlantbh.jmeter.plugins.hbasecomponents.config.gui;

import com.atlantbh.jmeter.plugins.hbasecomponents.config.HBaseConnection;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import kg.apc.jmeter.JMeterPluginsUtils;
import org.apache.jmeter.config.gui.AbstractConfigGui;
import org.apache.jmeter.gui.util.VerticalPanel;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jorphan.gui.JLabeledTextField;

public class HBaseConnectionGui
extends AbstractConfigGui {
    private static final long serialVersionUID = -2817355736341379758L;
    private JLabeledTextField zkHostTF;
    private JLabeledTextField connNameTF;
    private static final String WIKIPAGE = "HBaseConnection";

    public HBaseConnectionGui() {
        this.init();
    }

    private void init() {
        this.setBorder(this.makeBorder());
        this.setLayout(new BorderLayout(0, 10));
        VerticalPanel vertPanel = new VerticalPanel();
        vertPanel.add(JMeterPluginsUtils.addHelpLinkToPanel((Container)this.makeTitlePanel(), (String)WIKIPAGE), "North");
        this.add((Component)vertPanel, "North");
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BoxLayout(mainPanel, 1));
        this.connNameTF = this.createTF("Connection name");
        mainPanel.add((Component)this.connNameTF);
        this.zkHostTF = this.createTF("ZK host");
        mainPanel.add((Component)this.zkHostTF);
        this.add(mainPanel, "Center");
    }

    public String getStaticLabel() {
        return JMeterPluginsUtils.prefixLabel((String)"HBase Connection Config");
    }

    public String getLabelResource() {
        return ((Object)((Object)this)).getClass().getSimpleName();
    }

    public TestElement createTestElement() {
        HBaseConnection conn = new HBaseConnection();
        this.modifyTestElement((TestElement)conn);
        conn.setComment(JMeterPluginsUtils.getWikiLinkText((String)WIKIPAGE));
        return conn;
    }

    public void modifyTestElement(TestElement te) {
        super.configureTestElement(te);
        HBaseConnection con = (HBaseConnection)te;
        con.setZkName(this.connNameTF.getText());
        con.setZkHost(this.zkHostTF.getText());
        con.setName(this.getName());
        con.setComment(this.getComment());
    }

    public void configure(TestElement el) {
        super.configure(el);
        HBaseConnection con = (HBaseConnection)el;
        this.connNameTF.setText(con.getZkName());
        this.zkHostTF.setText(con.getZkHost());
        this.setName(con.getName());
        this.setComment(con.getComment());
    }

    public void clearGui() {
        super.clearGui();
        this.connNameTF.setText("");
        this.zkHostTF.setText("");
    }

    private JLabeledTextField createTF(String name) {
        JLabeledTextField tf = new JLabeledTextField(name);
        tf.setMaximumSize(new Dimension(10000, 26));
        tf.setBorder((Border)new EmptyBorder(3, 0, 3, 0));
        tf.getComponents()[0].setPreferredSize(new Dimension(150, tf.getComponents()[0].getPreferredSize().height));
        return tf;
    }
}

