/*
 * Decompiled with CFR 0.152.
 */
package com.atlantbh.jmeter.plugins.hbasecomponents.samplers;

import com.atlantbh.jmeter.plugins.hbasecomponents.config.HBaseConnection;
import com.atlantbh.jmeter.plugins.hbasecomponents.config.HBaseConnectionVariable;
import com.atlantbh.jmeter.plugins.hbasecomponents.config.JMeterVarParser;
import com.atlantbh.jmeter.plugins.hbasecomponents.utils.Row2XML;
import com.atlantbh.jmeter.plugins.hbasecomponents.utils.filter.FilterParser;
import com.atlantbh.jmeter.plugins.hbasecomponents.utils.filter.HBaseFilterParser;
import com.atlantbh.jmeter.plugins.hbasecomponents.utils.filter.Node;
import java.util.Iterator;
import org.apache.hadoop.hbase.client.HTableInterface;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.filter.CompareFilter;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FilterList;
import org.apache.hadoop.hbase.filter.PageFilter;
import org.apache.hadoop.hbase.filter.SingleColumnValueFilter;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.jmeter.samplers.AbstractSampler;
import org.apache.jmeter.samplers.Entry;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.samplers.Sampler;
import org.apache.jmeter.threads.JMeterVariables;

public class HBaseScanSampler
extends AbstractSampler
implements Sampler {
    private static final long serialVersionUID = -4685749611597443212L;
    private static final String CONN_NAME = "HBS_CONN";
    private static final String HBS_TABLE = "HBS_TABLE";
    private static final String HBS_START = "HBS_START";
    private static final String HBS_END = "HBS_END";
    private static final String HBS_LIMIT = "HBS_LIMIT";
    private static final String HBS_FILTER = "HBS_FILTER";
    private static final String HBS_PASSALL = "HBS_PASSALL";
    private static final String HBS_OMITVARS = "HBS_OMITVARS";
    private static final String HBS_LATEST_TIMESTAMP_ROWS = "HBS_LATEST_TIMESTAMP_ROWS";

    public static void main(String[] args) throws Exception {
        String filter = "OPERATIONAL:JOB_ID=job_201104141652_2429";
        Node node = FilterParser.parse(filter);
        Filter fil = HBaseFilterParser.parse(node);
    }

    public SampleResult sample(Entry arg0) {
        SampleResult result;
        block12: {
            StringBuilder response = new StringBuilder();
            StringBuilder request = new StringBuilder();
            result = new SampleResult();
            JMeterVariables vars = this.getThreadContext().getVariables();
            String connection = JMeterVarParser.parse(this.getConnectionName(), vars);
            String table = JMeterVarParser.parse(this.getTableName(), vars);
            String startKey = JMeterVarParser.parse(this.getStartKey(), vars);
            String endKey = JMeterVarParser.parse(this.getEndKey(), vars);
            String limit = JMeterVarParser.parse(this.getLimit(), vars);
            String filter = JMeterVarParser.parse(this.getFilter(), vars);
            result.setSampleLabel(this.getName());
            result.sampleStart();
            request.append("Executing scan:\n\thost : ").append(connection).append("\n\ttable : ").append(table).append("\n\tstart rowkey : ").append(startKey).append("\n\tend rowkey : ").append(endKey);
            response.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
            response.append("<response>\n");
            try {
                HBaseConnectionVariable hbVar = HBaseConnection.getConnection(connection);
                if (hbVar == null) {
                    this.makeError(result, "There is no connection with name '" + connection + "'", false);
                    break block12;
                }
                HTableInterface hTable = hbVar.getTable(table);
                Scan scan = new Scan();
                FilterList mainFilterList = new FilterList(FilterList.Operator.MUST_PASS_ALL);
                try {
                    if (filter != null && !"".equals(filter.trim())) {
                        request.append("\nfilters:[").append(filter).append("]\n\n");
                        Node node = FilterParser.parse(filter);
                        Filter filters = HBaseFilterParser.parse(node);
                        if (filters != null) {
                            mainFilterList.addFilter(filters);
                        }
                    }
                }
                catch (Exception e) {
                    this.makeError(result, "Invalid filter syntax ".concat(e.getMessage()), true);
                }
                if (limit != null && !"".equals(limit.trim())) {
                    Long l = Long.valueOf(limit);
                    PageFilter pageFilter = new PageFilter(l.longValue());
                    mainFilterList.addFilter((Filter)pageFilter);
                }
                scan.setFilter((Filter)mainFilterList);
                if (startKey != null && !"".equals(startKey.trim())) {
                    scan.setStartRow(Bytes.toBytes((String)startKey));
                }
                if (endKey != null && !"".equals(endKey.trim())) {
                    scan.setStopRow(Bytes.toBytes((String)endKey));
                }
                ResultScanner resultScanner = hTable.getScanner(scan);
                Iterator iter = resultScanner.iterator();
                Integer i = 0;
                while (iter.hasNext()) {
                    Integer n;
                    Integer n2;
                    Result res = (Result)iter.next();
                    if (this.getLatestTimestampRows() == Boolean.TRUE) {
                        response.append(Row2XML.row2xmlStringLatest(res, (JMeterVariables)(this.getOmitVars() != false ? vars : null), i + 1));
                        n2 = i;
                        n = i = Integer.valueOf(i + 1);
                        continue;
                    }
                    response.append(Row2XML.row2xmlstring(res, (JMeterVariables)(this.getOmitVars() != false ? vars : null), i + 1));
                    n2 = i;
                    n = i = Integer.valueOf(i + 1);
                }
                response.append("</response>\n");
                result.setResponseData(response.toString(), "UTF-8");
                result.setDataType("text");
                result.setSuccessful(true);
                result.setSamplerData(request.toString());
                result.sampleEnd();
                hbVar.putTable(hTable);
            }
            catch (Exception e) {
                this.makeError(result, "Failed to access database : host:[" + connection + "] table:[" + table + "]\n" + e.getMessage(), false);
            }
        }
        return result;
    }

    private void makeError(SampleResult result, String msg, Boolean throwError) {
        result.setResponseMessage(msg);
        result.setSuccessful(false);
        if (throwError.booleanValue()) {
            throw new RuntimeException(msg);
        }
    }

    private FilterList parseFilterString(String filters, StringBuilder request, SampleResult result, Boolean passAll) {
        FilterList booleanFilter = new FilterList(passAll != false ? FilterList.Operator.MUST_PASS_ALL : FilterList.Operator.MUST_PASS_ONE);
        if (!this.getFilter().trim().equals("")) {
            String[] subFilters = this.getFilter().trim().split("\\s");
            request.append("\nfilters:[" + (passAll != false ? "MUST_PASS_ALL" : "MUST_PASS_ONE") + "]\n\n");
            for (String subFilter : subFilters) {
                String[] qualiValue = subFilter.split("=");
                if (qualiValue.length != 2) {
                    this.makeError(result, "Invalid filter syntax '" + subFilter + "' Use - family:column=value ", true);
                }
                String[] fq = qualiValue[0].split(":");
                String value = qualiValue[1];
                if (fq.length != 2) {
                    this.makeError(result, "Invalid filter syntax '" + subFilter + "' Use - family:column=value ", true);
                }
                request.append("Filter : " + fq[0] + ":" + fq[1] + "=" + value + "\n");
                SingleColumnValueFilter f = new SingleColumnValueFilter(fq[0].getBytes(), fq[1].getBytes(), CompareFilter.CompareOp.EQUAL, value.getBytes());
                booleanFilter.addFilter((Filter)f);
            }
        }
        return booleanFilter;
    }

    public String getConnectionName() {
        return this.getPropertyAsString(CONN_NAME);
    }

    public void setConnectionName(String value) {
        this.setProperty(CONN_NAME, value);
    }

    public String getTableName() {
        return this.getPropertyAsString(HBS_TABLE);
    }

    public void setTableName(String value) {
        this.setProperty(HBS_TABLE, value);
    }

    public String getStartKey() {
        return this.getPropertyAsString(HBS_START);
    }

    public void setStartKey(String value) {
        this.setProperty(HBS_START, value);
    }

    public String getEndKey() {
        return this.getPropertyAsString(HBS_END);
    }

    public void setEndKey(String value) {
        this.setProperty(HBS_END, value);
    }

    public String getLimit() {
        return this.getPropertyAsString(HBS_LIMIT);
    }

    public void setLimit(String value) {
        this.setProperty(HBS_LIMIT, value);
    }

    public String getFilter() {
        return this.getPropertyAsString(HBS_FILTER);
    }

    public void setFilter(String value) {
        this.setProperty(HBS_FILTER, value);
    }

    public Boolean getPassAll() {
        return this.getPropertyAsBoolean(HBS_PASSALL);
    }

    public void setPassAll(Boolean value) {
        this.setProperty(HBS_PASSALL, value);
    }

    public Boolean getOmitVars() {
        return this.getPropertyAsBoolean(HBS_OMITVARS);
    }

    public void setOmitVars(Boolean value) {
        this.setProperty(HBS_OMITVARS, value);
    }

    public Boolean getLatestTimestampRows() {
        return this.getPropertyAsBoolean(HBS_LATEST_TIMESTAMP_ROWS);
    }

    public void setLatestTimestampRows(Boolean value) {
        this.setProperty(HBS_LATEST_TIMESTAMP_ROWS, value);
    }
}

