/*
 * Decompiled with CFR 0.152.
 */
package com.atlantbh.jmeter.plugins.hbasecomponents.utils.filter;

import com.atlantbh.jmeter.plugins.hbasecomponents.utils.filter.ExpressionNode;
import com.atlantbh.jmeter.plugins.hbasecomponents.utils.filter.Node;
import com.atlantbh.jmeter.plugins.hbasecomponents.utils.filter.OperatorNode;

public class FilterParser {
    public static final String[] COMPARE_OPERATORS = new String[]{"=", "!=", "<", ">", "<=", ">="};
    private static final String OPERATOR_SPLIT_REG_EXP = "(!=|<=|>=|=|<|>)";
    private static final String ENCLOSED_TOKEN = "[\\(][A-Za-z0-9$#~_-]+:[A-Za-z0-9$#~_-]+[!=|<=|>=|=|>|<]+[\\S\\s]+[\\)]";
    private static final String TOKEN = "[A-Za-z0-9$#~_-]+:[A-Za-z0-9$#~_-]+[!=|<=|>=|=|>|<]+[\\S\\s]+";

    public static Node parse(String expression) throws Exception {
        String token = expression.trim();
        if (token.matches(ENCLOSED_TOKEN)) {
            token = token.replace("(", "").replace(")", "");
            ExpressionNode simpleNode = new ExpressionNode();
            FilterParser.parseToken(simpleNode, token);
            return simpleNode;
        }
        OperatorNode node = new OperatorNode();
        int i = 0;
        while (i < token.length()) {
            String char_ = token.substring(i, i + 1);
            String operator = null;
            if (char_.equals("(")) {
                int[] resultInfo = FilterParser.findComplexEndIndex(token.substring(i));
                operator = resultInfo[1] == 0 ? " OR " : (resultInfo[1] == 1 ? " AND " : null);
                String complex = token.substring(i + 1, i + resultInfo[0] - 1);
                Node complexNode = FilterParser.parse(complex);
                node.addChild(complexNode);
                node.addOperator(operator);
                if (operator == null) break;
                i = i + resultInfo[0] + operator.length();
                continue;
            }
            ExpressionNode child = new ExpressionNode();
            int[] operatorInfo = FilterParser.findEndIndex(token.substring(i));
            int operatorIndex = operatorInfo[0];
            String string = operatorInfo[1] == 0 ? " OR " : (operator = operatorInfo[1] == 1 ? " AND " : null);
            if (operatorIndex == -1) {
                FilterParser.parseToken(child, token.substring(i));
                i = token.length();
            } else {
                FilterParser.parseToken(child, token.substring(i, i + operatorIndex));
                i = i + operatorIndex + operator.length();
            }
            node.addOperator(operator);
            node.addChild(child);
        }
        return node;
    }

    private static int[] findComplexEndIndex(String token) {
        int[] returnInfo = new int[2];
        int i = 0;
        int bracks = 0;
        do {
            String char_;
            if ("(".equals(char_ = token.substring(i, i + 1))) {
                ++bracks;
            }
            if (")".equals(char_)) {
                --bracks;
            }
            ++i;
        } while (bracks != 0);
        returnInfo[0] = i;
        returnInfo[1] = -1;
        if (token.substring(i).startsWith(" AND ")) {
            returnInfo[1] = 1;
        }
        if (token.substring(i).startsWith(" OR ")) {
            returnInfo[1] = 0;
        }
        return returnInfo;
    }

    private static int[] findEndIndex(String token) {
        int andOperatorIndex = token.indexOf(" AND ");
        int orOperatorIndex = token.indexOf(" OR ");
        int[] returnInfo = new int[2];
        if (andOperatorIndex == -1 && orOperatorIndex == -1) {
            returnInfo[0] = -1;
            returnInfo[1] = -1;
            return returnInfo;
        }
        if (andOperatorIndex == -1) {
            returnInfo[0] = orOperatorIndex;
            returnInfo[1] = 0;
            return returnInfo;
        }
        if (orOperatorIndex == -1) {
            returnInfo[0] = andOperatorIndex;
            returnInfo[1] = 1;
            return returnInfo;
        }
        if (andOperatorIndex > orOperatorIndex) {
            returnInfo[0] = orOperatorIndex;
            returnInfo[1] = 0;
            return returnInfo;
        }
        returnInfo[0] = andOperatorIndex;
        returnInfo[1] = 1;
        return returnInfo;
    }

    private static void parseToken(ExpressionNode node, String token) throws Exception {
        if (!token.matches(TOKEN)) {
            throw new Exception("Invalid token " + token);
        }
        String[] colval = token.split(OPERATOR_SPLIT_REG_EXP);
        String[] columns = colval[0].split("\\:");
        node.setColumnFamily(columns[0].trim());
        node.setQualifier(columns[1].trim());
        node.setValue("NULL".equals(colval[1].trim()) ? null : colval[1].trim());
        node.setOper(FilterParser.getOperator(token).trim());
    }

    private static String getOperator(String filterToken) {
        for (int i = COMPARE_OPERATORS.length - 1; i >= 0; --i) {
            if (!filterToken.contains(COMPARE_OPERATORS[i])) continue;
            int index = filterToken.indexOf(COMPARE_OPERATORS[i]);
            String operatorString = filterToken.substring(index, index + COMPARE_OPERATORS[i].length());
            return operatorString;
        }
        return null;
    }
}

