/*
 * Decompiled with CFR 0.152.
 */
package com.atlantbh.jmeter.plugins.hbasecrud.gui;

import com.atlantbh.jmeter.plugins.hbasecrud.HbaseCrud;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.border.Border;
import kg.apc.jmeter.JMeterPluginsUtils;
import org.apache.jmeter.gui.util.HorizontalPanel;
import org.apache.jmeter.gui.util.VerticalPanel;
import org.apache.jmeter.samplers.gui.AbstractSamplerGui;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jorphan.gui.JLabeledTextField;

public class HbaseCrudGui
extends AbstractSamplerGui {
    private static final long serialVersionUID = 1L;
    private JLabeledTextField hbaseZookeeperQuorumTextField = null;
    private JLabeledTextField hbaseSourceTableTextField = null;
    private JLabeledTextField rowKeyTextField = null;
    private JLabeledTextField fullColumnNamesListTextField = null;
    private JLabeledTextField columnFamilyColumnNameListTextField = null;
    private JLabeledTextField filterColumnFamiliesForTimestampTextField = null;
    private JCheckBox addOrUpdateDataOnRecordCheckBox = null;
    private JCheckBox deleteDataFromRecordCheckBox = null;
    private JCheckBox latestTimestampOperationCheckBox = null;
    private JCheckBox latestTimestampOperationWithExcludeFilterCheckBox = null;
    private static final String WIKIPAGE = "HBaseCRUDSampler";

    public HbaseCrudGui() {
        this.init();
    }

    public void init() {
        this.setLayout(new BorderLayout());
        this.setBorder(this.makeBorder());
        this.add(JMeterPluginsUtils.addHelpLinkToPanel((Container)this.makeTitlePanel(), (String)WIKIPAGE), "North");
        VerticalPanel panel = new VerticalPanel();
        panel.setBorder(BorderFactory.createEtchedBorder());
        VerticalPanel inputPanel = new VerticalPanel();
        inputPanel.setBorder((Border)BorderFactory.createTitledBorder("Input parameters"));
        this.hbaseZookeeperQuorumTextField = new JLabeledTextField("hbase.zookeeper.quorum");
        this.hbaseSourceTableTextField = new JLabeledTextField("Hbase source table");
        this.rowKeyTextField = new JLabeledTextField("Rowkey");
        inputPanel.add((Component)this.hbaseZookeeperQuorumTextField);
        inputPanel.add((Component)this.hbaseSourceTableTextField);
        inputPanel.add((Component)this.rowKeyTextField);
        VerticalPanel operationsPanel = new VerticalPanel();
        operationsPanel.setBorder((Border)BorderFactory.createTitledBorder("Operations"));
        ButtonGroup operationsGroup = new ButtonGroup();
        this.addOrUpdateDataOnRecordCheckBox = new JCheckBox("Add Or Update Data On Record (full column names list - comma-separated)");
        this.fullColumnNamesListTextField = new JLabeledTextField("", 40);
        HorizontalPanel hPanel1 = new HorizontalPanel();
        hPanel1.add((Component)this.addOrUpdateDataOnRecordCheckBox);
        hPanel1.add((Component)this.fullColumnNamesListTextField);
        this.registerCheckBoxForItemListener(this.addOrUpdateDataOnRecordCheckBox, this.fullColumnNamesListTextField);
        this.deleteDataFromRecordCheckBox = new JCheckBox("Delete Data From Record (column family:column name list or column family list - comma-separated)");
        this.columnFamilyColumnNameListTextField = new JLabeledTextField("", 40);
        HorizontalPanel hPanel2 = new HorizontalPanel();
        hPanel2.add((Component)this.deleteDataFromRecordCheckBox);
        hPanel2.add((Component)this.columnFamilyColumnNameListTextField);
        this.registerCheckBoxForItemListener(this.deleteDataFromRecordCheckBox, this.columnFamilyColumnNameListTextField);
        operationsGroup.add(this.addOrUpdateDataOnRecordCheckBox);
        operationsGroup.add(this.deleteDataFromRecordCheckBox);
        operationsPanel.add((Component)hPanel1);
        operationsPanel.add((Component)hPanel2);
        VerticalPanel modePanel = new VerticalPanel();
        modePanel.setBorder((Border)BorderFactory.createTitledBorder("Operations mode"));
        ButtonGroup modeGroup = new ButtonGroup();
        this.latestTimestampOperationCheckBox = new JCheckBox("Latest Timestamp Operation");
        this.latestTimestampOperationWithExcludeFilterCheckBox = new JCheckBox("Latest Timestamp Operation With Exclude Column Families Filter (comma-separated)");
        this.filterColumnFamiliesForTimestampTextField = new JLabeledTextField("", 25);
        HorizontalPanel hPanel3 = new HorizontalPanel();
        hPanel3.add((Component)this.latestTimestampOperationWithExcludeFilterCheckBox);
        hPanel3.add((Component)this.filterColumnFamiliesForTimestampTextField);
        this.registerCheckBoxForItemListener(this.latestTimestampOperationWithExcludeFilterCheckBox, this.filterColumnFamiliesForTimestampTextField);
        modeGroup.add(this.latestTimestampOperationCheckBox);
        modeGroup.add(this.latestTimestampOperationWithExcludeFilterCheckBox);
        modePanel.add((Component)this.latestTimestampOperationCheckBox);
        modePanel.add((Component)hPanel3);
        panel.add((Component)inputPanel);
        panel.add((Component)operationsPanel);
        panel.add((Component)modePanel);
        this.add((Component)panel, "Center");
    }

    private void registerCheckBoxForItemListener(JCheckBox checkBox, final JLabeledTextField textField) {
        checkBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    textField.setEnabled(true);
                } else if (e.getStateChange() == 2) {
                    textField.setEnabled(false);
                }
            }
        });
    }

    public void clearGui() {
        super.clearGui();
        this.hbaseZookeeperQuorumTextField.setText("");
        this.hbaseSourceTableTextField.setText("");
        this.rowKeyTextField.setText("");
        this.fullColumnNamesListTextField.setText("");
        this.fullColumnNamesListTextField.setEnabled(true);
        this.columnFamilyColumnNameListTextField.setText("");
        this.columnFamilyColumnNameListTextField.setEnabled(false);
        this.filterColumnFamiliesForTimestampTextField.setText("");
        this.filterColumnFamiliesForTimestampTextField.setEnabled(false);
        this.addOrUpdateDataOnRecordCheckBox.setSelected(true);
        this.deleteDataFromRecordCheckBox.setSelected(false);
        this.latestTimestampOperationCheckBox.setSelected(true);
        this.latestTimestampOperationWithExcludeFilterCheckBox.setSelected(false);
    }

    public TestElement createTestElement() {
        HbaseCrud hbaseCrud = new HbaseCrud();
        this.modifyTestElement((TestElement)hbaseCrud);
        hbaseCrud.setComment(JMeterPluginsUtils.getWikiLinkText((String)WIKIPAGE));
        return hbaseCrud;
    }

    public void modifyTestElement(TestElement element) {
        super.configureTestElement(element);
        if (element instanceof HbaseCrud) {
            HbaseCrud hbaseCrud = (HbaseCrud)element;
            hbaseCrud.setHbaseZookeeperQuorum(this.hbaseZookeeperQuorumTextField.getText());
            hbaseCrud.setHbaseSourceTable(this.hbaseSourceTableTextField.getText());
            hbaseCrud.setRowKey(this.rowKeyTextField.getText());
            hbaseCrud.setFullColumnNamesList(this.fullColumnNamesListTextField.getText());
            hbaseCrud.setColumnFamilyColumnNameList(this.columnFamilyColumnNameListTextField.getText());
            hbaseCrud.setFilterColumnFamiliesForTimestamp(this.filterColumnFamiliesForTimestampTextField.getText());
            hbaseCrud.setAddOrUpdateDataOnRecordBool(this.addOrUpdateDataOnRecordCheckBox.isSelected());
            hbaseCrud.setDeleteDataFromRecordBool(this.deleteDataFromRecordCheckBox.isSelected());
            hbaseCrud.setLatestTimestampOperationBool(this.latestTimestampOperationCheckBox.isSelected());
            hbaseCrud.setLatestTimestampOperationWithFilterBool(this.latestTimestampOperationWithExcludeFilterCheckBox.isSelected());
        }
    }

    public void configure(TestElement element) {
        super.configure(element);
        if (element instanceof HbaseCrud) {
            HbaseCrud hbaseCrud = (HbaseCrud)element;
            this.hbaseZookeeperQuorumTextField.setText(hbaseCrud.getHbaseZookeeperQuorum());
            this.hbaseSourceTableTextField.setText(hbaseCrud.getHbaseSourceTable());
            this.rowKeyTextField.setText(hbaseCrud.getRowKey());
            this.fullColumnNamesListTextField.setText(hbaseCrud.getFullColumnNamesList());
            this.columnFamilyColumnNameListTextField.setText(hbaseCrud.getColumnFamilyColumnNameList());
            this.filterColumnFamiliesForTimestampTextField.setText(hbaseCrud.getFilterColumnFamiliesForTimestamp());
            this.addOrUpdateDataOnRecordCheckBox.setSelected(hbaseCrud.isAddOrUpdateDataOnRecordBool());
            this.deleteDataFromRecordCheckBox.setSelected(hbaseCrud.isDeleteDataFromRecordBool());
            this.latestTimestampOperationCheckBox.setSelected(hbaseCrud.isLatestTimestampOperationBool());
            this.latestTimestampOperationWithExcludeFilterCheckBox.setSelected(hbaseCrud.isLatestTimestampOperationWithFilterBool());
        }
    }

    public String getLabelResource() {
        return ((Object)((Object)this)).getClass().getSimpleName();
    }

    public String getStaticLabel() {
        return JMeterPluginsUtils.prefixLabel((String)"HBase CRUD Sampler");
    }
}

