/*
 * Decompiled with CFR 0.152.
 */
package kg.apc.jmeter.jmxmon;

import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.net.MalformedURLException;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import javax.management.MBeanServerConnection;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;

public class JMXMonConnectionPool {
    private static final Logger log = LoggingManager.getLoggerForClass();
    private Map<String, JMXMonConnection> pool = new HashMap<String, JMXMonConnection>();

    public MBeanServerConnection getConnection(String jmxUrl, Hashtable attributes) {
        return this.getConnection(jmxUrl, attributes, false);
    }

    public MBeanServerConnection getConnection(String jmxUrl, Hashtable attributes, boolean wait) {
        JMXMonConnection connection = this.pool.get(jmxUrl);
        if (connection == null) {
            connection = new JMXMonConnection(jmxUrl);
            this.pool.put(jmxUrl, connection);
        }
        return connection.connect(attributes, wait);
    }

    public void closeAll() {
        for (JMXMonConnection connection : this.pool.values()) {
            JMXMonConnection jmxcon = connection;
            if (jmxcon.connector != null) {
                try {
                    jmxcon.connector.close();
                    log.debug("jmx connector is closed");
                }
                catch (Exception ex) {
                    log.debug("Can't close jmx connector, but continue");
                }
            } else {
                log.debug("jmxConnector == null, don't try to close connection");
            }
            jmxcon.connector = null;
            Object var3_3 = null;
        }
        this.pool.clear();
    }

    public void notifyConnectionDirty(String url) {
        JMXMonConnection connection = this.pool.get(url);
        if (connection != null) {
            connection.setNewActiveConnection(null, null);
        }
    }

    private class JMXMonConnection {
        private String jmxUrl;
        private JMXConnector connector;
        private MBeanServerConnection connection;
        private Thread connectionAttemptThread;
        private boolean connectionAttemptFlag;

        private JMXMonConnection(String jmxUrl) {
            this.jmxUrl = jmxUrl;
        }

        private boolean isLocalConnection() {
            return this.jmxUrl.isEmpty();
        }

        protected synchronized void tryConnect(final Hashtable attributes, boolean wait) {
            if (this.isLocalConnection()) {
                log.debug("Using local PlatformMBeanServer connection");
                this.connection = ManagementFactory.getPlatformMBeanServer();
                return;
            }
            this.connectionAttemptFlag = true;
            this.connectionAttemptThread = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        JMXServiceURL u = new JMXServiceURL(JMXMonConnection.this.jmxUrl);
                        log.debug("Create new connection url = " + JMXMonConnection.this.jmxUrl);
                        JMXMonConnection.this.connector = JMXConnectorFactory.connect(u, attributes);
                        JMXMonConnection.this.connection = JMXMonConnection.this.connector.getMBeanServerConnection();
                    }
                    catch (MalformedURLException ex) {
                        log.error("Malformed JMX url", (Throwable)ex);
                    }
                    catch (IOException ex) {
                        log.error("IOException reading JMX", (Throwable)ex);
                    }
                    finally {
                        JMXMonConnection.this.connectionAttemptFlag = false;
                    }
                }
            });
            this.connectionAttemptThread.start();
            if (wait) {
                try {
                    this.connectionAttemptThread.join();
                }
                catch (InterruptedException e) {
                    log.warn("Connection thread has been interrupted", (Throwable)e);
                }
            }
        }

        protected MBeanServerConnection connect(Hashtable attributes, boolean wait) {
            if (this.connection != null) {
                log.debug("Reused the same connection for url = " + (this.isLocalConnection() ? "(local JVM)" : this.jmxUrl));
                return this.connection;
            }
            if (!this.connectionAttemptFlag) {
                this.tryConnect(attributes, wait);
            }
            return this.connection;
        }

        protected void setNewActiveConnection(JMXConnector connector, MBeanServerConnection connection) {
            this.connector = connector;
            this.connection = connection;
        }
    }
}

