/*
 * Decompiled with CFR 0.152.
 */
package com.atlantbh.jmeter.plugins.jsonutils.jsonpathassertion;

import com.atlantbh.jmeter.plugins.jsonutils.YAMLToJSONConverter;
import com.atlantbh.jmeter.plugins.jsonutils.jsonpathextractor.JSONPathExtractor;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import java.io.Serializable;
import net.minidev.json.JSONArray;
import org.apache.jmeter.assertions.Assertion;
import org.apache.jmeter.assertions.AssertionResult;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.testelement.AbstractTestElement;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;
import org.apache.oro.text.regex.Pattern;

public class JSONPathAssertion
extends AbstractTestElement
implements Serializable,
Assertion {
    private static final Logger log = LoggingManager.getLoggerForClass();
    private static final long serialVersionUID = 1L;
    public static final String INPUT_JSON = "JSON";
    public static final String INPUT_YAML = "YAML";
    public static final String INPUT_FORMAT = "INPUT_FORMAT";
    public static final String JSONPATH = "JSON_PATH";
    public static final String EXPECTEDVALUE = "EXPECTED_VALUE";
    public static final String JSONVALIDATION = "JSONVALIDATION";
    public static final String EXPECT_NULL = "EXPECT_NULL";
    public static final String INVERT = "INVERT";
    public static final String ISREGEX = "ISREGEX";

    public void setInputFormat(String inputFormat) {
        this.setProperty(INPUT_FORMAT, inputFormat);
    }

    public String getInputFormat() {
        return this.getPropertyAsString(INPUT_FORMAT);
    }

    public String getJsonPath() {
        return this.getPropertyAsString(JSONPATH);
    }

    public void setJsonPath(String jsonPath) {
        this.setProperty(JSONPATH, jsonPath);
    }

    public String getExpectedValue() {
        return this.getPropertyAsString(EXPECTEDVALUE);
    }

    public void setExpectedValue(String expectedValue) {
        this.setProperty(EXPECTEDVALUE, expectedValue);
    }

    public void setJsonValidationBool(boolean jsonValidation) {
        this.setProperty(JSONVALIDATION, jsonValidation);
    }

    public void setExpectNull(boolean val) {
        this.setProperty(EXPECT_NULL, val);
    }

    public boolean isExpectNull() {
        return this.getPropertyAsBoolean(EXPECT_NULL);
    }

    public boolean isJsonValidationBool() {
        return this.getPropertyAsBoolean(JSONVALIDATION);
    }

    public void setInvert(boolean invert) {
        this.setProperty(INVERT, invert);
    }

    public boolean isInvert() {
        return this.getPropertyAsBoolean(INVERT);
    }

    public void setIsRegex(boolean flag) {
        this.setProperty(ISREGEX, flag);
    }

    public boolean isUseRegex() {
        return this.getPropertyAsBoolean(ISREGEX, true);
    }

    private void doAssert(String jsonString) {
        if (INPUT_YAML.equals(this.getInputFormat())) {
            jsonString = YAMLToJSONConverter.convert(jsonString);
        }
        Object value = JsonPath.read((String)jsonString, (String)this.getJsonPath(), (Predicate[])new Predicate[0]);
        if (this.isJsonValidationBool()) {
            if (value instanceof JSONArray) {
                if (this.arrayMatched((JSONArray)value)) {
                    return;
                }
            } else {
                if (this.isExpectNull() && value == null) {
                    return;
                }
                if (this.isEquals(value)) {
                    return;
                }
            }
            if (this.isExpectNull()) {
                throw new RuntimeException(String.format("Value expected to be null, but found '%s'", value));
            }
            String msg = this.isUseRegex() ? "Value expected to match regexp '%s', but it did not match: '%s'" : "Value expected to be '%s', but found '%s'";
            throw new RuntimeException(String.format(msg, this.getExpectedValue(), JSONPathExtractor.objectToString(value)));
        }
    }

    private boolean arrayMatched(JSONArray value) {
        if (value.isEmpty() && this.getExpectedValue().equals("[]")) {
            return true;
        }
        for (Object subj : value.toArray()) {
            if (this.isExpectNull() && subj == null) {
                return true;
            }
            if (!this.isEquals(subj)) continue;
            return true;
        }
        return this.isEquals(value);
    }

    private boolean isEquals(Object subj) {
        String str = JSONPathExtractor.objectToString(subj);
        if (this.isUseRegex()) {
            Pattern pattern = JMeterUtils.getPatternCache().getPattern(this.getExpectedValue());
            return JMeterUtils.getMatcher().matches(str, pattern);
        }
        return str.equals(this.getExpectedValue());
    }

    public AssertionResult getResult(SampleResult samplerResult) {
        AssertionResult result;
        block12: {
            result = new AssertionResult(this.getName());
            String responseData = samplerResult.getResponseDataAsString();
            if (responseData.isEmpty()) {
                return result.setResultForNull();
            }
            result.setFailure(false);
            result.setFailureMessage("");
            if (!this.isInvert()) {
                try {
                    this.doAssert(responseData);
                }
                catch (Exception e) {
                    if (log.isDebugEnabled()) {
                        log.debug("Assertion failed", (Throwable)e);
                    }
                    result.setFailure(true);
                    result.setFailureMessage(e.getMessage());
                }
            } else {
                try {
                    this.doAssert(responseData);
                    result.setFailure(true);
                    if (this.isJsonValidationBool()) {
                        if (this.isExpectNull()) {
                            result.setFailureMessage("Failed that JSONPath " + this.getJsonPath() + " not matches null");
                        } else {
                            result.setFailureMessage("Failed that JSONPath " + this.getJsonPath() + " not matches " + this.getExpectedValue());
                        }
                    } else {
                        result.setFailureMessage("Failed that JSONPath not exists: " + this.getJsonPath());
                    }
                }
                catch (Exception e) {
                    if (!log.isDebugEnabled()) break block12;
                    log.debug("Assertion failed", (Throwable)e);
                }
            }
        }
        return result;
    }
}

