/*
 * Decompiled with CFR 0.152.
 */
package com.atlantbh.jmeter.plugins.jsonutils.jsonpathassertion.gui;

import com.atlantbh.jmeter.plugins.jsonutils.jsonpathassertion.JSONPathAssertion;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.util.Enumeration;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import kg.apc.jmeter.JMeterPluginsUtils;
import org.apache.jmeter.assertions.gui.AbstractAssertionGui;
import org.apache.jmeter.gui.util.HorizontalPanel;
import org.apache.jmeter.gui.util.VerticalPanel;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jorphan.gui.JLabeledTextArea;
import org.apache.jorphan.gui.JLabeledTextField;

public class JSONPathAssertionGui
extends AbstractAssertionGui
implements ChangeListener {
    private static final long serialVersionUID = 1L;
    private JLabeledTextField jsonPath = null;
    private JLabeledTextArea jsonValue = null;
    private JCheckBox jsonValidation = null;
    private JCheckBox expectNull = null;
    private JCheckBox invert = null;
    private static final String WIKIPAGE = "JSONPathAssertion";
    private JCheckBox isRegex;
    private ButtonGroup inputFormatGroup = new ButtonGroup();
    private JRadioButton inputJSON = new JRadioButton("JSON");
    private JRadioButton inputYAML = new JRadioButton("YAML");

    public JSONPathAssertionGui() {
        this.init();
    }

    public void init() {
        this.setLayout(new BorderLayout());
        this.setBorder(this.makeBorder());
        this.add(JMeterPluginsUtils.addHelpLinkToPanel((Container)this.makeTitlePanel(), (String)WIKIPAGE), "North");
        VerticalPanel panel = new VerticalPanel();
        panel.setBorder(BorderFactory.createEmptyBorder(5, 0, 5, 0));
        HorizontalPanel groupPanel = new HorizontalPanel();
        this.inputJSON.setActionCommand("JSON");
        this.inputYAML.setActionCommand("YAML");
        this.inputFormatGroup.add(this.inputJSON);
        this.inputFormatGroup.add(this.inputYAML);
        groupPanel.add(this.inputJSON);
        groupPanel.add(this.inputYAML);
        HorizontalPanel inputFormatPanel = new HorizontalPanel();
        inputFormatPanel.add(new JLabel("Input Format: "));
        inputFormatPanel.add((Component)groupPanel);
        this.jsonPath = new JLabeledTextField("Assert JSON Path exists: ");
        this.jsonValidation = new JCheckBox("Additionally assert value");
        this.isRegex = new JCheckBox("Match as regular expression");
        this.jsonValue = new JLabeledTextArea("Expected Value: ");
        this.expectNull = new JCheckBox("Expect null");
        this.invert = new JCheckBox("Invert assertion (will fail if above conditions met)");
        this.jsonValidation.addChangeListener(this);
        this.expectNull.addChangeListener(this);
        panel.add((Component)inputFormatPanel);
        panel.add((Component)this.jsonPath);
        panel.add((Component)this.jsonValidation);
        panel.add((Component)this.isRegex);
        panel.add((Component)this.jsonValue);
        panel.add((Component)this.expectNull);
        panel.add((Component)this.invert);
        this.add((Component)panel, "Center");
    }

    public void clearGui() {
        super.clearGui();
        this.jsonPath.setText("$.");
        this.jsonValue.setText("");
        this.jsonValidation.setSelected(false);
        this.expectNull.setSelected(false);
        this.invert.setSelected(false);
        this.isRegex.setSelected(true);
        this.inputJSON.setSelected(true);
    }

    public TestElement createTestElement() {
        JSONPathAssertion jpAssertion = new JSONPathAssertion();
        this.modifyTestElement((TestElement)jpAssertion);
        jpAssertion.setComment(JMeterPluginsUtils.getWikiLinkText((String)WIKIPAGE));
        return jpAssertion;
    }

    public String getLabelResource() {
        return this.getClass().getSimpleName();
    }

    public String getStaticLabel() {
        return JMeterPluginsUtils.prefixLabel((String)"JSON/YAML Path Assertion");
    }

    public void modifyTestElement(TestElement element) {
        super.configureTestElement(element);
        if (element instanceof JSONPathAssertion) {
            JSONPathAssertion jpAssertion = (JSONPathAssertion)element;
            jpAssertion.setJsonPath(this.jsonPath.getText());
            jpAssertion.setExpectedValue(this.jsonValue.getText());
            jpAssertion.setJsonValidationBool(this.jsonValidation.isSelected());
            jpAssertion.setExpectNull(this.expectNull.isSelected());
            jpAssertion.setInvert(this.invert.isSelected());
            jpAssertion.setIsRegex(this.isRegex.isSelected());
            if (this.inputFormatGroup.getSelection() != null) {
                jpAssertion.setInputFormat(this.inputFormatGroup.getSelection().getActionCommand());
            }
        }
    }

    public void configure(TestElement element) {
        super.configure(element);
        JSONPathAssertion jpAssertion = (JSONPathAssertion)element;
        this.jsonPath.setText(jpAssertion.getJsonPath());
        this.jsonValue.setText(jpAssertion.getExpectedValue());
        this.jsonValidation.setSelected(jpAssertion.isJsonValidationBool());
        this.expectNull.setSelected(jpAssertion.isExpectNull());
        this.invert.setSelected(jpAssertion.isInvert());
        this.isRegex.setSelected(jpAssertion.isUseRegex());
        Enumeration<AbstractButton> it = this.inputFormatGroup.getElements();
        while (it.hasMoreElements()) {
            AbstractButton btn = it.nextElement();
            if (!btn.getActionCommand().equals(jpAssertion.getInputFormat())) continue;
            btn.setSelected(true);
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.jsonValue.setEnabled(this.jsonValidation.isSelected() && !this.expectNull.isSelected());
        this.isRegex.setEnabled(this.jsonValidation.isSelected() && !this.expectNull.isSelected());
    }
}

