/*
 * Decompiled with CFR 0.152.
 */
package com.atlantbh.jmeter.plugins.jsonutils.jsonpathextractor.gui;

import com.atlantbh.jmeter.plugins.jsonutils.jsonpathextractor.JSONPathExtractor;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.Enumeration;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import kg.apc.jmeter.JMeterPluginsUtils;
import org.apache.jmeter.gui.util.HorizontalPanel;
import org.apache.jmeter.processor.gui.AbstractPostProcessorGui;
import org.apache.jmeter.testelement.TestElement;

public class JSONPathExtractorGui
extends AbstractPostProcessorGui {
    private static final long serialVersionUID = 1L;
    private JTextField variableNameTextField = null;
    private JTextField jsonPathTextField = null;
    private JTextField defaultValTextField = null;
    private static final String WIKIPAGE = "JSONPathExtractor";
    private JRadioButton useBody;
    private JRadioButton useVariable;
    private ButtonGroup group;
    private JTextField srcVariableName;
    private ButtonGroup inputFormatGroup = new ButtonGroup();
    private JRadioButton inputJSON = new JRadioButton("JSON");
    private JRadioButton inputYAML = new JRadioButton("YAML");

    public JSONPathExtractorGui() {
        this.init();
    }

    private void init() {
        this.setLayout(new BorderLayout());
        this.setBorder(this.makeBorder());
        this.add(JMeterPluginsUtils.addHelpLinkToPanel((Container)this.makeTitlePanel(), (String)WIKIPAGE), "North");
        JPanel mainPanel = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridwidth = 2;
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        c.anchor = 23;
        c.fill = 2;
        mainPanel.add((Component)this.makeSourcePanel(), c);
        GridBagConstraints labelConstraints = new GridBagConstraints();
        labelConstraints.anchor = 24;
        GridBagConstraints editConstraints = new GridBagConstraints();
        editConstraints.anchor = 23;
        editConstraints.weightx = 1.0;
        editConstraints.fill = 2;
        HorizontalPanel groupPanel = new HorizontalPanel();
        this.inputJSON.setActionCommand("JSON");
        this.inputYAML.setActionCommand("YAML");
        this.inputFormatGroup.add(this.inputJSON);
        this.inputFormatGroup.add(this.inputYAML);
        groupPanel.add(this.inputJSON);
        groupPanel.add(this.inputYAML);
        int row = 1;
        this.addToPanel(mainPanel, labelConstraints, 0, row, new JLabel("Input Format: ", 4));
        this.addToPanel(mainPanel, editConstraints, 1, row, (JComponent)groupPanel);
        this.addToPanel(mainPanel, labelConstraints, 0, ++row, new JLabel("Destination Variable Name: ", 4));
        this.variableNameTextField = new JTextField(20);
        this.addToPanel(mainPanel, editConstraints, 1, row, this.variableNameTextField);
        this.addToPanel(mainPanel, labelConstraints, 0, ++row, new JLabel("JSONPath Expression: ", 4));
        this.jsonPathTextField = new JTextField(20);
        this.addToPanel(mainPanel, editConstraints, 1, row, this.jsonPathTextField);
        this.addToPanel(mainPanel, labelConstraints, 0, ++row, new JLabel("Default Value: ", 4));
        this.defaultValTextField = new JTextField(20);
        this.addToPanel(mainPanel, editConstraints, 1, row, this.defaultValTextField);
        JPanel container = new JPanel(new BorderLayout());
        container.add((Component)mainPanel, "North");
        this.add(container, "Center");
    }

    private JPanel makeSourcePanel() {
        JPanel panel = new JPanel();
        panel.setBorder(BorderFactory.createTitledBorder("Apply to:"));
        this.useBody = new JRadioButton("Response Text");
        this.useVariable = new JRadioButton("JMeter Variable:");
        this.srcVariableName = new JTextField(20);
        this.group = new ButtonGroup();
        this.group.add(this.useBody);
        this.group.add(this.useVariable);
        panel.add(this.useBody);
        panel.add(this.useVariable);
        panel.add(this.srcVariableName);
        this.useBody.setSelected(true);
        this.useBody.setActionCommand("BODY");
        this.useVariable.setActionCommand("VAR");
        return panel;
    }

    private void addToPanel(JPanel panel, GridBagConstraints constraints, int col, int row, JComponent component) {
        constraints.gridx = col;
        constraints.gridy = row;
        panel.add((Component)component, constraints);
    }

    public void clearGui() {
        super.clearGui();
        this.variableNameTextField.setText("");
        this.jsonPathTextField.setText("");
        this.defaultValTextField.setText("");
        this.srcVariableName.setText("");
        this.useBody.setSelected(true);
        this.inputJSON.setSelected(true);
    }

    public TestElement createTestElement() {
        JSONPathExtractor extractor = new JSONPathExtractor();
        this.modifyTestElement((TestElement)extractor);
        extractor.setComment(JMeterPluginsUtils.getWikiLinkText((String)WIKIPAGE));
        return extractor;
    }

    public String getLabelResource() {
        return ((Object)((Object)this)).getClass().getSimpleName();
    }

    public String getStaticLabel() {
        return JMeterPluginsUtils.prefixLabel((String)"JSON/YAML Path Extractor");
    }

    public void modifyTestElement(TestElement element) {
        super.configureTestElement(element);
        if (element instanceof JSONPathExtractor) {
            JSONPathExtractor extractor = (JSONPathExtractor)element;
            extractor.setVar(this.variableNameTextField.getText());
            extractor.setJsonPath(this.jsonPathTextField.getText());
            extractor.setDefaultValue(this.defaultValTextField.getText());
            extractor.setSrcVariableName(this.srcVariableName.getText());
            extractor.setSubject(this.group.getSelection().getActionCommand());
            if (this.inputFormatGroup.getSelection() != null) {
                extractor.setInputFormat(this.inputFormatGroup.getSelection().getActionCommand());
            }
        }
    }

    public void configure(TestElement element) {
        super.configure(element);
        if (element instanceof JSONPathExtractor) {
            JSONPathExtractor extractor = (JSONPathExtractor)element;
            this.variableNameTextField.setText(extractor.getVar());
            this.jsonPathTextField.setText(extractor.getJsonPath());
            this.defaultValTextField.setText(extractor.getDefaultValue());
            this.srcVariableName.setText(extractor.getSrcVariableName());
            if (extractor.getSubject().equals("VAR")) {
                this.useVariable.setSelected(true);
            } else {
                this.useBody.setSelected(true);
            }
            Enumeration<AbstractButton> it = this.inputFormatGroup.getElements();
            while (it.hasMoreElements()) {
                AbstractButton btn = it.nextElement();
                if (!btn.getActionCommand().equals(extractor.getInputFormat())) continue;
                btn.setSelected(true);
            }
        }
    }
}

