/*
 * Decompiled with CFR 0.152.
 */
package org.jmeterplugins.save;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kg.apc.jmeter.vizualizers.CorrectedResultCollector;
import org.apache.jmeter.samplers.SampleEvent;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.samplers.SampleSaveConfiguration;
import org.apache.jmeter.save.CSVSaveService;
import org.apache.jmeter.save.SaveService;
import org.apache.jmeter.services.FileServer;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;

public class MergeResultsService {
    private static final Logger log = LoggingManager.getLoggerForClass();
    private static final String TESTRESULTS_START_V1_1_PREVER = "<testResults version=\"";
    private static final String TESTRESULTS_START_V1_1_POSTVER = "\">";
    private static final String TESTRESULTS_END = "</testResults>";
    private static final String XML_HEADER = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>";
    public static final String FILENAME = "filename";
    private static final boolean SAVING_AUTOFLUSH = JMeterUtils.getPropDefault((String)"jmeter.save.saveservice.autoflush", (boolean)false);
    private PrintWriter out;
    private static final Map<String, FileEntry> files = new HashMap<String, FileEntry>();

    private void initializeFileOutput(String filename, SampleSaveConfiguration saveConfig) throws IOException {
        if (filename != null && this.out == null) {
            try {
                this.out = MergeResultsService.getFileWriter(filename, saveConfig);
            }
            catch (FileNotFoundException e) {
                this.out = null;
            }
        }
    }

    private static PrintWriter getFileWriter(String filename, SampleSaveConfiguration saveConfig) throws IOException {
        PrintWriter writer;
        if (filename == null || filename.length() == 0) {
            return null;
        }
        FileEntry fe = files.get(filename = FileServer.resolveBaseRelativeName((String)filename));
        if (fe == null) {
            File pdir = new File(filename).getParentFile();
            if (pdir != null) {
                if (pdir.mkdirs()) {
                    log.info("Folder " + pdir.getAbsolutePath() + " was created");
                }
                if (!pdir.exists()) {
                    log.warn("Error creating directories for " + pdir.toString());
                }
            }
            writer = new PrintWriter((Writer)new OutputStreamWriter((OutputStream)new BufferedOutputStream(new FileOutputStream(filename)), SaveService.getFileEncoding((String)"UTF-8")), SAVING_AUTOFLUSH);
            log.debug("Opened file: " + filename);
            files.put(filename, new FileEntry(writer, saveConfig));
        } else {
            writer = fe.pw;
        }
        MergeResultsService.writeFileStart(writer, saveConfig);
        return writer;
    }

    private static void writeFileStart(PrintWriter writer, SampleSaveConfiguration saveConfig) {
        if (saveConfig.saveAsXml()) {
            writer.print(XML_HEADER);
            writer.print("\n");
            String pi = saveConfig.getXmlPi();
            if (pi.length() > 0) {
                writer.println(pi);
            }
            writer.print(TESTRESULTS_START_V1_1_PREVER);
            writer.print(SaveService.getVERSION());
            writer.print(TESTRESULTS_START_V1_1_POSTVER);
            writer.print("\n");
        } else if (saveConfig.saveFieldNames()) {
            writer.println(CSVSaveService.printableFieldNamesToString((SampleSaveConfiguration)saveConfig));
        }
    }

    private void finalizeFileOutput() {
        for (Map.Entry<String, FileEntry> me : files.entrySet()) {
            log.debug("Closing: " + me.getKey());
            FileEntry fe = me.getValue();
            MergeResultsService.writeFileEnd(fe.pw, fe.config);
            fe.pw.close();
            if (!fe.pw.checkError()) continue;
            log.warn("Problem detected during use of " + me.getKey());
        }
        files.clear();
    }

    private static void writeFileEnd(PrintWriter pw, SampleSaveConfiguration saveConfig) {
        if (saveConfig.saveAsXml()) {
            pw.print("\n");
            pw.print(TESTRESULTS_END);
            pw.print("\n");
        }
    }

    public void mergeSamples(CorrectedResultCollector crc, List<SampleResult> samples) {
        try {
            this.initializeFileOutput(crc.getFilename(), crc.getSaveConfig());
        }
        catch (IOException e) {
            log.warn("Error trying to initialize output file " + e.toString());
        }
        for (SampleResult result : samples) {
            SampleSaveConfiguration config = crc.getSaveConfig();
            SampleEvent event = new SampleEvent(result, null);
            try {
                if (config.saveAsXml()) {
                    SaveService.saveSampleResult((SampleEvent)event, (Writer)this.out);
                    continue;
                }
                String savee = CSVSaveService.resultToDelimitedString((SampleEvent)event);
                this.out.println(savee);
            }
            catch (Exception err) {
                log.error("Error trying to record a sample", (Throwable)err);
            }
        }
        this.finalizeFileOutput();
    }

    private static class FileEntry {
        final PrintWriter pw;
        final SampleSaveConfiguration config;

        FileEntry(PrintWriter _pw, SampleSaveConfiguration _config) {
            this.pw = _pw;
            this.config = _config;
        }
    }
}

