/*
 * Decompiled with CFR 0.152.
 */
package kg.apc.jmeter.vizualizers;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.EmptyBorder;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableModel;
import kg.apc.charting.GraphPanelChart;
import kg.apc.jmeter.JMeterPluginsUtils;
import kg.apc.jmeter.graphs.AbstractGraphPanelVisualizer;
import kg.apc.jmeter.graphs.SettingsInterface;
import kg.apc.jmeter.vizualizers.CorrectedResultCollector;
import kg.apc.jmeter.vizualizers.JSettingsPanel;
import org.apache.jmeter.gui.GuiPackage;
import org.apache.jmeter.gui.SavePropertyDialog;
import org.apache.jmeter.gui.util.FilePanel;
import org.apache.jmeter.gui.util.PowerTableModel;
import org.apache.jmeter.gui.util.VerticalPanel;
import org.apache.jmeter.reporters.ResultCollector;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.testelement.property.CollectionProperty;
import org.apache.jmeter.testelement.property.JMeterProperty;
import org.apache.jmeter.testelement.property.NullProperty;
import org.apache.jmeter.testelement.property.StringProperty;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.gui.ComponentUtil;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;
import org.jmeterplugins.save.MergeResultsService;

public class MergeResultsGui
extends AbstractGraphPanelVisualizer
implements TableModelListener,
CellEditorListener,
ChangeListener,
ActionListener {
    private static final long serialVersionUID = 240L;
    private static final Logger log = LoggingManager.getLoggerForClass();
    public static final String WIKIPAGE = "MergeResults";
    public static final String[] columnIdentifiers = new String[]{"Input File Name", "Prefix label", "Offset start (sec)", "Offset end (sec)", "Include label", "RegExp Inc.", "Exclude label", "RegExp Exc."};
    public static final Class<?>[] columnClasses = new Class[]{String.class, String.class, String.class, String.class, String.class, Boolean.class, String.class, Boolean.class};
    public static final Object[] defaultValues = new Object[]{"", "", "", "", "", false, "", false};
    private static final String[] EXTS = new String[]{".jtl", ".csv"};
    public static final String DEFAULT_FILENAME = "";
    public static final String FILENAME = "MergeResultsControlGui.filename";
    public static final String DATA_PROPERTY = "MergeResultsControlGui.data";
    public static final int INPUT_FILE_NAME = 0;
    public static final int PREFIX_LABEL = 1;
    public static final int OFFSET_START = 2;
    public static final int OFFSET_END = 3;
    public static final int INCLUDE_LABEL = 4;
    public static final int REGEX_INCLUDE = 5;
    public static final int EXCLUDE_LABEL = 6;
    public static final int REGEX_EXCLUDE = 7;
    private static final int MAX_FILE_HANDLES = 4;
    private static final long REF_START_TIME = 946681200000L;
    private static final String ACTION_ADD = "add";
    private static final String ACTION_COPY = "copy";
    private static final String ACTION_DELETE = "delete";
    private static final String ACTION_MERGE = "merge";
    private static final String ACTION_SAVE_CONFIG = "save_config";
    protected PowerTableModel tableModel;
    protected JTable grid;
    protected JButton addRowButton;
    protected JButton copyRowButton;
    protected JButton deleteRowButton;
    protected JButton mergeButton;
    private FilePanel mergeAndWritePanel;
    private String prefixLabel = "";
    private List<SampleResult> samples = new ArrayList<SampleResult>(0);
    private MergeResultsService mergeService;

    public MergeResultsGui() {
        this.init();
    }

    public String getLabelResource() {
        return this.getClass().getSimpleName();
    }

    public String getStaticLabel() {
        return JMeterPluginsUtils.prefixLabel((String)"Merge Results");
    }

    public Collection<String> getMenuCategories() {
        return Arrays.asList("menu_non_test_elements");
    }

    protected Component getMergeAndWritePanel() {
        return this.mergeAndWritePanel;
    }

    public void setFile(String filename) {
        this.mergeAndWritePanel.setFilename(filename);
    }

    public String getFile() {
        return this.mergeAndWritePanel.getFilename();
    }

    public String getWikiPage() {
        return WIKIPAGE;
    }

    public JTable getGrid() {
        return this.grid;
    }

    public void modifyTestElement(TestElement c) {
        super.modifyTestElement(c);
        if (c instanceof ResultCollector) {
            ResultCollector rc = (ResultCollector)c;
            rc.setFilename(this.getFile());
            rc.setProperty((JMeterProperty)new StringProperty("filename", this.getFile()));
            CollectionProperty rows = JMeterPluginsUtils.tableModelRowsToCollectionProperty((PowerTableModel)this.tableModel, (String)DATA_PROPERTY);
            rc.setProperty((JMeterProperty)rows);
            this.collector = rc;
        }
    }

    public void configure(TestElement el) {
        super.configure(el);
        this.setFile(el.getPropertyAsString("filename"));
        JMeterProperty fileValues = el.getProperty(DATA_PROPERTY);
        if (!(fileValues instanceof NullProperty)) {
            CollectionProperty columns = (CollectionProperty)fileValues;
            this.tableModel.removeTableModelListener((TableModelListener)this);
            JMeterPluginsUtils.collectionPropertyToTableModelRows((CollectionProperty)columns, (PowerTableModel)this.tableModel, (Class[])columnClasses);
            this.tableModel.addTableModelListener((TableModelListener)this);
            this.updateUI();
        } else {
            log.warn("Received null property instead of collection");
        }
        this.checkDeleteButtonStatus();
        this.checkMergeButtonStatus();
        this.startTimeRef = 0L;
    }

    public void updateUI() {
        super.updateUI();
        if (this.tableModel != null) {
            CorrectedResultCollector crc = new CorrectedResultCollector();
            crc.setProperty((JMeterProperty)JMeterPluginsUtils.tableModelRowsToCollectionPropertyEval((PowerTableModel)this.tableModel, (String)DATA_PROPERTY));
        }
    }

    private void init() {
        this.setLayout(new BorderLayout());
        JPanel mainPanel = new JPanel();
        EmptyBorder margin = new EmptyBorder(10, 10, 5, 10);
        mainPanel.setBorder(margin);
        mainPanel.setLayout(new BoxLayout(mainPanel, 1));
        mainPanel.add(JMeterPluginsUtils.addHelpLinkToPanel((Container)this.makeTitlePanel(), (String)WIKIPAGE));
        VerticalPanel containerPanel = new VerticalPanel();
        JButton saveConfigButton = new JButton(JMeterUtils.getResString((String)"config_save_settings"));
        saveConfigButton.addActionListener(this);
        saveConfigButton.setActionCommand(ACTION_SAVE_CONFIG);
        this.mergeAndWritePanel = new FilePanel("Merge and write results to output file", EXTS);
        this.mergeAndWritePanel.addChangeListener((ChangeListener)this);
        this.mergeAndWritePanel.add((Component)saveConfigButton);
        this.mergeButton = new JButton("Merge");
        this.mergeButton.addActionListener(this);
        this.mergeButton.setActionCommand(ACTION_MERGE);
        JPanel controlPanel = new JPanel();
        controlPanel.add(this.mergeButton);
        containerPanel.add(this.createParamsPanel());
        containerPanel.add(this.getMergeAndWritePanel());
        containerPanel.add(controlPanel);
        this.add(mainPanel, "North");
        this.add((Component)containerPanel, "Center");
        this.hideFilePanel();
        this.enableMaximize(false);
    }

    private boolean loadFilesFromTable(CorrectedResultCollector crc) {
        for (int row = 0; row < this.tableModel.getRowCount(); ++row) {
            this.startTimeRef = 0L;
            crc.setFilename(String.valueOf(this.tableModel.getValueAt(row, 0)));
            if (crc.getFilename().isEmpty()) {
                GuiPackage.showErrorMessage((String)("Error merging results files - could not open file [row: " + row + ";filename: " + this.collector.getFilename() + "]"), (String)"Input file error");
                return false;
            }
            crc.setStartOffset(String.valueOf(this.tableModel.getValueAt(row, 2)));
            crc.setEndOffset(String.valueOf(this.tableModel.getValueAt(row, 3)));
            crc.setIncludeLabels(String.valueOf(this.tableModel.getValueAt(row, 4)));
            crc.setExcludeLabels(String.valueOf(this.tableModel.getValueAt(row, 6)));
            crc.setEnabledIncludeRegex(Boolean.valueOf(String.valueOf(this.tableModel.getValueAt(row, 5))).booleanValue());
            crc.setEnabledExcludeRegex(Boolean.valueOf(String.valueOf(this.tableModel.getValueAt(row, 7))).booleanValue());
            crc.setPrefixLabel(String.valueOf(this.tableModel.getValueAt(row, 1)));
            this.setUpFiltering(crc);
            crc.loadExistingFile();
        }
        return true;
    }

    public void add(SampleResult res) {
        if (!this.isSampleIncluded(res)) {
            return;
        }
        res.setSaveConfig(this.collector.getSaveConfig());
        if (!this.prefixLabel.isEmpty()) {
            String resLabel = res.getSampleLabel();
            res.setSampleLabel(this.prefixLabel + resLabel);
        }
        res.setTimeStamp(res.getTimeStamp() - this.startTimeRef + 946681200000L);
        this.samples.add(res);
    }

    public void setUpFiltering(CorrectedResultCollector rc) {
        super.setUpFiltering(rc);
        this.prefixLabel = rc.getPrefixLabel("prefix_label");
    }

    protected JPanel createParamsPanel() {
        JPanel panel = new JPanel(new BorderLayout(5, 5));
        panel.setBorder(BorderFactory.createTitledBorder("Merge Options"));
        panel.setPreferredSize(new Dimension(200, 200));
        JScrollPane scroll = new JScrollPane(this.createGrid());
        scroll.setPreferredSize(scroll.getMinimumSize());
        JPanel buttonsPanel = new JPanel(new GridLayout(1, 2));
        this.addRowButton = new JButton("Add Row");
        this.copyRowButton = new JButton("Copy Row");
        this.deleteRowButton = new JButton("Delete Row");
        this.addRowButton.addActionListener(this);
        this.addRowButton.setActionCommand(ACTION_ADD);
        this.copyRowButton.addActionListener(this);
        this.copyRowButton.setActionCommand(ACTION_COPY);
        this.deleteRowButton.addActionListener(this);
        this.deleteRowButton.setActionCommand(ACTION_DELETE);
        buttonsPanel.add(this.addRowButton);
        buttonsPanel.add(this.copyRowButton);
        buttonsPanel.add(this.deleteRowButton);
        panel.add((Component)scroll, "Center");
        panel.add((Component)buttonsPanel, "South");
        return panel;
    }

    @Override
    public void actionPerformed(ActionEvent action) {
        String command = action.getActionCommand();
        if (this.grid.isEditing()) {
            TableCellEditor cellEditor = this.grid.getCellEditor(this.grid.getEditingRow(), this.grid.getEditingColumn());
            cellEditor.stopCellEditing();
        }
        switch (command) {
            case "add": {
                this.tableModel.addRow(defaultValues);
                this.tableModel.fireTableDataChanged();
                if (this.tableModel.getRowCount() >= 4) {
                    this.addRowButton.setEnabled(false);
                    this.copyRowButton.setEnabled(false);
                }
                this.deleteRowButton.setEnabled(true);
                this.mergeButton.setEnabled(true);
                int rowToSelect = this.tableModel.getRowCount() - 1;
                if (rowToSelect < this.grid.getRowCount()) {
                    this.grid.setRowSelectionInterval(rowToSelect, rowToSelect);
                }
                this.updateUI();
                break;
            }
            case "copy": {
                int selectedRow = this.grid.getSelectedRow();
                if (this.tableModel.getRowCount() == 0 || selectedRow < 0) {
                    return;
                }
                this.tableModel.addRow(this.tableModel.getRowData(selectedRow));
                this.tableModel.fireTableDataChanged();
                if (this.tableModel.getRowCount() >= 4) {
                    this.addRowButton.setEnabled(false);
                    this.copyRowButton.setEnabled(false);
                }
                this.deleteRowButton.setEnabled(true);
                this.mergeButton.setEnabled(true);
                int rowToSelect = selectedRow + 1;
                this.grid.setRowSelectionInterval(rowToSelect, rowToSelect);
                this.updateUI();
                break;
            }
            case "delete": {
                int rowSelected = this.grid.getSelectedRow();
                if (rowSelected < 0) break;
                this.tableModel.removeRow(rowSelected);
                this.tableModel.fireTableDataChanged();
                if (this.tableModel.getRowCount() < 4) {
                    this.addRowButton.setEnabled(true);
                    this.copyRowButton.setEnabled(true);
                }
                if (this.tableModel.getRowCount() == 0) {
                    this.deleteRowButton.setEnabled(false);
                    this.mergeButton.setEnabled(false);
                } else {
                    int rowToSelect = rowSelected;
                    if (rowSelected >= this.tableModel.getRowCount()) {
                        rowToSelect = rowSelected - 1;
                    }
                    this.grid.setRowSelectionInterval(rowToSelect, rowToSelect);
                }
                this.updateUI();
                break;
            }
            case "merge": {
                String output = this.getFile();
                if (output.isEmpty()) {
                    GuiPackage.showErrorMessage((String)"Error merging results files - empty output filename", (String)"Output file error");
                    return;
                }
                boolean isSuccess = this.loadFilesFromTable((CorrectedResultCollector)this.collector);
                if (isSuccess) {
                    this.mergeService = new MergeResultsService();
                    this.collector.setFilename(output);
                    this.mergeService.mergeSamples((CorrectedResultCollector)this.collector, this.samples);
                }
                this.samples.clear();
                break;
            }
            case "save_config": {
                SavePropertyDialog d = new SavePropertyDialog((Frame)GuiPackage.getInstance().getMainFrame(), JMeterUtils.getResString((String)"sample_result_save_configuration"), true, this.collector.getSaveConfig());
                d.pack();
                ComponentUtil.centerComponentInComponent((Component)GuiPackage.getInstance().getMainFrame(), (Component)d);
                d.setVisible(true);
            }
        }
    }

    public void checkDeleteButtonStatus() {
        this.deleteRowButton.setEnabled(this.tableModel != null && this.tableModel.getRowCount() > 0);
    }

    public void checkMergeButtonStatus() {
        this.mergeButton.setEnabled(this.tableModel != null && this.tableModel.getRowCount() > 0);
    }

    private JTable createGrid() {
        this.grid = new JTable();
        this.grid.getDefaultEditor(String.class).addCellEditorListener(this);
        this.createTableModel();
        this.grid.setSelectionMode(0);
        this.grid.setMinimumSize(new Dimension(200, 100));
        return this.grid;
    }

    private void createTableModel() {
        this.tableModel = new PowerTableModel(columnIdentifiers, (Class[])columnClasses);
        this.tableModel.addTableModelListener((TableModelListener)this);
        this.grid.setModel((TableModel)this.tableModel);
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        this.updateUI();
    }

    @Override
    public void editingStopped(ChangeEvent e) {
        this.updateUI();
    }

    @Override
    public void editingCanceled(ChangeEvent e) {
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        log.debug("getting new collector");
        this.collector = (ResultCollector)this.createTestElement();
    }

    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }

    public void clearGui() {
        super.clearGui();
        this.tableModel.clearData();
        this.mergeAndWritePanel.clearGui();
    }

    protected JSettingsPanel createSettingsPanel() {
        return new JSettingsPanel((SettingsInterface)this, 0);
    }

    public GraphPanelChart getGraphPanelChart() {
        return new FakeGraphPanelChart();
    }

    private class FakeGraphPanelChart
    extends GraphPanelChart {
        public FakeGraphPanelChart() {
            super(false);
        }

        public void saveGraphToCSV(File file) throws IOException {
            log.info("Saving CSV to " + file.getAbsolutePath());
            MergeResultsGui.this.mergeService = new MergeResultsService();
            MergeResultsGui.this.collector.setFilename(file.getName());
            MergeResultsGui.this.mergeService.mergeSamples((CorrectedResultCollector)MergeResultsGui.this.collector, MergeResultsGui.this.samples);
        }

        public void saveGraphToPNG(File file, int w, int h) throws IOException {
            throw new UnsupportedOperationException("This plugin type cannot be saved as image");
        }
    }
}

