/*
 * Decompiled with CFR 0.152.
 */
package kg.apc.jmeter;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ListIterator;
import java.util.Properties;
import kg.apc.charting.GraphPanelChart;
import kg.apc.cmd.UniversalRunner;
import kg.apc.jmeter.CMDLineArgumentsProcessor;
import kg.apc.jmeter.JMeterPluginsUtils;
import kg.apc.jmeter.graphs.AbstractGraphPanelVisualizer;
import kg.apc.jmeter.vizualizers.CorrectedResultCollector;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.visualizers.Visualizer;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;

public class PluginsCMDWorker {
    private int graphWidth = 800;
    private int graphHeight = 600;
    public static final int EXPORT_PNG = 1;
    public static final int EXPORT_CSV = 2;
    private int exportMode = 0;
    private String inputFile;
    private String outputCSV;
    private String outputPNG;
    private AbstractGraphPanelVisualizer pluginType;
    private static final Logger log = LoggingManager.getLoggerForClass();
    private int aggregate = -1;
    private int zeroing = -1;
    private int preventOutliers = -1;
    private int rowsLimit = -1;
    private int forceY = -1;
    private int lowCounts = -1;
    private int granulation = -1;
    private int relativeTimes = -1;
    private int gradient = -1;
    private int autoScaleRows = -1;
    private float lineWeight = -1.0f;
    private String includeLabels = "";
    private String excludeLabels = "";
    private String startOffset = "";
    private String endOffset = "";
    private int includeSamplesWithRegex = -1;
    private int excludeSamplesWithRegex = -1;
    private int successFilter = -1;
    private int markers = -1;

    public PluginsCMDWorker() {
        log.info("Using JMeterPluginsCMD v. " + JMeterPluginsUtils.getVersion());
        JMeterPluginsUtils.prepareJMeterEnv(UniversalRunner.getJARLocation());
    }

    public void addExportMode(int mode) {
        this.exportMode |= mode;
    }

    public void setInputFile(String string) {
        this.inputFile = string;
    }

    public void setOutputCSVFile(String string) {
        this.outputCSV = string;
    }

    public void setOutputPNGFile(String string) {
        this.outputPNG = string;
    }

    public void setPluginType(String string) {
        this.pluginType = this.getGUIObject(string);
    }

    private void checkParams() {
        if (this.pluginType == null) {
            throw new IllegalArgumentException("Missing plugin type specification");
        }
        if (this.exportMode == 0) {
            throw new IllegalArgumentException("Missing any export specification");
        }
        if (this.inputFile == null) {
            throw new IllegalArgumentException("Missing input JTL file specification");
        }
        if (!new File(this.inputFile).exists()) {
            throw new IllegalArgumentException("Cannot find specified JTL file: " + this.inputFile);
        }
    }

    public void setGraphWidth(int i) {
        this.graphWidth = i;
    }

    public void setGraphHeight(int i) {
        this.graphHeight = i;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int doJob() {
        this.checkParams();
        AbstractGraphPanelVisualizer pluginInstance = this.pluginType;
        this.pluginType.setIgnoreCurrentTestStartTime();
        this.setOptions(pluginInstance);
        CorrectedResultCollector rc = (CorrectedResultCollector)pluginInstance.createTestElement();
        rc.setExcludeLabels(this.excludeLabels);
        rc.setIncludeLabels(this.includeLabels);
        rc.setStartOffset(this.startOffset);
        rc.setEndOffset(this.endOffset);
        if (this.includeSamplesWithRegex >= 0) {
            rc.setEnabledIncludeRegex(this.includeSamplesWithRegex != 0);
        }
        if (this.excludeSamplesWithRegex >= 0) {
            rc.setEnabledExcludeRegex(this.excludeSamplesWithRegex != 0);
        }
        if (this.successFilter >= 0) {
            rc.setErrorLogging(this.successFilter == 0);
            rc.setSuccessOnlyLogging(this.successFilter != 0);
        }
        if (this.pluginType.getStaticLabel().equals(JMeterPluginsUtils.prefixLabel("Merge Results"))) {
            log.debug("Using properties file with MergeResults plugin: " + this.inputFile);
            Properties prop = new Properties();
            FileInputStream input = null;
            try {
                input = new FileInputStream(this.inputFile);
                prop.load(input);
                for (int i = 1; i < 5; ++i) {
                    rc.setFilename(null == prop.getProperty("inputJtl" + i) ? "" : prop.getProperty("inputJtl" + i));
                    if (rc.getFilename().isEmpty()) {
                    }
                    rc.setPrefixLabel(null == prop.getProperty("prefixLabel" + i) ? "" : prop.getProperty("prefixLabel" + i));
                    rc.setIncludeLabels(null == prop.getProperty("includeLabels" + i) ? "" : prop.getProperty("includeLabels" + i));
                    rc.setExcludeLabels(null == prop.getProperty("excludeLabels" + i) ? "" : prop.getProperty("excludeLabels" + i));
                    rc.setEnabledIncludeRegex(Boolean.valueOf(prop.getProperty("includeLabelRegex" + i)));
                    rc.setEnabledExcludeRegex(Boolean.valueOf(prop.getProperty("excludeLabelRegex" + i)));
                    rc.setStartOffset(null == prop.getProperty("startOffset" + i) ? "" : prop.getProperty("startOffset" + i));
                    rc.setEndOffset(null == prop.getProperty("endOffset" + i) ? "" : prop.getProperty("endOffset" + i));
                    rc.setListener((Visualizer)pluginInstance);
                    pluginInstance.configure((TestElement)rc);
                    rc.loadExistingFile();
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
            finally {
                if (input != null) {
                    try {
                        ((InputStream)input).close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        } else {
            log.debug("Using JTL file: " + this.inputFile);
            rc.setFilename(this.inputFile);
            rc.setListener((Visualizer)pluginInstance);
            pluginInstance.configure((TestElement)rc);
            rc.loadExistingFile();
        }
        this.setOptions(pluginInstance);
        if ((this.exportMode & 1) == 1) {
            File pngFile = new File(this.outputPNG);
            this.forceDir(pngFile);
            try {
                pluginInstance.getGraphPanelChart().saveGraphToPNG(pngFile, this.graphWidth, this.graphHeight);
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }
        if ((this.exportMode & 2) == 2) {
            File csvFile = new File(this.outputCSV);
            this.forceDir(csvFile);
            try {
                pluginInstance.getGraphPanelChart().saveGraphToCSV(csvFile);
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }
        return 0;
    }

    private AbstractGraphPanelVisualizer getGUIObject(String pluginType) {
        Class<?> a;
        try {
            a = Class.forName(pluginType);
        }
        catch (ClassNotFoundException ex) {
            if (!pluginType.endsWith("Gui")) {
                return this.getGUIObject(pluginType + "Gui");
            }
            if (!pluginType.startsWith("kg.apc.jmeter.vizualizers.")) {
                return this.getGUIObject("kg.apc.jmeter.vizualizers." + pluginType);
            }
            throw new RuntimeException(ex);
        }
        try {
            return (AbstractGraphPanelVisualizer)a.newInstance();
        }
        catch (InstantiationException ex) {
            throw new RuntimeException(ex);
        }
        catch (IllegalAccessException ex) {
            throw new RuntimeException(ex);
        }
    }

    private void setOptions(AbstractGraphPanelVisualizer gui) {
        GraphPanelChart graph = gui.getGraphPanelChart();
        if (this.aggregate >= 0) {
            gui.switchModel(this.aggregate > 0);
        }
        if (this.granulation >= 0) {
            gui.setGranulation(this.granulation);
        }
        if (this.relativeTimes >= 0) {
            graph.setUseRelativeTime(this.relativeTimes > 0);
        }
        if (this.lineWeight >= 0.0f) {
            graph.getChartSettings().setLineWidth(this.lineWeight);
        }
        if (this.gradient >= 0) {
            graph.getChartSettings().setDrawGradient(this.gradient > 0);
        }
        if (this.zeroing >= 0) {
            graph.getChartSettings().setDrawFinalZeroingLines(this.zeroing > 0);
        }
        if (this.rowsLimit >= 0) {
            graph.getChartSettings().setMaxPointPerRow(this.rowsLimit);
        }
        if (this.preventOutliers >= 0) {
            graph.getChartSettings().setPreventXAxisOverScaling(this.preventOutliers > 0);
        }
        if (this.lowCounts >= 0) {
            graph.getChartSettings().setHideNonRepValLimit(this.lowCounts);
        }
        if (this.forceY >= 0) {
            graph.getChartSettings().setForcedMaxY(this.forceY);
        }
        if (this.autoScaleRows >= 0) {
            graph.getChartSettings().setExpendRows(this.autoScaleRows > 0);
        }
        if (this.markers >= 0) {
            graph.getChartSettings().setChartMarkers(this.markers > 0 ? 1 : 2);
        }
    }

    public void setAggregate(int logicValue) {
        this.aggregate = logicValue;
    }

    public void setZeroing(int logicValue) {
        this.zeroing = logicValue;
    }

    public void setPreventOutliers(int logicValue) {
        this.preventOutliers = logicValue;
    }

    public void setRowsLimit(int parseInt) {
        this.rowsLimit = parseInt;
    }

    public void setForceY(int parseInt) {
        this.forceY = parseInt;
    }

    public void setHideLowCounts(int parseInt) {
        this.lowCounts = parseInt;
    }

    public void setGranulation(int parseInt) {
        this.granulation = parseInt;
    }

    public void setRelativeTimes(int logicValue) {
        this.relativeTimes = logicValue;
    }

    public void setGradient(int logicValue) {
        this.gradient = logicValue;
    }

    public void setMarkers(int logicValue) {
        this.markers = logicValue;
    }

    public void setIncludeLabels(String string) {
        this.includeLabels = string;
    }

    public void setExcludeLabels(String string) {
        this.excludeLabels = string;
    }

    public void setIncludeSamplesWithRegex(int logicValue) {
        this.includeSamplesWithRegex = logicValue;
    }

    public void setExcludeSamplesWithRegex(int logicValue) {
        this.excludeSamplesWithRegex = logicValue;
    }

    public void setStartOffset(String string) {
        this.startOffset = string;
    }

    public void setEndOffset(String string) {
        this.endOffset = string;
    }

    public void setAutoScaleRows(int logicValue) {
        this.autoScaleRows = logicValue;
    }

    public void setLineWeight(float parseInt) {
        this.lineWeight = parseInt;
    }

    public void setSuccessFilter(int logicValue) {
        this.successFilter = logicValue;
    }

    private void forceDir(File resultFile) {
        File parent = resultFile.getParentFile();
        if (parent != null && !parent.mkdirs() && !parent.exists()) {
            throw new RuntimeException("Failed to create directory for " + resultFile.getAbsolutePath());
        }
    }

    public void processUnknownOption(String nextArg, ListIterator args) {
        if (this.pluginType == null || !(this.pluginType instanceof CMDLineArgumentsProcessor)) {
            throw new UnsupportedOperationException("Unrecognized option: " + nextArg);
        }
        log.debug("Trying to process unknown option using CMDLineArgumentsProcessor: " + nextArg);
        CMDLineArgumentsProcessor obj = (CMDLineArgumentsProcessor)((Object)this.pluginType);
        obj.processCMDOption(nextArg, args);
    }
}

