/*
 * Decompiled with CFR 0.152.
 */
package kg.apc.jmeter.reporters;

import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.SortedMap;
import java.util.Stack;
import java.util.TreeMap;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;

public class LoadosophiaAggregator {
    private static final Logger log = LoggingManager.getLoggerForClass();
    private SortedMap<Long, List<SampleResult>> buffer = new TreeMap<Long, List<SampleResult>>();
    private static final long SEND_SECONDS = 5L;
    private long lastTime = 0L;
    private SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ");

    public void addSample(SampleResult res) {
        Long time2;
        if (log.isDebugEnabled()) {
            log.debug("Got sample to process: " + res);
        }
        if (!this.buffer.containsKey(time2 = Long.valueOf(res.getEndTime() / 1000L))) {
            if (time2 < this.lastTime) {
                for (Long time2 : this.buffer.keySet()) {
                }
            }
            this.buffer.put(time2, new LinkedList());
        }
        this.lastTime = time2;
        ((List)this.buffer.get(time2)).add(res);
    }

    public boolean haveDataToSend() {
        return (long)this.buffer.size() > 6L;
    }

    public JSONArray getDataToSend() {
        JSONArray data = new JSONArray();
        Iterator<Long> it = this.buffer.keySet().iterator();
        int cnt = 0;
        while ((long)cnt < 5L && it.hasNext()) {
            Long sec = it.next();
            List raw = (List)this.buffer.get(sec);
            data.add(this.getAggregateSecond(raw));
            it.remove();
            ++cnt;
        }
        return data;
    }

    private JSONObject getAggregateSecond(List<SampleResult> raw) {
        JSONObject result = new JSONObject();
        Date ts = new Date(raw.iterator().next().getEndTime());
        result.put("ts", this.format.format(ts));
        int threads = 0;
        int avg_rt = 0;
        Long[] rtimes = new Long[raw.size()];
        String[] rcodes = new String[raw.size()];
        int cnt = 0;
        int failedCount = 0;
        for (SampleResult res : raw) {
            threads += res.getAllThreads();
            avg_rt = (int)((long)avg_rt + res.getTime());
            rtimes[cnt] = res.getTime();
            rcodes[cnt] = res.getResponseCode();
            if (!res.isSuccessful()) {
                ++failedCount;
            }
            ++cnt;
        }
        result.put("rps", (Object)cnt);
        result.put("threads", (Object)(threads / cnt));
        result.put("avg_rt", (Object)(avg_rt / cnt));
        result.put("quantiles", LoadosophiaAggregator.getQuantilesJSON(rtimes));
        result.put("net", this.getNetJSON(failedCount, cnt - failedCount));
        result.put("rc", this.getRCJSON(rcodes));
        result.put("planned_rps", (Object)0);
        return result;
    }

    public static JSONObject getQuantilesJSON(Long[] rtimes) {
        JSONObject result = new JSONObject();
        Arrays.sort((Object[])rtimes);
        double[] quantiles = new double[]{0.25, 0.5, 0.75, 0.8, 0.9, 0.95, 0.98, 0.99, 1.0};
        Stack<Long> timings = new Stack<Long>();
        timings.addAll(Arrays.asList(rtimes));
        double level = 1.0;
        long timing = 0L;
        for (int qn = quantiles.length - 1; qn >= 0; --qn) {
            double quan = quantiles[qn];
            while (level >= quan && !timings.empty()) {
                timing = (Long)timings.pop();
                level -= 1.0 / (double)rtimes.length;
            }
            result.element(String.valueOf(quan * 100.0), timing);
        }
        return result;
    }

    private JSONObject getNetJSON(int failedCount, int succCount) {
        JSONObject result = new JSONObject();
        result.put("0", (Object)succCount);
        result.put("1", (Object)failedCount);
        return result;
    }

    private JSONObject getRCJSON(String[] rcodes) {
        JSONObject result = new JSONObject();
        for (int i = 0; i < rcodes.length; ++i) {
            int oldval = 0;
            if (result.containsKey(rcodes[i])) {
                oldval = (Integer)result.get(rcodes[i]);
            }
            result.put(rcodes[i], (Object)(oldval + 1));
        }
        return result;
    }
}

