/*
 * Decompiled with CFR 0.152.
 */
package kg.apc.jmeter.reporters;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import kg.apc.jmeter.JMeterPluginsUtils;
import kg.apc.jmeter.reporters.LoadosophiaAggregator;
import kg.apc.jmeter.reporters.LoadosophiaUploaderGui;
import kg.apc.jmeter.reporters.LoadosophiaUploadingNotifier;
import org.apache.jmeter.reporters.ResultCollector;
import org.apache.jmeter.samplers.SampleEvent;
import org.apache.jmeter.samplers.SampleSaveConfiguration;
import org.apache.jmeter.testelement.TestStateListener;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;
import org.loadosophia.jmeter.LoadosophiaAPIClient;
import org.loadosophia.jmeter.LoadosophiaUploadResults;
import org.loadosophia.jmeter.StatusNotifierCallback;

public class LoadosophiaUploader
extends ResultCollector
implements StatusNotifierCallback,
Runnable,
TestStateListener {
    private static final Logger log = LoggingManager.getLoggerForClass();
    public static final String TITLE = "title";
    public static final String COLOR = "color";
    public static final String UPLOAD_TOKEN = "uploadToken";
    public static final String PROJECT = "project";
    public static final String STORE_DIR = "storeDir";
    public static final String USE_ONLINE = "useOnline";
    private String fileName;
    private static final Object LOCK = new Object();
    private boolean isSaving;
    private LoadosophiaUploadingNotifier perfMonNotifier = LoadosophiaUploadingNotifier.getInstance();
    private String address = JMeterUtils.getPropDefault((String)"loadosophia.address", (String)"https://loadosophia.org/");
    private boolean isOnlineInitiated = false;
    private LoadosophiaAPIClient apiClient;
    private BlockingQueue<SampleEvent> processingQueue;
    private Thread processorThread;
    private LoadosophiaAggregator aggregator;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testStarted(String host) {
        Object object = LOCK;
        synchronized (object) {
            this.apiClient = this.getAPIClient();
            try {
                if (!this.isSaving) {
                    this.isSaving = true;
                    this.setupSaving();
                }
            }
            catch (IOException ex) {
                log.error("Error setting up saving", (Throwable)ex);
            }
            this.initiateOnline();
        }
        super.testStarted(host);
        this.perfMonNotifier.startCollecting();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testEnded(String host) {
        super.testEnded(host);
        Object object = LOCK;
        synchronized (object) {
            try {
                Class<ResultCollector> c = ResultCollector.class;
                Method m = c.getDeclaredMethod("flushFile", new Class[0]);
                m.invoke((Object)this, new Object[0]);
                log.info("Successfully flushed results file");
            }
            catch (NoSuchMethodException ex) {
                log.warn("Cannot flush results file since you are using old version of JMeter, consider upgrading to latest. Currently the results may be incomplete.");
            }
            catch (InvocationTargetException e) {
                log.error("Failed to flush file", (Throwable)e);
            }
            catch (IllegalAccessException e) {
                log.error("Failed to flush file", (Throwable)e);
            }
            if (this.isOnlineInitiated) {
                this.finishOnline();
            }
            try {
                if (this.fileName == null) {
                    throw new IOException("File for upload was not set, search for errors above in log");
                }
                this.isSaving = false;
                LoadosophiaUploadResults uploadResult = this.apiClient.sendFiles(new File(this.fileName), this.perfMonNotifier.getFiles());
                this.informUser("Uploaded successfully, go to results: " + uploadResult.getRedirectLink());
            }
            catch (IOException ex) {
                this.informUser("Failed to upload results to Loadosophia.org, see log for detais");
                log.error("Failed to upload results to loadosophia", (Throwable)ex);
            }
        }
        this.clearData();
        this.perfMonNotifier.endCollecting();
    }

    private void setupSaving() throws IOException {
        File tmpFile;
        String dir = this.getStoreDir();
        if (!dir.endsWith(File.separator)) {
            dir = dir + File.separator;
        }
        try {
            tmpFile = File.createTempFile("Loadosophia_", ".jtl", new File(dir));
        }
        catch (IOException ex) {
            this.informUser("Unable to create temp file: " + ex.getMessage());
            this.informUser("Try to set another directory in the above field.");
            throw ex;
        }
        this.fileName = tmpFile.getAbsolutePath();
        tmpFile.delete();
        this.informUser("Storing results for upload to Loadosophia.org: " + this.fileName);
        this.setFilename(this.fileName);
        this.clearTemporary(this.getProperty("filename"));
        SampleSaveConfiguration conf = this.getSaveConfig();
        JMeterPluginsUtils.doBestCSVSetup(conf);
        this.setSaveConfig(conf);
    }

    public void setProject(String proj) {
        this.setProperty(PROJECT, proj);
    }

    public String getProject() {
        return this.getPropertyAsString(PROJECT);
    }

    public void setUploadToken(String token) {
        this.setProperty(UPLOAD_TOKEN, token);
    }

    public String getUploadToken() {
        return this.getPropertyAsString(UPLOAD_TOKEN);
    }

    public void setTitle(String prefix) {
        this.setProperty(TITLE, prefix);
    }

    public String getTitle() {
        return this.getPropertyAsString(TITLE);
    }

    private void informUser(String string) {
        log.info(string);
        if (this.getVisualizer() != null && this.getVisualizer() instanceof LoadosophiaUploaderGui) {
            ((LoadosophiaUploaderGui)this.getVisualizer()).inform(string);
        } else {
            log.info(string);
        }
    }

    public String getStoreDir() {
        return this.getPropertyAsString(STORE_DIR);
    }

    public void setStoreDir(String prefix) {
        this.setProperty(STORE_DIR, prefix);
    }

    public void setColorFlag(String color) {
        this.setProperty(COLOR, color);
    }

    public String getColorFlag() {
        return this.getPropertyAsString(COLOR);
    }

    protected LoadosophiaAPIClient getAPIClient() {
        return new LoadosophiaAPIClient(this, this.address, this.getUploadToken(), this.getProject(), this.getColorFlag(), this.getTitle());
    }

    @Override
    public void notifyAbout(String info) {
        this.informUser(info);
    }

    public boolean isUseOnline() {
        return this.getPropertyAsBoolean(USE_ONLINE);
    }

    public void setUseOnline(boolean selected) {
        this.setProperty(USE_ONLINE, selected);
    }

    public void sampleOccurred(SampleEvent event) {
        super.sampleOccurred(event);
        if (this.isOnlineInitiated) {
            try {
                if (!this.processingQueue.offer(event, 1L, TimeUnit.SECONDS)) {
                    log.warn("Failed first dequeue insert try, retrying");
                    if (!this.processingQueue.offer(event, 1L, TimeUnit.SECONDS)) {
                        log.error("Failed second try to inser into deque, dropped sample");
                    }
                }
            }
            catch (InterruptedException ex) {
                log.info("Interrupted while putting sample event into deque", (Throwable)ex);
            }
        }
    }

    @Override
    public void run() {
        while (this.isOnlineInitiated) {
            try {
                SampleEvent event = this.processingQueue.poll(1L, TimeUnit.SECONDS);
                if (event != null) {
                    this.aggregator.addSample(event.getResult());
                }
                if (!this.aggregator.haveDataToSend()) continue;
                try {
                    this.apiClient.sendOnlineData(this.aggregator.getDataToSend());
                }
                catch (IOException ex) {
                    log.warn("Failed to send active test data", (Throwable)ex);
                }
            }
            catch (InterruptedException ex) {
                log.debug("Interrupted while taking sample event from deque", (Throwable)ex);
                break;
            }
        }
    }

    private void initiateOnline() {
        if (this.isUseOnline()) {
            try {
                log.info("Starting Loadosophia online test");
                this.informUser("Started active test: " + this.apiClient.startOnline());
                this.aggregator = new LoadosophiaAggregator();
                this.processingQueue = new LinkedBlockingQueue<SampleEvent>();
                this.processorThread = new Thread(this);
                this.processorThread.setDaemon(true);
                this.isOnlineInitiated = true;
                this.processorThread.start();
            }
            catch (IOException ex) {
                this.informUser("Failed to start active test");
                log.warn("Failed to initiate active test", (Throwable)ex);
                this.isOnlineInitiated = false;
            }
        }
    }

    private void finishOnline() {
        this.isOnlineInitiated = false;
        this.processorThread.interrupt();
        while (this.processorThread.isAlive() && !this.processorThread.isInterrupted()) {
            log.info("Waiting for aggregator thread to stop...");
            try {
                Thread.sleep(50L);
                this.processorThread.interrupt();
            }
            catch (InterruptedException ex) {
                log.warn("Interrupted sleep", (Throwable)ex);
            }
        }
        log.info("Ending Loadosophia online test");
        try {
            this.apiClient.endOnline();
        }
        catch (IOException ex) {
            log.warn("Failed to finalize active test", (Throwable)ex);
        }
    }
}

