/*
 * Decompiled with CFR 0.152.
 */
package kg.apc.jmeter.vizualizers;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.text.DecimalFormat;
import java.text.Format;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import kg.apc.charting.GraphPanelChart;
import kg.apc.jmeter.JMeterPluginsUtils;
import kg.apc.jmeter.graphs.AbstractGraphPanelVisualizer;
import kg.apc.jmeter.vizualizers.CorrectedResultCollector;
import kg.apc.jmeter.vizualizers.JSettingsPanel;
import org.apache.jmeter.gui.util.FileDialoger;
import org.apache.jmeter.samplers.Clearable;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.save.CSVSaveService;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.testelement.property.BooleanProperty;
import org.apache.jmeter.testelement.property.JMeterProperty;
import org.apache.jmeter.testelement.property.StringProperty;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jmeter.visualizers.SamplingStatCalculator;
import org.apache.jorphan.gui.NumberRenderer;
import org.apache.jorphan.gui.ObjectTableModel;
import org.apache.jorphan.gui.RateRenderer;
import org.apache.jorphan.gui.RendererUtils;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.jorphan.reflect.Functor;
import org.apache.jorphan.util.JOrphanUtils;
import org.apache.log.Logger;
import org.jmeterplugins.visualizers.gui.FilterPanel;

public class SynthesisReportGui
extends AbstractGraphPanelVisualizer
implements Clearable,
ActionListener {
    private static final long serialVersionUID = 240L;
    private static final String pct1Label = JMeterUtils.getPropDefault((String)"aggregate_rpt_pct1", (String)"90");
    private static final Float pct1Value = new Float(Float.parseFloat(pct1Label) / 100.0f);
    protected FilterPanel jPanelFilter;
    private static final Logger log = LoggingManager.getLoggerForClass();
    public static final String WIKIPAGE = "SynthesisReport";
    private static final String USE_GROUP_NAME = "useGroupName";
    private static final String SAVE_HEADERS = "saveHeaders";
    private static final String[] COLUMNS_BEFORE_JM_2_13 = new String[]{"sampler_label", "aggregate_report_count", "average", "aggregate_report_min", "aggregate_report_max", "aggregate_report_90%_line", "aggregate_report_stddev", "aggregate_report_error%", "aggregate_report_rate", "aggregate_report_bandwidth", "average_bytes"};
    private static final String[] COLUMNS_AFTER_OR_EQUAL_JM_2_13 = new String[]{"sampler_label", "aggregate_report_count", "average", "aggregate_report_min", "aggregate_report_max", "aggregate_report_xx_pct1_line", "aggregate_report_stddev", "aggregate_report_error%", "aggregate_report_rate", "aggregate_report_bandwidth", "average_bytes"};
    private static final boolean bOldVersion = Float.compare(Float.parseFloat(JMeterUtils.getJMeterVersion().substring(0, 4)), new Float(2.13).floatValue()) < 0;
    private static final String[] COLUMNS = bOldVersion ? COLUMNS_BEFORE_JM_2_13 : COLUMNS_AFTER_OR_EQUAL_JM_2_13;
    static final Object[][] COLUMNS_MSG_PARAMETERS = new Object[][]{null, null, null, null, null, {pct1Label}, null, null, null, null, null};
    private final String TOTAL_ROW_LABEL = JMeterUtils.getResString((String)"aggregate_report_total_label");
    private JTable myJTable;
    private JScrollPane myScrollPane;
    private final JButton saveTable = new JButton(JMeterUtils.getResString((String)"aggregate_graph_save_table"));
    private final JCheckBox saveHeaders = new JCheckBox(JMeterUtils.getResString((String)"aggregate_graph_save_table_header"), true);
    private final JCheckBox useGroupName = new JCheckBox(JMeterUtils.getResString((String)"aggregate_graph_use_group_name"));
    private transient ObjectTableModel model;
    private final transient Object lock = new Object();
    private final Map<String, SamplingStatCalculator> tableRows = new ConcurrentHashMap<String, SamplingStatCalculator>();
    private static final TableCellRenderer[] RENDERERS = new TableCellRenderer[]{null, null, null, null, null, null, new NumberRenderer("#0.00"), new NumberRenderer("#0.00%"), new RateRenderer("#.0"), new NumberRenderer("#0.00"), new NumberRenderer("#.0")};
    static final Format[] FORMATS = new Format[]{null, null, null, null, null, null, new DecimalFormat("#0.00"), new DecimalFormat("#0.00%"), new DecimalFormat("#.0"), new DecimalFormat("#0.00"), new DecimalFormat("#.0")};

    public SynthesisReportGui() {
        this.model = SynthesisReportGui.createObjectTableModel();
        this.clearData();
        this.init();
    }

    static ObjectTableModel createObjectTableModel() {
        return new ObjectTableModel(COLUMNS, SamplingStatCalculator.class, new Functor[]{new Functor("getLabel"), new Functor("getCount"), new Functor("getMeanAsNumber"), new Functor("getMin"), new Functor("getMax"), new Functor("getPercentPoint", new Object[]{pct1Value}), new Functor("getStandardDeviation"), new Functor("getErrorPercentage"), new Functor("getRate"), new Functor("getKBPerSecond"), new Functor("getAvgPageBytes")}, new Functor[]{null, null, null, null, null, null, null, null, null, null, null}, new Class[]{String.class, Long.class, Long.class, Long.class, Long.class, Long.class, String.class, String.class, String.class, String.class, String.class});
    }

    public String getLabelResource() {
        return this.getClass().getSimpleName();
    }

    @Override
    public String getStaticLabel() {
        return JMeterPluginsUtils.prefixLabel("Synthesis Report (filtered)");
    }

    public void add(final SampleResult res) {
        JMeterUtils.runSafe((Runnable)new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                if (SynthesisReportGui.this.isSampleIncluded(res)) {
                    SamplingStatCalculator tot;
                    SamplingStatCalculator row = null;
                    String sampleLabel = res.getSampleLabel(SynthesisReportGui.this.useGroupName.isSelected());
                    Object object = SynthesisReportGui.this.lock;
                    synchronized (object) {
                        row = (SamplingStatCalculator)SynthesisReportGui.this.tableRows.get(sampleLabel);
                        if (row == null) {
                            row = new SamplingStatCalculator(sampleLabel);
                            SynthesisReportGui.this.tableRows.put(row.getLabel(), row);
                            SynthesisReportGui.this.model.insertRow((Object)row, SynthesisReportGui.this.model.getRowCount() - 1);
                        }
                    }
                    object = row;
                    synchronized (object) {
                        row.addSample(res);
                    }
                    SamplingStatCalculator samplingStatCalculator = tot = (SamplingStatCalculator)SynthesisReportGui.this.tableRows.get(SynthesisReportGui.this.TOTAL_ROW_LABEL);
                    synchronized (samplingStatCalculator) {
                        tot.addSample(res);
                    }
                    SynthesisReportGui.this.model.fireTableDataChanged();
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearData() {
        Object object = this.lock;
        synchronized (object) {
            this.model.clearData();
            this.tableRows.clear();
            this.tableRows.put(this.TOTAL_ROW_LABEL, new SamplingStatCalculator(this.TOTAL_ROW_LABEL));
            this.model.addRow((Object)this.tableRows.get(this.TOTAL_ROW_LABEL));
        }
    }

    private void init() {
        this.setLayout(new BorderLayout());
        JPanel mainPanel = new JPanel();
        EmptyBorder margin = new EmptyBorder(10, 10, 5, 10);
        mainPanel.setBorder(margin);
        mainPanel.setLayout(new BoxLayout(mainPanel, 1));
        mainPanel.add(JMeterPluginsUtils.addHelpLinkToPanel(this.makeTitlePanel(), WIKIPAGE));
        this.myJTable = new JTable((TableModel)this.model);
        this.myJTable.getTableHeader().setDefaultRenderer(new JMeterHeaderAsPropertyRenderer(COLUMNS_MSG_PARAMETERS));
        this.myJTable.setPreferredScrollableViewportSize(new Dimension(500, 70));
        RendererUtils.applyRenderers((JTable)this.myJTable, (TableCellRenderer[])RENDERERS);
        this.myScrollPane = new JScrollPane(this.myJTable);
        this.add(mainPanel, "North");
        this.add(this.myScrollPane, "Center");
        this.saveTable.addActionListener(this);
        JPanel opts = new JPanel();
        opts.add((Component)this.useGroupName, "West");
        opts.add((Component)this.saveTable, "Center");
        opts.add((Component)this.saveHeaders, "East");
        this.add(opts, "South");
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        log.debug("getting new collector");
        this.collector = (CorrectedResultCollector)this.createTestElement();
        if (this.collector instanceof CorrectedResultCollector) {
            this.setUpFiltering((CorrectedResultCollector)this.collector);
        }
        this.collector.loadExistingFile();
    }

    @Override
    public void modifyTestElement(TestElement c) {
        super.modifyTestElement(c);
        c.setProperty(USE_GROUP_NAME, this.useGroupName.isSelected(), false);
        c.setProperty(SAVE_HEADERS, this.saveHeaders.isSelected(), true);
        c.setProperty((JMeterProperty)new StringProperty("include_sample_labels", this.jPanelFilter.getIncludeSampleLabels()));
        c.setProperty((JMeterProperty)new StringProperty("exclude_sample_labels", this.jPanelFilter.getExcludeSampleLabels()));
        c.setProperty((JMeterProperty)new StringProperty("start_offset", this.jPanelFilter.getStartOffset()));
        c.setProperty((JMeterProperty)new StringProperty("end_offset", this.jPanelFilter.getEndOffset()));
        c.setProperty((JMeterProperty)new BooleanProperty("include_checkbox_state", this.jPanelFilter.isSelectedRegExpInc()));
        c.setProperty((JMeterProperty)new BooleanProperty("exclude_checkbox_state", this.jPanelFilter.isSelectedRegExpExc()));
    }

    @Override
    public void configure(TestElement el) {
        super.configure(el);
        this.useGroupName.setSelected(el.getPropertyAsBoolean(USE_GROUP_NAME, false));
        this.saveHeaders.setSelected(el.getPropertyAsBoolean(SAVE_HEADERS, true));
        this.jPanelFilter.setIncludeSampleLabels(el.getPropertyAsString("include_sample_labels"));
        this.jPanelFilter.setExcludeSampleLabels(el.getPropertyAsString("exclude_sample_labels"));
        if (!"".equals(el.getPropertyAsString("start_offset"))) {
            this.jPanelFilter.setStartOffset(el.getPropertyAsLong("start_offset"));
        }
        if (!"".equals(el.getPropertyAsString("end_offset"))) {
            this.jPanelFilter.setEndOffset(el.getPropertyAsLong("end_offset"));
        }
        this.jPanelFilter.setSelectedRegExpInc(el.getPropertyAsBoolean("include_checkbox_state"));
        this.jPanelFilter.setSelectedRegExpExc(el.getPropertyAsBoolean("exclude_checkbox_state"));
        if (el instanceof CorrectedResultCollector) {
            this.setUpFiltering((CorrectedResultCollector)el);
        }
    }

    protected Container makeTitlePanel() {
        this.jPanelFilter = new FilterPanel();
        Container panel = super.makeTitlePanel();
        panel.add(this.jPanelFilter);
        return panel;
    }

    @Override
    public void clearGui() {
        super.clearGui();
        this.jPanelFilter.clearGui();
    }

    public static List<List<Object>> getAllTableData(ObjectTableModel model, Format[] formats) {
        ArrayList<List<Object>> data = new ArrayList<List<Object>>();
        if (model.getRowCount() > 0) {
            for (int rw = 0; rw < model.getRowCount(); ++rw) {
                int cols = model.getColumnCount();
                ArrayList<Object> column = new ArrayList<Object>();
                data.add(column);
                for (int idx = 0; idx < cols; ++idx) {
                    Object val = model.getValueAt(rw, idx);
                    if (formats[idx] != null) {
                        column.add(formats[idx].format(val));
                        continue;
                    }
                    column.add(val);
                }
            }
        }
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public void actionPerformed(ActionEvent ev) {
        if (ev.getSource() == this.saveTable) {
            JFileChooser chooser = FileDialoger.promptToSaveFile((String)"synthesis.csv");
            if (chooser == null) {
                return;
            }
            FileWriter writer = null;
            try {
                writer = new FileWriter(chooser.getSelectedFile());
                CSVSaveService.saveCSVStats(SynthesisReportGui.getAllTableData(this.model, FORMATS), (FileWriter)writer, (String[])(this.saveHeaders.isSelected() ? SynthesisReportGui.getLabels(COLUMNS) : null));
            }
            catch (FileNotFoundException e) {
                log.warn(e.getMessage());
                JOrphanUtils.closeQuietly((Closeable)writer);
            }
            catch (IOException e2) {
                log.warn(e2.getMessage());
                {
                    catch (Throwable throwable) {
                        JOrphanUtils.closeQuietly(writer);
                        throw throwable;
                    }
                }
                JOrphanUtils.closeQuietly((Closeable)writer);
            }
            JOrphanUtils.closeQuietly((Closeable)writer);
        }
    }

    static String[] getLabels(String[] keys) {
        String[] labels = new String[keys.length];
        for (int i = 0; i < labels.length; ++i) {
            labels[i] = MessageFormat.format(JMeterUtils.getResString((String)keys[i]), COLUMNS_MSG_PARAMETERS[i]);
        }
        return labels;
    }

    @Override
    public String getWikiPage() {
        return WIKIPAGE;
    }

    @Override
    public GraphPanelChart getGraphPanelChart() {
        return new FakeGraphPanelChart();
    }

    @Override
    protected JSettingsPanel createSettingsPanel() {
        return new JSettingsPanel(this, 0);
    }

    private class JMeterHeaderAsPropertyRenderer
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = 240L;
        private Object[][] columnsMsgParameters;

        public JMeterHeaderAsPropertyRenderer() {
            this(null);
        }

        public JMeterHeaderAsPropertyRenderer(Object[][] columnsMsgParameters) {
            this.columnsMsgParameters = columnsMsgParameters;
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (table != null) {
                JTableHeader header = table.getTableHeader();
                if (header != null) {
                    this.setForeground(header.getForeground());
                    this.setBackground(header.getBackground());
                    this.setFont(header.getFont());
                }
                this.setText(this.getText(value, row, column));
                this.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
                this.setHorizontalAlignment(0);
            }
            return this;
        }

        protected String getText(Object value, int row, int column) {
            if (value == null) {
                return "";
            }
            if (this.columnsMsgParameters != null && this.columnsMsgParameters[column] != null) {
                return MessageFormat.format(JMeterUtils.getResString((String)value.toString()), this.columnsMsgParameters[column]);
            }
            return JMeterUtils.getResString((String)value.toString());
        }
    }

    private class FakeGraphPanelChart
    extends GraphPanelChart {
        public FakeGraphPanelChart() {
            super(false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void saveGraphToCSV(File file) throws IOException {
            log.info("Saving CSV to " + file.getAbsolutePath());
            FileWriter writer = null;
            try {
                writer = new FileWriter(file);
                CSVSaveService.saveCSVStats(SynthesisReportGui.getAllTableData(SynthesisReportGui.this.model, FORMATS), (FileWriter)writer, (String[])(SynthesisReportGui.this.saveHeaders.isSelected() ? SynthesisReportGui.getLabels(COLUMNS) : null));
            }
            catch (FileNotFoundException e) {
                log.warn(e.getMessage());
            }
            catch (IOException e) {
                log.warn(e.getMessage());
            }
            finally {
                try {
                    writer.close();
                }
                catch (IOException ex) {
                    log.warn("There was problem closing file stream", (Throwable)ex);
                }
            }
        }

        @Override
        public void saveGraphToPNG(File file, int w, int h) throws IOException {
            throw new UnsupportedOperationException("This plugin type cannot be saved as image");
        }
    }
}

