/*
 * Decompiled with CFR 0.152.
 */
package kg.apc.jmeter.config;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import javax.swing.JButton;
import javax.swing.JPanel;
import kg.apc.jmeter.JMeterPluginsUtils;
import kg.apc.jmeter.config.AddRemoteServerAction;
import kg.apc.jmeter.config.DistributedTestControl;
import kg.apc.jmeter.config.ServersListPanel;
import org.apache.jmeter.config.gui.AbstractConfigGui;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;

public class DistributedTestControlGui
extends AbstractConfigGui {
    public static final String WIKIPAGE = "DistributedTestControl";
    public static Logger log = LoggingManager.getLoggerForClass();
    private ServersListPanel serversPanel;

    public DistributedTestControlGui() {
        this.init();
        this.initFields();
    }

    public Collection<String> getMenuCategories() {
        return new ArrayList<String>();
    }

    public String getStaticLabel() {
        return JMeterPluginsUtils.prefixLabel("Distributed Test Control");
    }

    public String getLabelResource() {
        return ((Object)((Object)this)).getClass().getCanonicalName();
    }

    public void configure(TestElement te) {
        super.configure(te);
        this.serversPanel.loadFromTestElement((DistributedTestControl)te);
    }

    public TestElement createTestElement() {
        String srv_list = JMeterUtils.getPropDefault((String)"remote_hosts", (String)"127.0.0.1");
        ArrayList<String> data = new ArrayList<String>(Arrays.asList(srv_list.split(",")));
        for (String srv_name : data) {
            this.serversPanel.add(srv_name);
        }
        DistributedTestControl control = new DistributedTestControl();
        control.setData(data);
        this.modifyTestElement((TestElement)control);
        return control;
    }

    public void modifyTestElement(TestElement te) {
        this.configureTestElement(te);
        this.serversPanel.saveToTestElement((DistributedTestControl)te);
    }

    public void clearGui() {
        super.clearGui();
        this.initFields();
    }

    private void init() {
        this.setLayout(new BorderLayout(0, 5));
        this.setBorder(this.makeBorder());
        this.add(JMeterPluginsUtils.addHelpLinkToPanel(this.makeTitlePanel(), WIKIPAGE), "North");
        this.serversPanel = new ServersListPanel();
        JPanel buttonPanel = new JPanel();
        JButton btnAdd = new JButton("Add Slave Server");
        btnAdd.addActionListener(new AddRemoteServerAction(this.serversPanel));
        buttonPanel.add(btnAdd);
        JButton btnStatus = new JButton("Get Status for All");
        buttonPanel.add(btnStatus);
        JPanel container = new JPanel(new BorderLayout());
        container.add((Component)buttonPanel, "North");
        container.add((Component)this.serversPanel, "Center");
        this.add(container, "Center");
    }

    private void initFields() {
        this.serversPanel.clear();
    }
}

