/*
 * Decompiled with CFR 0.152.
 */
package kg.apc.jmeter.functions;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.apache.jmeter.engine.util.CompoundVariable;
import org.apache.jmeter.functions.AbstractFunction;
import org.apache.jmeter.functions.InvalidVariableException;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.samplers.Sampler;
import org.apache.jmeter.threads.JMeterVariables;

public class DoubleSum
extends AbstractFunction {
    private static final List<String> desc = new LinkedList<String>();
    private static final String KEY = "__doubleSum";
    private Object[] values;

    public synchronized String execute(SampleResult previousResult, Sampler currentSampler) throws InvalidVariableException {
        JMeterVariables vars = this.getVariables();
        Double sum = 0.0;
        String varName = ((CompoundVariable)this.values[this.values.length - 1]).execute().trim();
        for (int i = 0; i < this.values.length - 1; ++i) {
            sum = sum + Double.parseDouble(((CompoundVariable)this.values[i]).execute());
        }
        try {
            sum = sum + Double.parseDouble(varName);
            varName = null;
        }
        catch (NumberFormatException i) {
            // empty catch block
        }
        String totalString = Double.toString(sum);
        if (vars != null && varName != null && varName.length() > 0) {
            vars.put(varName, totalString);
        }
        return totalString;
    }

    public synchronized void setParameters(Collection<CompoundVariable> parameters) throws InvalidVariableException {
        this.checkMinParameterCount(parameters, 2);
        this.values = parameters.toArray();
    }

    public String getReferenceKey() {
        return KEY;
    }

    public List<String> getArgumentDesc() {
        return desc;
    }

    static {
        desc.add("First double to add");
        desc.add("Second long to add - further doubles can be summed by adding further arguments");
        desc.add("Name of variable in which to store the result (optional)");
    }
}

