/*
 * Decompiled with CFR 0.152.
 */
package kg.apc.jmeter.modifiers;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import kg.apc.jmeter.JMeterPluginsUtils;
import kg.apc.jmeter.gui.GuiBuilderHelper;
import kg.apc.jmeter.modifiers.FifoPutPostProcessor;
import org.apache.jmeter.processor.gui.AbstractPostProcessorGui;
import org.apache.jmeter.testelement.TestElement;

public class FifoPutPostProcessorGui
extends AbstractPostProcessorGui {
    public static final String WIKIPAGE = "InterThreadCommunication";
    private JTextField queueName;
    private JTextArea value;

    public FifoPutPostProcessorGui() {
        this.init();
        this.initFields();
    }

    public String getStaticLabel() {
        return JMeterPluginsUtils.prefixLabel("Inter-Thread Communication PostProcessor");
    }

    public String getLabelResource() {
        return ((Object)((Object)this)).getClass().getCanonicalName();
    }

    public void configure(TestElement element) {
        super.configure(element);
        if (element instanceof FifoPutPostProcessor) {
            FifoPutPostProcessor el = (FifoPutPostProcessor)element;
            this.queueName.setText(el.getQueueName());
            this.value.setText(el.getValue());
        }
    }

    public TestElement createTestElement() {
        FifoPutPostProcessor preproc = new FifoPutPostProcessor();
        this.modifyTestElement((TestElement)preproc);
        preproc.setComment(JMeterPluginsUtils.getWikiLinkText(WIKIPAGE));
        return preproc;
    }

    public void modifyTestElement(TestElement te) {
        this.configureTestElement(te);
        if (te instanceof FifoPutPostProcessor) {
            FifoPutPostProcessor preproc = (FifoPutPostProcessor)te;
            preproc.setValue(this.value.getText());
            preproc.setQueueName(this.queueName.getText());
        }
    }

    public void clearGui() {
        super.clearGui();
        this.initFields();
    }

    private void init() {
        this.setLayout(new BorderLayout(0, 5));
        this.setBorder(this.makeBorder());
        this.add(JMeterPluginsUtils.addHelpLinkToPanel(this.makeTitlePanel(), WIKIPAGE), "North");
        JPanel mainPanel = new JPanel(new GridBagLayout());
        GridBagConstraints labelConstraints = new GridBagConstraints();
        labelConstraints.anchor = 24;
        GridBagConstraints editConstraints = new GridBagConstraints();
        editConstraints.anchor = 23;
        editConstraints.weightx = 1.0;
        editConstraints.fill = 2;
        this.addToPanel(mainPanel, labelConstraints, 0, 0, new JLabel("FIFO Queue Name to Put Data Into: ", 4));
        this.queueName = new JTextField(20);
        this.addToPanel(mainPanel, editConstraints, 1, 0, this.queueName);
        editConstraints.insets = new Insets(4, 0, 0, 0);
        labelConstraints.insets = new Insets(4, 0, 0, 0);
        this.addToPanel(mainPanel, labelConstraints, 0, 6, new JLabel("Value to Put: ", 4));
        editConstraints.fill = 1;
        this.value = new JTextArea();
        this.addToPanel(mainPanel, editConstraints, 1, 6, GuiBuilderHelper.getTextAreaScrollPaneContainer(this.value, 10));
        JPanel container = new JPanel(new BorderLayout());
        container.add((Component)mainPanel, "North");
        this.add(container, "Center");
    }

    private void addToPanel(JPanel panel, GridBagConstraints constraints, int col, int row, JComponent component) {
        constraints.gridx = col;
        constraints.gridy = row;
        panel.add((Component)component, constraints);
    }

    private void initFields() {
        this.queueName.setText("SYNC_FIFO");
        this.value.setText("");
    }
}

