/*
 * Decompiled with CFR 0.152.
 */
package kg.apc.jmeter.samplers;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import kg.apc.jmeter.JMeterPluginsUtils;
import kg.apc.jmeter.gui.GuiBuilderHelper;
import kg.apc.jmeter.samplers.DummySampler;
import org.apache.jmeter.samplers.gui.AbstractSamplerGui;
import org.apache.jmeter.testelement.TestElement;

public class DummySamplerGui
extends AbstractSamplerGui {
    public static final String WIKIPAGE = "DummySampler";
    private JCheckBox isSuccessful;
    private JTextField responseCode;
    private JTextField responseMessage;
    private JTextField responseTime;
    private JTextArea responseData;
    private JTextArea requestData;
    private JCheckBox isWaiting;
    private JTextField latency;
    private JTextField connect;

    public DummySamplerGui() {
        this.init();
    }

    public String getStaticLabel() {
        return JMeterPluginsUtils.prefixLabel("Dummy Sampler");
    }

    public void configure(TestElement element) {
        super.configure(element);
        this.isSuccessful.setSelected(element.getPropertyAsBoolean("SUCCESFULL"));
        this.isWaiting.setSelected(element.getPropertyAsBoolean("WAITING"));
        this.responseCode.setText(element.getPropertyAsString("RESPONSE_CODE"));
        this.responseMessage.setText(element.getPropertyAsString("RESPONSE_MESSAGE"));
        this.requestData.setText(element.getPropertyAsString("REQUEST_DATA"));
        this.responseData.setText(element.getPropertyAsString("RESPONSE_DATA"));
        this.responseTime.setText(element.getPropertyAsString("RESPONSE_TIME"));
        this.latency.setText(element.getPropertyAsString("LATENCY"));
        this.connect.setText(element.getPropertyAsString("CONNECT"));
    }

    public TestElement createTestElement() {
        DummySampler sampler = new DummySampler();
        this.modifyTestElement((TestElement)sampler);
        sampler.setComment(JMeterPluginsUtils.getWikiLinkText(WIKIPAGE));
        return sampler;
    }

    public void modifyTestElement(TestElement sampler) {
        super.configureTestElement(sampler);
        if (sampler instanceof DummySampler) {
            DummySampler dummySampler = (DummySampler)sampler;
            dummySampler.setSimulateWaiting(this.isWaiting.isSelected());
            dummySampler.setSuccessful(this.isSuccessful.isSelected());
            dummySampler.setResponseCode(this.responseCode.getText());
            dummySampler.setResponseMessage(this.responseMessage.getText());
            dummySampler.setRequestData(this.requestData.getText());
            dummySampler.setResponseData(this.responseData.getText());
            dummySampler.setResponseTime(this.responseTime.getText());
            dummySampler.setLatency(this.latency.getText());
            dummySampler.setConnectTime(this.connect.getText());
        }
    }

    public void clearGui() {
        super.clearGui();
        this.initFields();
    }

    private void initFields() {
        this.isSuccessful.setSelected(true);
        this.isWaiting.setSelected(true);
        this.responseCode.setText("200");
        this.responseMessage.setText("OK");
        this.requestData.setText("Dummy Sampler used to simulate requests and responses\nwithout actual network activity. This helps debugging tests.");
        this.responseData.setText("Dummy Sampler used to simulate requests and responses\nwithout actual network activity. This helps debugging tests.");
        this.responseTime.setText("${__Random(50,500)}");
        this.latency.setText("${__Random(1,50)}");
        this.connect.setText("${__Random(1,5)}");
    }

    public String getLabelResource() {
        return ((Object)((Object)this)).getClass().getSimpleName();
    }

    private void init() {
        this.setLayout(new BorderLayout(0, 5));
        this.setBorder(this.makeBorder());
        this.add(JMeterPluginsUtils.addHelpLinkToPanel(this.makeTitlePanel(), WIKIPAGE), "North");
        JPanel mainPanel = new JPanel(new GridBagLayout());
        GridBagConstraints labelConstraints = new GridBagConstraints();
        labelConstraints.anchor = 24;
        GridBagConstraints editConstraints = new GridBagConstraints();
        editConstraints.anchor = 23;
        editConstraints.weightx = 1.0;
        editConstraints.fill = 2;
        this.addToPanel(mainPanel, labelConstraints, 0, 0, new JLabel("Successful sample: ", 4));
        this.isSuccessful = new JCheckBox();
        this.addToPanel(mainPanel, editConstraints, 1, 0, this.isSuccessful);
        this.addToPanel(mainPanel, labelConstraints, 0, 1, new JLabel("Response Code (eg 200): ", 4));
        this.responseCode = new JTextField(20);
        this.addToPanel(mainPanel, editConstraints, 1, 1, this.responseCode);
        editConstraints.insets = new Insets(2, 0, 0, 0);
        labelConstraints.insets = new Insets(2, 0, 0, 0);
        this.addToPanel(mainPanel, labelConstraints, 0, 2, new JLabel("Response Message (eg OK): ", 4));
        this.responseMessage = new JTextField(20);
        this.addToPanel(mainPanel, editConstraints, 1, 2, this.responseMessage);
        this.addToPanel(mainPanel, labelConstraints, 0, 3, new JLabel("Connect Time (milliseconds): ", 4));
        this.connect = new JTextField(20);
        this.addToPanel(mainPanel, editConstraints, 1, 3, this.connect);
        this.addToPanel(mainPanel, labelConstraints, 0, 4, new JLabel("Latency (milliseconds): ", 4));
        this.latency = new JTextField(20);
        this.addToPanel(mainPanel, editConstraints, 1, 4, this.latency);
        this.addToPanel(mainPanel, labelConstraints, 0, 5, new JLabel("Response Time (milliseconds): ", 4));
        this.responseTime = new JTextField(20);
        this.addToPanel(mainPanel, editConstraints, 1, 5, this.responseTime);
        this.addToPanel(mainPanel, labelConstraints, 0, 6, new JLabel("Simulate Response Time (sleep): ", 4));
        this.isWaiting = new JCheckBox();
        this.addToPanel(mainPanel, editConstraints, 1, 6, this.isWaiting);
        editConstraints.insets = new Insets(4, 0, 0, 0);
        labelConstraints.insets = new Insets(4, 0, 0, 0);
        this.addToPanel(mainPanel, labelConstraints, 0, 7, new JLabel("Request Data: ", 4));
        editConstraints.fill = 1;
        this.requestData = new JTextArea();
        this.addToPanel(mainPanel, editConstraints, 1, 7, GuiBuilderHelper.getTextAreaScrollPaneContainer(this.requestData, 10));
        this.addToPanel(mainPanel, labelConstraints, 0, 8, new JLabel("Response Data: ", 4));
        editConstraints.fill = 1;
        this.responseData = new JTextArea();
        this.addToPanel(mainPanel, editConstraints, 1, 8, GuiBuilderHelper.getTextAreaScrollPaneContainer(this.responseData, 10));
        JPanel container = new JPanel(new BorderLayout());
        container.add((Component)mainPanel, "North");
        this.add(container, "Center");
    }

    private void addToPanel(JPanel panel, GridBagConstraints constraints, int col, int row, JComponent component) {
        constraints.gridx = col;
        constraints.gridy = row;
        panel.add((Component)component, constraints);
    }
}

