/*
 * Decompiled with CFR 0.152.
 */
package kg.apc.jmeter.timers;

import java.util.ArrayList;
import kg.apc.jmeter.JMeterPluginsUtils;
import org.apache.jmeter.engine.StandardJMeterEngine;
import org.apache.jmeter.engine.util.NoThreadClone;
import org.apache.jmeter.gui.util.PowerTableModel;
import org.apache.jmeter.testelement.AbstractTestElement;
import org.apache.jmeter.testelement.TestStateListener;
import org.apache.jmeter.testelement.property.CollectionProperty;
import org.apache.jmeter.testelement.property.JMeterProperty;
import org.apache.jmeter.testelement.property.NullProperty;
import org.apache.jmeter.testelement.property.PropertyIterator;
import org.apache.jmeter.threads.JMeterContextService;
import org.apache.jmeter.timers.Timer;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;

public class VariableThroughputTimer
extends AbstractTestElement
implements Timer,
NoThreadClone,
TestStateListener {
    public static final String[] columnIdentifiers = new String[]{"Start RPS", "End RPS", "Duration, sec"};
    public static final Class[] columnClasses = new Class[]{String.class, String.class, String.class};
    public static final String DATA_PROPERTY = "load_profile";
    public static final int DURATION_FIELD_NO = 2;
    public static final int FROM_FIELD_NO = 0;
    public static final int TO_FIELD_NO = 1;
    private static final Logger log = LoggingManager.getLoggerForClass();
    private int cntDelayed;
    private double time = 0.0;
    private double msecPerReq;
    private long cntSent;
    private double rps;
    private double startSec = 0.0;
    private CollectionProperty overrideProp;
    private int stopTries;
    private double lastStopTry;
    private boolean stopping;

    public VariableThroughputTimer() {
        this.trySettingLoadFromProperty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long delay() {
        VariableThroughputTimer variableThroughputTimer = this;
        synchronized (variableThroughputTimer) {
            while (true) {
                long curTime = System.currentTimeMillis();
                long msecs = curTime % 1000L;
                long secs = curTime - msecs;
                this.checkNextSecond(secs);
                int delay = this.getDelay(msecs);
                if (this.stopping) {
                    delay = delay > 0 ? 10 : 0;
                    ((Object)((Object)this)).notify();
                }
                if (delay < 1) break;
                ++this.cntDelayed;
                try {
                    ((Object)((Object)this)).wait(delay);
                }
                catch (InterruptedException ex) {
                    log.error("Waiting thread was interrupted", (Throwable)ex);
                }
                --this.cntDelayed;
            }
            ((Object)((Object)this)).notify();
            ++this.cntSent;
        }
        return 0L;
    }

    private synchronized void checkNextSecond(double secs) {
        if (this.time == secs) {
            return;
        }
        if (this.startSec == 0.0) {
            this.startSec = secs;
        }
        this.time = secs;
        double nextRps = this.getRPSForSecond((secs - this.startSec) / 1000.0);
        if (nextRps < 0.0) {
            this.stopping = true;
            this.rps = this.rps > 0.0 ? this.rps * (double)(this.stopTries > 10 ? 2 : 1) : 1.0;
            this.stopTest();
            ((Object)((Object)this)).notifyAll();
        } else {
            this.rps = nextRps;
        }
        if (log.isDebugEnabled()) {
            log.debug("Second changed " + (secs - this.startSec) / 1000.0 + ", sleeping: " + this.cntDelayed + ", sent " + this.cntSent + ", RPS: " + this.rps);
        }
        if (this.cntDelayed < 1) {
            log.warn("No free threads left in worker pool, made  " + this.cntSent + '/' + this.rps + " samples");
        }
        JMeterUtils.setProperty((String)(this.getName() + "_cntDelayed"), (String)String.valueOf(this.cntDelayed));
        JMeterUtils.setProperty((String)(this.getName() + "_cntSent"), (String)String.valueOf(this.cntSent));
        JMeterUtils.setProperty((String)(this.getName() + "_rps"), (String)String.valueOf(this.rps));
        this.cntSent = 0L;
        this.msecPerReq = 1000.0 / this.rps;
    }

    private int getDelay(long msecs) {
        if ((double)msecs < (double)this.cntSent * this.msecPerReq) {
            return (int)(1.0 + 1000.0 * (double)(this.cntDelayed + 1) / this.rps);
        }
        return 0;
    }

    public void setData(CollectionProperty rows) {
        this.setProperty((JMeterProperty)rows);
    }

    public JMeterProperty getData() {
        if (this.overrideProp != null) {
            return this.overrideProp;
        }
        return this.getProperty(DATA_PROPERTY);
    }

    public double getRPSForSecond(double sec) {
        JMeterProperty data = this.getData();
        if (data instanceof NullProperty) {
            return -1.0;
        }
        CollectionProperty rows = (CollectionProperty)data;
        PropertyIterator scheduleIT = rows.iterator();
        while (scheduleIT.hasNext()) {
            ArrayList curProp = (ArrayList)scheduleIT.next().getObjectValue();
            int duration = this.getIntValue(curProp, 2);
            double from = this.getDoubleValue(curProp, 0);
            double to = this.getDoubleValue(curProp, 1);
            if (sec - (double)duration <= 0.0) {
                return from + sec * (to - from) / (double)duration;
            }
            sec -= (double)duration;
        }
        return -1.0;
    }

    private double getDoubleValue(ArrayList<Object> prop, int colID) throws NumberFormatException {
        JMeterProperty val = (JMeterProperty)prop.get(colID);
        return val.getDoubleValue();
    }

    private int getIntValue(ArrayList<Object> prop, int colID) throws NumberFormatException {
        JMeterProperty val = (JMeterProperty)prop.get(colID);
        return val.getIntValue();
    }

    private void trySettingLoadFromProperty() {
        String loadProp = JMeterUtils.getProperty((String)DATA_PROPERTY);
        log.debug("Load prop: " + loadProp);
        if (loadProp != null && loadProp.length() > 0) {
            String[] chunks;
            log.info("GUI load profile will be ignored");
            PowerTableModel dataModel = new PowerTableModel(columnIdentifiers, columnClasses);
            for (String chunk : chunks = loadProp.split("\\)")) {
                try {
                    VariableThroughputTimer.parseChunk(chunk, dataModel);
                }
                catch (RuntimeException e) {
                    log.warn("Wrong load chunk ignored: " + chunk, (Throwable)e);
                }
            }
            log.info("Setting load profile from property load_profile: " + loadProp);
            this.overrideProp = JMeterPluginsUtils.tableModelRowsToCollectionProperty((PowerTableModel)dataModel, (String)DATA_PROPERTY);
        }
    }

    private static void parseChunk(String chunk, PowerTableModel model) {
        log.debug("Parsing chunk: " + chunk);
        String[] parts = chunk.split("[(,]");
        String loadVar = parts[0].trim();
        if (loadVar.equalsIgnoreCase("const")) {
            int const_load = Integer.parseInt(parts[1].trim());
            Object[] row = new Integer[]{const_load, const_load, JMeterPluginsUtils.getSecondsForShortString((String)parts[2])};
            model.addRow(row);
        } else if (loadVar.equalsIgnoreCase("line")) {
            Object[] row = new Integer[]{Integer.parseInt(parts[1].trim()), Integer.parseInt(parts[2].trim()), JMeterPluginsUtils.getSecondsForShortString((String)parts[3])};
            model.addRow(row);
        } else if (loadVar.equalsIgnoreCase("step")) {
            int from = Integer.parseInt(parts[1].trim());
            int to = Integer.parseInt(parts[2].trim());
            int inc = Integer.parseInt(parts[3].trim()) * (from > to ? -1 : 1);
            int n = from;
            while (inc > 0 ? n <= to : n > to) {
                Object[] row = new Integer[]{n, n, JMeterPluginsUtils.getSecondsForShortString((String)parts[4])};
                model.addRow(row);
                n += inc;
            }
        } else {
            throw new RuntimeException("Unknown load type: " + parts[0]);
        }
    }

    protected void stopTest() {
        if (this.stopTries > 30) {
            throw new RuntimeException("More than 30 seconds - stopping by exception");
        }
        if (this.lastStopTry == this.time) {
            return;
        }
        log.info("No further RPS schedule, asking threads to stop...");
        this.lastStopTry = this.time;
        ++this.stopTries;
        if (this.stopTries > 10) {
            log.info("Tries more than 10, stop it NOW!");
            StandardJMeterEngine.stopEngineNow();
        } else if (this.stopTries > 5) {
            log.info("Tries more than 5, stop it!");
            StandardJMeterEngine.stopEngine();
        } else {
            JMeterContextService.getContext().getEngine().askThreadsToStop();
        }
    }

    public void testStarted() {
        this.stopping = false;
        this.stopTries = 0;
    }

    public void testStarted(String string) {
        this.testStarted();
    }

    public void testEnded() {
    }

    public void testEnded(String string) {
        this.testEnded();
    }
}

