/*
 * Decompiled with CFR 0.152.
 */
package kg.apc.jmeter.timers.functions;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.apache.jmeter.engine.util.CompoundVariable;
import org.apache.jmeter.functions.AbstractFunction;
import org.apache.jmeter.functions.InvalidVariableException;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.samplers.Sampler;
import org.apache.jmeter.testelement.TestStateListener;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;

public class TSTFeedback
extends AbstractFunction
implements TestStateListener {
    private static final Logger log = LoggingManager.getLoggerForClass();
    private static final List<String> desc = new LinkedList<String>();
    private static final String KEY = "__tstFeedback";
    private static final int MIN_PARAMETER_COUNT = 2;
    private CompoundVariable[] values;
    private boolean justStarted = true;

    public synchronized String execute(SampleResult previousResult, Sampler currentSampler) throws InvalidVariableException {
        String tstName = this.values[0].execute();
        String concName = tstName + "_concurrency";
        if (this.justStarted) {
            JMeterUtils.setProperty((String)concName, (String)String.valueOf(this.values[1].execute()));
            this.justStarted = false;
        }
        int limit = Integer.MAX_VALUE;
        if (this.values.length > 2) {
            try {
                limit = Integer.parseInt(this.values[2].execute());
            }
            catch (NumberFormatException exc) {
                log.debug("Failed to parse value for limit, defaulting to infinity", (Throwable)exc);
            }
        }
        double spare = 0.1;
        if (this.values.length > 3) {
            try {
                spare = Double.parseDouble(this.values[3].execute());
            }
            catch (NumberFormatException exc) {
                log.debug("Failed to parse value for spare ratio, defaulting to 0", (Throwable)exc);
                spare = 1.0;
            }
        }
        int con = Integer.parseInt(JMeterUtils.getPropDefault((String)concName, (String)"1"));
        int delayed = Integer.parseInt(JMeterUtils.getPropDefault((String)(tstName + "_cntDelayed"), (String)"0"));
        int sent = Integer.parseInt(JMeterUtils.getPropDefault((String)(tstName + "_cntSent"), (String)"0"));
        float rps = Float.parseFloat(JMeterUtils.getPropDefault((String)(tstName + "_rps"), (String)"0"));
        int needed = con;
        if (!(rps <= 0.0f)) {
            if (delayed > 0) {
                needed = this.decreaseNeeded(spare, con, delayed, needed);
            } else if ((float)sent < rps && (needed = (int)Math.ceil((float)con * (2.0f - (float)sent / rps))) > limit) {
                needed = limit;
            }
        }
        if (needed != con && log.isDebugEnabled()) {
            log.debug("Need to change " + concName + ": " + con + "=>" + needed + " (" + sent + "/" + rps + "/" + delayed + ")");
        }
        JMeterUtils.setProperty((String)concName, (String)String.valueOf(needed));
        JMeterUtils.setProperty((String)(tstName + "_rps"), (String)"0");
        return String.valueOf(needed);
    }

    private int decreaseNeeded(double spare, int con, int delayed, int needed) {
        if (spare >= 1.0) {
            if ((double)delayed > spare) {
                needed = (int)((double)needed - ((double)delayed - spare));
            }
        } else if ((double)delayed > Math.ceil((double)con * spare)) {
            needed = (int)((double)con * (1.0 - spare));
        }
        return needed;
    }

    public synchronized void setParameters(Collection<CompoundVariable> parameters) throws InvalidVariableException {
        this.checkParameterCount(parameters, 2, desc.size());
        this.values = parameters.toArray(new CompoundVariable[0]);
    }

    public String getReferenceKey() {
        return KEY;
    }

    public List<String> getArgumentDesc() {
        return desc;
    }

    public void testStarted() {
        this.testStarted("*local*");
    }

    public void testStarted(String s) {
        this.justStarted = true;
    }

    public void testEnded() {
        this.testEnded("*local*");
    }

    public void testEnded(String s) {
    }

    static {
        desc.add("Name of Throughput Shaping Timer to integrate with");
        desc.add("Starting concurrency");
        desc.add("Max concurrency");
        desc.add("Spare threads ratio");
    }
}

