/*
 * Decompiled with CFR 0.152.
 */
package kg.apc.jmeter.timers;

import java.util.List;
import kg.apc.jmeter.JMeterPluginsUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.jmeter.engine.StandardJMeterEngine;
import org.apache.jmeter.engine.util.NoThreadClone;
import org.apache.jmeter.gui.util.PowerTableModel;
import org.apache.jmeter.testelement.AbstractTestElement;
import org.apache.jmeter.testelement.TestStateListener;
import org.apache.jmeter.testelement.property.CollectionProperty;
import org.apache.jmeter.testelement.property.JMeterProperty;
import org.apache.jmeter.testelement.property.NullProperty;
import org.apache.jmeter.testelement.property.PropertyIterator;
import org.apache.jmeter.threads.AbstractThreadGroup;
import org.apache.jmeter.threads.JMeterContextService;
import org.apache.jmeter.timers.Timer;
import org.apache.jmeter.util.JMeterUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VariableThroughputTimer
extends AbstractTestElement
implements Timer,
NoThreadClone,
TestStateListener {
    private static final long serialVersionUID = -8557540133988335686L;
    protected static final String[] columnIdentifiers = new String[]{"Start RPS", "End RPS", "Duration, sec"};
    protected static final Class[] columnClasses = new Class[]{String.class, String.class, String.class};
    public static final String DATA_PROPERTY = "load_profile";
    public static final int DURATION_FIELD_NO = 2;
    public static final int FROM_FIELD_NO = 0;
    public static final int TO_FIELD_NO = 1;
    private static final Logger log = LoggerFactory.getLogger(VariableThroughputTimer.class);
    private int cntDelayed;
    private double time = 0.0;
    private double msecPerReq;
    private long cntSent;
    private double rps;
    private double startSec = 0.0;
    private CollectionProperty overrideProp;
    private int stopTries;
    private double lastStopTry;
    private boolean stopping;

    public VariableThroughputTimer() {
        this.trySettingLoadFromProperty();
    }

    public synchronized long delay() {
        while (true) {
            long curTimeMs = System.currentTimeMillis();
            long millisSinceLastSecond = curTimeMs % 1000L;
            long nowInMsRoundedAtSec = curTimeMs - millisSinceLastSecond;
            this.checkNextSecond(nowInMsRoundedAtSec);
            int delayMs = this.getDelay(millisSinceLastSecond);
            if (this.stopping) {
                delayMs = delayMs > 0 ? 10 : 0;
                ((Object)((Object)this)).notifyAll();
            }
            if (delayMs < 1) break;
            ++this.cntDelayed;
            try {
                ((Object)((Object)this)).wait(delayMs);
            }
            catch (InterruptedException ex) {
                log.debug("Waiting thread was interrupted", (Throwable)ex);
                Thread.currentThread().interrupt();
            }
            --this.cntDelayed;
        }
        ((Object)((Object)this)).notifyAll();
        ++this.cntSent;
        return 0L;
    }

    private synchronized void checkNextSecond(double nowInMsRoundedAtSec) {
        if (this.time == nowInMsRoundedAtSec) {
            return;
        }
        if (this.startSec == 0.0) {
            this.startSec = nowInMsRoundedAtSec;
        }
        this.time = nowInMsRoundedAtSec;
        Pair<Double, Long> pair = this.getRPSForSecond((nowInMsRoundedAtSec - this.startSec) / 1000.0);
        double nextRps = (Double)pair.getLeft();
        if (nextRps < 0.0) {
            this.stopping = true;
            int factor = this.stopTries > 10 ? 2 : 1;
            this.rps = this.rps > 0.0 ? this.rps * (double)factor : 1.0;
            this.stopTest();
            ((Object)((Object)this)).notifyAll();
        } else {
            this.rps = nextRps;
        }
        if (log.isDebugEnabled()) {
            log.debug("Second changed {} , waiting: {}, samples sent {}, current rps: {} rps", new Object[]{(nowInMsRoundedAtSec - this.startSec) / 1000.0, this.cntDelayed, this.cntSent, this.rps});
        }
        if (this.cntDelayed < 1) {
            log.warn("No free threads available in current Thread Group, made {} samples/s for expected rps {} samples/s, increase your number of threads", (Object)this.cntSent, (Object)this.rps);
        }
        String elementName = this.getName();
        JMeterUtils.setProperty((String)(elementName + "_totalDuration"), (String)String.valueOf(pair.getRight()));
        JMeterUtils.setProperty((String)(elementName + "_cntDelayed"), (String)String.valueOf(this.cntDelayed));
        JMeterUtils.setProperty((String)(elementName + "_cntSent"), (String)String.valueOf(this.cntSent));
        JMeterUtils.setProperty((String)(elementName + "_rps"), (String)String.valueOf(this.rps));
        this.cntSent = 0L;
        this.msecPerReq = 1000.0 / this.rps;
    }

    private int getDelay(long millisSinceLastSecond) {
        if (log.isDebugEnabled()) {
            log.debug("Calculating {} {} {}", new Object[]{millisSinceLastSecond, (double)this.cntSent * this.msecPerReq, this.cntSent});
        }
        if ((double)millisSinceLastSecond < (double)this.cntSent * this.msecPerReq) {
            return (int)(1.0 + 1000.0 * (double)(this.cntDelayed + 1) / this.rps);
        }
        return 0;
    }

    public void setData(CollectionProperty rows) {
        this.setProperty((JMeterProperty)rows);
    }

    public JMeterProperty getData() {
        if (this.overrideProp != null) {
            return this.overrideProp;
        }
        return this.getProperty(DATA_PROPERTY);
    }

    public Pair<Double, Long> getRPSForSecond(double elapsedSinceStartOfTestSec) {
        JMeterProperty data = this.getData();
        if (data instanceof NullProperty) {
            return Pair.of((Object)-1.0, (Object)0L);
        }
        CollectionProperty rows = (CollectionProperty)data;
        PropertyIterator scheduleIT = rows.iterator();
        double newSec = elapsedSinceStartOfTestSec;
        double result = -1.0;
        boolean resultComputed = false;
        long totalDuration = 0L;
        while (scheduleIT.hasNext()) {
            List curProp = (List)scheduleIT.next().getObjectValue();
            int duration = this.getIntValue(curProp, 2);
            totalDuration += (long)duration;
            if (resultComputed) continue;
            double fromRps = this.getDoubleValue(curProp, 0);
            double toRps = this.getDoubleValue(curProp, 1);
            if (newSec - (double)duration <= 0.0) {
                result = fromRps + newSec * (toRps - fromRps) / (double)duration;
                resultComputed = true;
                continue;
            }
            newSec -= (double)duration;
        }
        return Pair.of((Object)result, (Object)totalDuration);
    }

    private double getDoubleValue(List<Object> prop, int colID) {
        JMeterProperty val = (JMeterProperty)prop.get(colID);
        return val.getDoubleValue();
    }

    private int getIntValue(List<Object> prop, int colID) {
        JMeterProperty val = (JMeterProperty)prop.get(colID);
        return val.getIntValue();
    }

    private void trySettingLoadFromProperty() {
        String loadProp = JMeterUtils.getProperty((String)DATA_PROPERTY);
        log.debug("Loading property: {}={}", (Object)DATA_PROPERTY, (Object)loadProp);
        if (!StringUtils.isEmpty((CharSequence)loadProp)) {
            String[] chunks;
            log.info("GUI load profile will be ignored as property {} is defined", (Object)DATA_PROPERTY);
            PowerTableModel dataModel = new PowerTableModel(columnIdentifiers, columnClasses);
            for (String chunk : chunks = loadProp.split("\\)")) {
                try {
                    VariableThroughputTimer.parseChunk(chunk, dataModel);
                }
                catch (RuntimeException e) {
                    log.warn("Wrong load chunk {} will be ignored", (Object)chunk, (Object)e);
                }
            }
            log.info("Setting load profile from property {}: {}", (Object)DATA_PROPERTY, (Object)loadProp);
            this.overrideProp = JMeterPluginsUtils.tableModelRowsToCollectionProperty((PowerTableModel)dataModel, (String)DATA_PROPERTY);
        }
    }

    private static void parseChunk(String chunk, PowerTableModel model) {
        log.debug("Parsing chunk: {}", (Object)chunk);
        String[] parts = chunk.split("[(,]");
        String loadVar = parts[0].trim();
        if (loadVar.equalsIgnoreCase("const")) {
            int constLoad = Integer.parseInt(parts[1].trim());
            Object[] row = new Integer[]{constLoad, constLoad, JMeterPluginsUtils.getSecondsForShortString((String)parts[2])};
            model.addRow(row);
        } else if (loadVar.equalsIgnoreCase("line")) {
            Object[] row = new Integer[]{Integer.parseInt(parts[1].trim()), Integer.parseInt(parts[2].trim()), JMeterPluginsUtils.getSecondsForShortString((String)parts[3])};
            model.addRow(row);
        } else if (loadVar.equalsIgnoreCase("step")) {
            int from = Integer.parseInt(parts[1].trim());
            int to = Integer.parseInt(parts[2].trim());
            int inc = Integer.parseInt(parts[3].trim()) * (from > to ? -1 : 1);
            log.debug("step from {} to {}\u00a0with step {}", new Object[]{from, to, inc});
            int n = from;
            while (inc > 0 ? n <= to : n > to) {
                Object[] row = new Integer[]{n, n, JMeterPluginsUtils.getSecondsForShortString((String)parts[4])};
                log.debug("Adding row from {} to {}\u00a0with duration {}s", new Object[]{row[0], row[1], row[2]});
                model.addRow(row);
                n += inc;
            }
        } else {
            throw new IllegalArgumentException("Unknown load type: " + parts[0]);
        }
    }

    protected void stopTest() {
        if (this.stopTries > 30) {
            throw new IllegalStateException("More than 30 retries - stopping with exception");
        }
        if (this.lastStopTry == this.time) {
            return;
        }
        log.info("No further RPS schedule, asking threads to stop...");
        this.lastStopTry = this.time;
        ++this.stopTries;
        if (this.stopTries > 10) {
            log.info("Tries more than 10, stopping engine NOW!");
            StandardJMeterEngine.stopEngineNow();
        } else if (this.stopTries > 5) {
            log.info("Tries more than 5, shutting down engine!");
            StandardJMeterEngine.stopEngine();
        } else if (this.stopTries > 3) {
            AbstractThreadGroup threadGroup = JMeterContextService.getContext().getThreadGroup();
            log.info("Tries more than 3, hard stopping threads of Thread Group : {}", (Object)threadGroup.getName());
            threadGroup.tellThreadsToStop();
        } else {
            AbstractThreadGroup threadGroup = JMeterContextService.getContext().getThreadGroup();
            log.info("Stopping gracefuly threads of Thread Group : {}", (Object)threadGroup.getName());
            threadGroup.stop();
        }
    }

    public void testStarted() {
        this.stopping = false;
        this.stopTries = 0;
    }

    public void testStarted(String string) {
        this.testStarted();
    }

    public void testEnded() {
    }

    public void testEnded(String string) {
        this.testEnded();
    }
}

