/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jmeter.plugins.webdriver.config;

import com.googlecode.jmeter.plugins.webdriver.config.WebDriverConfig;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.ie.InternetExplorerDriver;
import org.openqa.selenium.ie.InternetExplorerDriverService;
import org.openqa.selenium.remote.DesiredCapabilities;

public class InternetExplorerDriverConfig
extends WebDriverConfig<InternetExplorerDriver> {
    private static final long serialVersionUID = 100L;
    private static final Logger LOGGER = LoggingManager.getLoggerForClass();
    private static final String IE_SERVICE_PATH = "InternetExplorerDriverConfig.iedriver_path";
    private static final Map<String, InternetExplorerDriverService> services = new ConcurrentHashMap<String, InternetExplorerDriverService>();

    public void setInternetExplorerDriverPath(String path) {
        this.setProperty(IE_SERVICE_PATH, path);
    }

    public String getInternetExplorerDriverPath() {
        return this.getPropertyAsString(IE_SERVICE_PATH);
    }

    Capabilities createCapabilities() {
        DesiredCapabilities capabilities = new DesiredCapabilities();
        capabilities.setCapability("proxy", (Object)this.createProxy());
        return capabilities;
    }

    Map<String, InternetExplorerDriverService> getServices() {
        return services;
    }

    @Override
    protected InternetExplorerDriver createBrowser() {
        InternetExplorerDriverService service = this.getThreadService();
        return service != null ? new InternetExplorerDriver(service, this.createCapabilities()) : null;
    }

    @Override
    public void quitBrowser(InternetExplorerDriver browser) {
        super.quitBrowser(browser);
        InternetExplorerDriverService service = services.remove(this.currentThreadName());
        if (service != null && service.isRunning()) {
            service.stop();
        }
    }

    private InternetExplorerDriverService getThreadService() {
        InternetExplorerDriverService service = services.get(this.currentThreadName());
        if (service != null) {
            return service;
        }
        try {
            service = (InternetExplorerDriverService)((InternetExplorerDriverService.Builder)new InternetExplorerDriverService.Builder().usingDriverExecutable(new File(this.getInternetExplorerDriverPath()))).build();
            service.start();
            services.put(this.currentThreadName(), service);
        }
        catch (IOException e) {
            LOGGER.error("Failed to start chrome service");
            service = null;
        }
        return service;
    }
}

