/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jmeter.plugins.webdriver.config;

import com.googlecode.jmeter.plugins.webdriver.config.RemoteCapability;
import org.openqa.selenium.chrome.ChromeOptions;
import org.openqa.selenium.firefox.FirefoxProfile;
import org.openqa.selenium.remote.DesiredCapabilities;

public class RemoteDesiredCapabilitiesFactory {
    public static DesiredCapabilities build(RemoteCapability capability) {
        if (RemoteCapability.CHROME.equals((Object)capability)) {
            ChromeOptions options = new ChromeOptions();
            DesiredCapabilities desiredCapabilities = DesiredCapabilities.chrome();
            desiredCapabilities.setCapability("chromeOptions", (Object)options);
            return desiredCapabilities;
        }
        if (RemoteCapability.FIREFOX.equals((Object)capability)) {
            FirefoxProfile profile = new FirefoxProfile();
            DesiredCapabilities desiredCapabilities = DesiredCapabilities.firefox();
            desiredCapabilities.setCapability("firefox_profile", (Object)profile);
            return desiredCapabilities;
        }
        if (RemoteCapability.INTERNET_EXPLORER.equals((Object)capability)) {
            DesiredCapabilities desiredCapabilities = DesiredCapabilities.internetExplorer();
            return desiredCapabilities;
        }
        throw new IllegalArgumentException("No such capability");
    }
}

